/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.commands;

import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.appdef.shared.InvalidAppdefTypeException;
import org.hyperic.hq.measurement.agent.commands.ScheduleMeasurements_metric;
import org.hyperic.hq.measurement.server.session.SRN;

public class ScheduleMeasurements_args
extends AgentRemoteValue {
    private static final String PARAM_DSN = "dsn";
    private static final String PARAM_INTERVAL = "interval";
    private static final String PARAM_DERIVED_ID = "derivedID";
    private static final String PARAM_SRN_ENT = "srnEnt";
    private static final String PARAM_SRN_ID = "srnID";
    private static final String PARAM_DSN_ID = "dsnID";
    private static final String PARAM_NMEAS = "nmeas";
    private static final String PARAM_CATEGORY = "category";
    private static final String PARAM_UNITS = "units";

    private void setup() {
        this.setNumMeasurements(0);
        AppdefEntityID ent = AppdefEntityID.newPlatformID(new Integer(0));
        this.setSRN(new SRN(ent, 0));
    }

    public ScheduleMeasurements_args() {
        this.setup();
    }

    public ScheduleMeasurements_args(AgentRemoteValue args) throws AgentRemoteException {
        AppdefEntityID ent;
        this.setup();
        int nmeas = args.getValueAsInt(PARAM_NMEAS);
        String sEnt = args.getValue(PARAM_SRN_ENT);
        int srnID = args.getValueAsInt(PARAM_SRN_ID);
        try {
            ent = new AppdefEntityID(sEnt);
        }
        catch (InvalidAppdefTypeException exc) {
            throw new AgentRemoteException("Invalid SRN entity: " + exc.getMessage());
        }
        this.setSRN(new SRN(ent, srnID));
        for (int i = 0; i < nmeas; ++i) {
            String dsn = args.getValue(PARAM_DSN + i);
            long ival = args.getValueAsLong(PARAM_INTERVAL + i);
            long derID = args.getValueAsLong(PARAM_DERIVED_ID + i);
            long dsnID = args.getValueAsLong(PARAM_DSN_ID + i);
            String category = args.getValue(PARAM_CATEGORY + i);
            String units = args.getValue(PARAM_UNITS + i);
            if (category == null) {
                category = "";
            }
            this.addMeasurement(dsn, ival, derID, dsnID, category, units);
        }
    }

    public int getNumMeasurements() {
        String val = this.getValue(PARAM_NMEAS);
        return Integer.parseInt(val);
    }

    private void setNumMeasurements(int newMeas) {
        super.setValue(PARAM_NMEAS, Integer.toString(newMeas));
    }

    public void setSRN(SRN srn) {
        super.setValue(PARAM_SRN_ID, Integer.toString(srn.getRevisionNumber()));
        super.setValue(PARAM_SRN_ENT, srn.getEntity().getAppdefKey());
    }

    public void addMeasurement(String dsn, long interval, long derivedID, long dsnID, String category, String units) {
        int curMeas = this.getNumMeasurements();
        super.setValue(PARAM_DSN + curMeas, dsn);
        super.setValue(PARAM_INTERVAL + curMeas, Long.toString(interval));
        super.setValue(PARAM_DERIVED_ID + curMeas, Long.toString(derivedID));
        super.setValue(PARAM_DSN_ID + curMeas, Long.toString(dsnID));
        super.setValue(PARAM_CATEGORY + curMeas, category);
        super.setValue(PARAM_UNITS + curMeas, units);
        this.setNumMeasurements(curMeas + 1);
    }

    @Override
    public void setValue(String key, String val) {
        throw new AgentAssertionException("This should never be called");
    }

    public ScheduleMeasurements_metric getMeasurement(int measNum) {
        return new ScheduleMeasurements_metric(this.getDSN(measNum), this.getInterval(measNum), this.getDerivedID(measNum), this.getDSNId(measNum), this.getCategory(measNum), this.getUnits(measNum));
    }

    private String getDSN(int measNum) {
        String qval = PARAM_DSN + measNum;
        String res = this.getValue(qval);
        return res;
    }

    private long getInterval(int measNum) {
        try {
            String qval = PARAM_INTERVAL + measNum;
            return this.getValueAsLong(qval);
        }
        catch (AgentRemoteException exc) {
            throw new AgentAssertionException("Object accessed even though construction failed");
        }
    }

    private long getDerivedID(int measNum) {
        try {
            String qval = PARAM_DERIVED_ID + measNum;
            return this.getValueAsLong(qval);
        }
        catch (AgentRemoteException exc) {
            throw new AgentAssertionException("Object accessed even though construction failed");
        }
    }

    public SRN getSRN() {
        try {
            String qval = PARAM_SRN_ENT;
            String qval2 = PARAM_SRN_ID;
            AppdefEntityID ent = new AppdefEntityID(this.getValue(qval));
            return new SRN(ent, this.getValueAsInt(qval2));
        }
        catch (InvalidAppdefTypeException exc) {
            throw new AgentAssertionException("Object accessed even though construction failed");
        }
        catch (AgentRemoteException exc) {
            throw new AgentAssertionException("Object accessed even though construction failed");
        }
    }

    private long getDSNId(int measNum) {
        try {
            String qval = PARAM_DSN_ID + measNum;
            return this.getValueAsLong(qval);
        }
        catch (AgentRemoteException exc) {
            throw new AgentAssertionException("Object accessed even though construction failed");
        }
    }

    private String getCategory(int measNum) {
        String qval = PARAM_CATEGORY + measNum;
        String res = this.getValue(qval);
        return res;
    }

    private String getUnits(int measNum) {
        String qval = PARAM_UNITS + measNum;
        String res = this.getValue(qval);
        return res;
    }
}

