/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.shared;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.measurement.shared.MeasRange;
import org.hyperic.hq.measurement.shared.MeasRangeObj;
import org.hyperic.util.jdbc.DBUtil;

public class MeasTabManagerUtil {
    private static Calendar _baseCal = Calendar.getInstance();
    private static final String logCtx = MeasTabManagerUtil.class.getName();
    private static final Log _log = LogFactory.getLog((String)logCtx);
    public static final int NUMBER_OF_TABLES = 18;
    public static final int NUMBER_OF_TABLES_PER_DAY = 2;
    public static final String MEAS_TABLE = "HQ_METRIC_DATA";
    public static final String MEAS_VIEW = "HQ_METRIC_DATA";
    public static final String OLD_MEAS_TABLE = "HQ_METRIC_DATA_COMPAT";
    private static final String TAB_MEAS = "EAM_MEASUREMENT";

    public static long getBaseTime() {
        return _baseCal.getTimeInMillis();
    }

    public static MeasRange[] getMetricRanges(long begin, long end) {
        List<MeasRange> ranges = MeasRangeObj.getInstance().getRanges();
        ArrayList<MeasRange> rtn = new ArrayList<MeasRange>(ranges.size());
        for (MeasRange range : ranges) {
            long rBegin = range.getMinTimestamp();
            long rEnd = range.getMaxTimestamp();
            if (begin > rEnd || end < rBegin) continue;
            rtn.add(range);
        }
        return rtn.toArray(new MeasRange[0]);
    }

    public static String[] getMetricTables(long begin, long end) {
        List<MeasRange> ranges = MeasRangeObj.getInstance().getRanges();
        String[] tables = new String[ranges.size()];
        int i = 0;
        for (MeasRange range : ranges) {
            long rBegin = range.getMinTimestamp();
            long rEnd = range.getMaxTimestamp();
            if (begin > rEnd || end < rBegin) continue;
            tables[i++] = range.getTable();
        }
        String[] retTables = new String[i];
        for (i = 0; i < retTables.length; ++i) {
            retTables[i] = tables[i];
        }
        return retTables;
    }

    public static String getMeasInStmt(Collection<Integer> measIds, boolean prependAnd) {
        if (measIds.isEmpty()) {
            return "";
        }
        StringBuilder rtn = new StringBuilder();
        rtn.append(" " + (prependAnd ? "AND" : "") + " measurement_id");
        if (measIds.size() == 1) {
            rtn.append(" = " + measIds.iterator().next());
            return rtn.toString();
        }
        rtn.append(" in (");
        for (Integer measId : measIds) {
            if (measId == null) continue;
            rtn.append(measId).append(",");
        }
        rtn.deleteCharAt(rtn.length() - 1);
        rtn.append(")");
        return rtn.toString();
    }

    public static String getMeasInStmt(Integer[] measIds, boolean prependAnd) {
        if (measIds.length == 0) {
            return "";
        }
        StringBuilder rtn = new StringBuilder();
        rtn.append(" " + (prependAnd ? "AND" : "") + " measurement_id");
        if (measIds.length == 1) {
            rtn.append(" = " + measIds[0]);
            return rtn.toString();
        }
        rtn.append(" in (");
        for (int i = 0; i < measIds.length; ++i) {
            if (measIds[i] == null) continue;
            rtn.append(measIds[i]).append(",");
        }
        rtn.deleteCharAt(rtn.length() - 1);
        rtn.append(")");
        return rtn.toString();
    }

    private static int getDayOfPeriod(Calendar cal, long timems) {
        int rtn = 0;
        cal.clear();
        cal.setTime(new Date(timems));
        Calendar currCal = Calendar.getInstance();
        currCal.setTime(new Date(timems));
        while (cal.get(1) >= _baseCal.get(1)) {
            rtn = cal.get(1) == currCal.get(1) ? (rtn += currCal.get(6)) : (rtn += cal.get(6));
            cal.add(1, -1);
            cal.set(2, 11);
            cal.set(5, 31);
            cal.set(11, 23);
            cal.set(12, 0);
        }
        return rtn;
    }

    public static String getMeasTabname(long timems) {
        Calendar cal = Calendar.getInstance();
        return MeasTabManagerUtil.getMeasTabname(cal, timems);
    }

    public static String getMeasTabname(Calendar cal, long timems) {
        int dayofperiod = MeasTabManagerUtil.getDayOfPeriod(cal, timems);
        cal.clear();
        cal.setTime(new Date(timems));
        _log.debug((Object)("dayofperiod -> " + dayofperiod));
        int hourofday = cal.get(11);
        int numdaytables = 9;
        int daytable = dayofperiod % numdaytables;
        int dayincr = 12;
        int dayslice = 0;
        for (int i = dayincr; i < 24 && hourofday >= i; i += dayincr) {
            ++dayslice;
        }
        return "HQ_METRIC_DATA_" + daytable + "D_" + dayslice + "S";
    }

    public static long getMeasTabEndTime(Calendar cal, long timems) {
        int incr;
        cal.clear();
        cal.setTime(new Date(timems));
        for (int i = incr = 12; i <= 24; i += incr) {
            if (cal.get(11) >= i) continue;
            cal.set(11, i - 1);
            break;
        }
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTimeInMillis();
    }

    public static long getMeasTabEndTime(long timems) {
        Calendar cal = Calendar.getInstance();
        return MeasTabManagerUtil.getMeasTabEndTime(cal, timems);
    }

    public static long getMeasTabStartTime(Calendar cal, long timems) {
        int incr;
        cal.clear();
        cal.setTime(new Date(timems));
        for (int i = incr = 12; i <= 24; i += incr) {
            if (cal.get(11) >= i) continue;
            cal.set(11, i - incr);
            break;
        }
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long getMeasTabStartTime(long timems) {
        Calendar cal = Calendar.getInstance();
        return MeasTabManagerUtil.getMeasTabStartTime(cal, timems);
    }

    public static long getPrevMeasTabTime(long timems) {
        Calendar cal = Calendar.getInstance();
        return MeasTabManagerUtil.getPrevMeasTabTime(cal, timems);
    }

    public static long getPrevMeasTabTime(Calendar cal, long timems) {
        String newTable;
        cal.clear();
        cal.setTime(new Date(timems));
        long rtn = -1L;
        String currTable = MeasTabManagerUtil.getMeasTabname(timems);
        _log.debug((Object)("(getPrevMeasTabTime) before -> " + MeasTabManagerUtil.getDateStr(timems) + ", " + currTable));
        int incr = 4;
        incr = (incr < 1 ? 1 : incr) * -1;
        do {
            cal.add(11, incr);
            rtn = cal.getTimeInMillis();
            _log.debug((Object)("subtracting 1 hour: " + MeasTabManagerUtil.getDateStr(rtn)));
        } while (currTable.equals(newTable = MeasTabManagerUtil.getMeasTabname(rtn)));
        _log.debug((Object)("(getPrevMeasTabTime) after -> " + MeasTabManagerUtil.getDateStr(rtn) + ", " + newTable));
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getMeasIdsFromTemplateIds(Connection conn, Integer[] tids) throws SQLException {
        ArrayList<Integer> rtn = new ArrayList<Integer>();
        StringBuffer tidsConj = new StringBuffer(DBUtil.composeConjunctions((String)"template_id", (int)tids.length));
        DBUtil.replacePlaceHolders((StringBuffer)tidsConj, (Object[])tids);
        String sql = new StringBuilder(tidsConj.length() + 64).append("SELECT distinct id FROM ").append(TAB_MEAS).append(" WHERE ").append(tidsConj).toString();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                rtn.add(new Integer(rs.getInt(1)));
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet((Object)logCtx, rs);
            DBUtil.closeStatement((Object)logCtx, (Statement)stmt);
            throw throwable;
        }
        DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
        DBUtil.closeStatement((Object)logCtx, (Statement)stmt);
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getMeasIds(Connection conn, Integer[] tids, Integer[] iids) throws SQLException {
        ArrayList<Integer> rtn = new ArrayList<Integer>();
        StringBuffer iidsConj = new StringBuffer(DBUtil.composeConjunctions((String)"instance_id", (int)iids.length));
        DBUtil.replacePlaceHolders((StringBuffer)iidsConj, (Object[])iids);
        StringBuffer tidsConj = new StringBuffer(DBUtil.composeConjunctions((String)"template_id", (int)tids.length));
        DBUtil.replacePlaceHolders((StringBuffer)tidsConj, (Object[])tids);
        String sql = new StringBuilder(iidsConj.length() + tidsConj.length() + 64).append("SELECT distinct id FROM ").append(TAB_MEAS).append(" WHERE ").append(iidsConj).append(" AND ").append(tidsConj).toString();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                rtn.add(new Integer(rs.getInt(1)));
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet((Object)logCtx, rs);
            DBUtil.closeStatement((Object)logCtx, (Statement)stmt);
            throw throwable;
        }
        DBUtil.closeResultSet((Object)logCtx, (ResultSet)rs);
        DBUtil.closeStatement((Object)logCtx, (Statement)stmt);
        return rtn;
    }

    public static void main(String[] args) {
        long regressTime = System.currentTimeMillis() + 180000000L;
        for (int i = 0; i < 2000; ++i) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(regressTime));
            cal.add(6, 9);
            regressTime = cal.getTimeInMillis();
            String firstTable = MeasTabManagerUtil.getMeasTabname(regressTime);
            String[] a = firstTable.split("_");
            int prevslice = Integer.parseInt(a[4].substring(0, 1));
            int prevday = Integer.parseInt(a[3].substring(0, 1));
            int prevyear = MeasTabManagerUtil.getYear(regressTime);
            long currTime = MeasTabManagerUtil.getPrevMeasTabTime(regressTime);
            String currTable = MeasTabManagerUtil.getMeasTabname(currTime);
            long prevTime = 0L;
            String prevTable = null;
            System.out.println("Number: " + i);
            System.out.println("Date: " + MeasTabManagerUtil.getDateStr(regressTime));
            System.out.println("First Table: " + firstTable);
            do {
                System.out.println(currTable);
                a = currTable.split("_");
                boolean rollslice = prevslice == 0;
                int currslice = Integer.parseInt(a[4].substring(0, 1));
                int currday = Integer.parseInt(a[3].substring(0, 1));
                int curryear = MeasTabManagerUtil.getYear(currTime);
                if (prevTable != null && prevTable.equals(currTable)) {
                    System.out.println("ERROR: " + prevTable + " == " + currTable);
                    System.exit(1);
                } else if (currslice == 1 && prevslice != 0 || currslice == prevslice) {
                    System.out.println("slice ERROR:\nFirst -> " + MeasTabManagerUtil.getDateStr(regressTime) + ", " + firstTable + "\nPrevious -> " + MeasTabManagerUtil.getDateStr(prevTime) + ", " + prevTable + "\nCurrent -> " + MeasTabManagerUtil.getDateStr(currTime) + ", " + currTable);
                    System.out.println("Current slice -> " + currslice);
                    System.out.println("Previous slice -> " + prevslice);
                    System.exit(1);
                } else if (rollslice && currday != 8 && prevday == 0 || rollslice && currday != prevday - 1 && prevday != 0) {
                    System.out.println("day ERROR:\nFirst -> " + MeasTabManagerUtil.getDateStr(regressTime) + ", " + firstTable + "\nPrevious -> " + MeasTabManagerUtil.getDateStr(prevTime) + ", " + prevTable + "\nCurrent -> " + MeasTabManagerUtil.getDateStr(currTime) + ", " + currTable);
                    System.out.println("Current Day -> " + currday);
                    System.out.println("Previous Day -> " + prevday);
                    System.out.println("Current Year -> " + curryear);
                    System.out.println("Previous Year -> " + prevyear);
                    System.exit(1);
                }
                prevslice = currslice;
                prevday = currday;
                prevTable = currTable;
                prevTime = currTime;
                currTime = MeasTabManagerUtil.getPrevMeasTabTime(currTime);
                currTable = MeasTabManagerUtil.getMeasTabname(currTime);
                prevyear = curryear;
            } while (!firstTable.equals(currTable));
            System.out.println("End -> " + currTable);
        }
        System.out.println(MeasTabManagerUtil.getDateStr(regressTime));
    }

    private static int getYear(long timems) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(timems));
        return cal.get(1);
    }

    private static String getDateStr(long timems) {
        return DateFormat.getDateTimeInstance(3, 3).format(new Date(timems));
    }

    static {
        _baseCal.set(2006, 0, 1, 0, 0);
    }
}

