/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.hq.plugin.system.ProcessData;
import org.hyperic.hq.plugin.system.UptimeData;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.ProcStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.Swap;
import org.hyperic.sigar.ptql.ProcessFinder;

public class TopData {
    private UptimeData _uptime;
    private ProcStat _procStat;
    private CpuPerc _cpu;
    private Mem _mem;
    private Swap _swap;
    private List<ProcessData> _processes;

    public void populate(SigarProxy sigar, String filter) throws SigarException {
        this._uptime = UptimeData.gather(sigar);
        this._procStat = sigar.getProcStat();
        this._cpu = sigar.getCpuPerc();
        this._mem = sigar.getMem();
        this._swap = sigar.getSwap();
        this.ps(sigar, filter);
    }

    private void ps(SigarProxy sigar, String filter) throws SigarException {
        this._processes = new ArrayList<ProcessData>();
        long[] pids = filter == null ? sigar.getProcList() : ProcessFinder.find((SigarProxy)sigar, (String)filter);
        for (long pid : pids) {
            try {
                this._processes.add(ProcessData.gather(sigar, pid));
            }
            catch (SigarException e) {
                // empty catch block
            }
        }
    }

    public static TopData gather(SigarProxy sigar, String filter) throws SigarException {
        TopData data = new TopData();
        data.populate(sigar, filter);
        return data;
    }

    public UptimeData getUptime() {
        return this._uptime;
    }

    public ProcStat getProcStat() {
        return this._procStat;
    }

    public CpuPerc getCpu() {
        return this._cpu;
    }

    public Mem getMem() {
        return this._mem;
    }

    public Swap getSwap() {
        return this._swap;
    }

    public List<ProcessData> getProcesses() {
        return this._processes;
    }

    public void print(PrintStream out) {
        out.println(this.getUptime());
        out.println(this.getProcStat());
        out.println(this.getCpu());
        out.println(this.getMem());
        out.println(this.getSwap());
        out.println();
        out.println("PID\tUSER\tSTIME\tSIZE\tRSS\tSHARE\tSTATE\tTIME\t%CPU\t%MEM\tCOMMAND");
        List<ProcessData> processes = this.getProcesses();
        for (int i = 0; i < processes.size(); ++i) {
            ProcessData process = processes.get(i);
            out.println(process.toString("\t"));
        }
    }

    public static void main(String[] args) throws Exception {
        String filter = args.length == 1 ? args[0] : null;
        Sigar sigar = new Sigar();
        TopData top = TopData.gather((SigarProxy)sigar, filter);
        top.print(System.out);
        sigar.close();
    }
}

