/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.util.PrintfFormat;

public class UptimeData {
    private long _time;
    private double _uptime;
    private double[] _loadavg;

    public void populate(SigarProxy sigar) throws SigarException {
        this._time = System.currentTimeMillis();
        this._uptime = sigar.getUptime().getUptime();
        try {
            this._loadavg = sigar.getLoadAverage();
        }
        catch (SigarNotImplementedException e) {
            this._loadavg = null;
        }
    }

    public static UptimeData gather(SigarProxy sigar) throws SigarException {
        UptimeData data = new UptimeData();
        data.populate(sigar);
        return data;
    }

    public long getTime() {
        return this._time;
    }

    public double getUptime() {
        return this._uptime;
    }

    public double[] getLoadavg() {
        return this._loadavg;
    }

    public String getFormattedTime() {
        return UptimeData.getFormattedTime(this._time);
    }

    public static String getFormattedTime(long time) {
        return new SimpleDateFormat("h:mm a").format(new Date(time));
    }

    public String getFormattedUptime() {
        return UptimeData.getFormattedUptime(this._uptime);
    }

    public static String getFormattedUptime(double uptime) {
        String retval = "";
        int days = (int)uptime / 86400;
        if (days != 0) {
            retval = retval + days + " " + (days > 1 ? "days" : "day") + ", ";
        }
        int minutes = (int)uptime / 60;
        int hours = minutes / 60;
        retval = (hours %= 24) != 0 ? retval + hours + ":" + minutes : retval + (minutes %= 60) + " min";
        return retval;
    }

    public String getFormattedLoadavg() {
        return UptimeData.getFormattedLoadavg(this._loadavg);
    }

    public static String getFormattedLoadavg(double[] loadavg) {
        if (loadavg == null) {
            return "(load average unknown)";
        }
        String format = "%.2f, %.2f, %.2f";
        Object[] avg = new Double[]{new Double(loadavg[0]), new Double(loadavg[1]), new Double(loadavg[2])};
        return new PrintfFormat("%.2f, %.2f, %.2f").sprintf(avg);
    }

    public String toString() {
        return this.getFormattedTime() + "  up " + this.getFormattedUptime() + ", " + this.getFormattedLoadavg();
    }
}

