/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.util.List;
import org.hyperic.tools.db.Column;
import org.hyperic.tools.db.Table;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class PostgresColumn
extends Column {
    protected PostgresColumn(Node node, Table table) throws SAXException {
        super(node, table);
    }

    @Override
    protected String getDefaultCommand(List cmds) {
        if (this.m_strType.equalsIgnoreCase("auto") || this.m_iDefault == 3) {
            return "";
        }
        String strSeqName = this.m_strTableName + '_' + this.getName() + "_SEQ";
        return "DEFAULT nextval('" + strSeqName + "')";
    }

    @Override
    protected void getPreCreateCommands(List cmds) {
        if (this.m_strType.equalsIgnoreCase("auto")) {
            return;
        }
        String strSeqName = this.m_strTableName + '_' + this.getName() + "_SEQ";
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 1: 
                case 3: {
                    cmds.add(0, "CREATE SEQUENCE " + this.m_strTableName + '_' + this.getName() + "_SEQ" + " START " + this.getInitialSequence() + " INCREMENT " + this.getIncrementSequence() + " CACHE 10");
                }
            }
        }
    }

    @Override
    protected void getDropCommands(List cmds) {
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 1: 
                case 3: {
                    cmds.add("DROP SEQUENCE " + this.m_strTableName + '_' + this.getName() + "_SEQ");
                }
            }
        }
    }

    protected static int getClassType() {
        return 4;
    }
}

