/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.hyperic.tools.db.Column;
import org.hyperic.tools.db.Data;
import org.hyperic.tools.db.DataSet;
import org.hyperic.tools.db.Table;

class SqlDataSet
extends DataSet {
    private final ResultSet m_resRows;
    private final Table m_table;

    protected SqlDataSet(Table table) throws SQLException {
        super(table.getName(), table.getDBSetup());
        this.m_table = table;
        String strCmd = table.getQueryCommand();
        this.m_resRows = table.getDBSetup().getConn().createStatement().executeQuery(strCmd);
    }

    @Override
    protected Data getData(int columnIndex) {
        Data dataResult = null;
        try {
            Column col = (Column)this.m_table.getColumns().get(columnIndex);
            dataResult = new Data(col.getName(), this.m_resRows.getString(columnIndex + 1));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dataResult;
    }

    @Override
    protected boolean next() {
        boolean bResult;
        try {
            bResult = this.m_resRows.next();
        }
        catch (SQLException e) {
            bResult = false;
        }
        return bResult;
    }
}

