/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory.agent.server;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.ScanConfiguration;
import org.hyperic.hq.autoinventory.ScanConfigurationCore;
import org.hyperic.hq.autoinventory.ScanManager;
import org.hyperic.hq.autoinventory.ScanMethod;
import org.hyperic.hq.autoinventory.ScanState;
import org.hyperic.hq.autoinventory.ScanStateCore;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.hq.autoinventory.agent.client.AICommandsClient;
import org.hyperic.hq.autoinventory.agent.client.AICommandsUtils;
import org.hyperic.hq.autoinventory.agent.server.RuntimeAutodiscoverer;
import org.hyperic.hq.autoinventory.scanimpl.NullScan;
import org.hyperic.hq.autoinventory.scanimpl.WindowsRegistryScan;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.RegistryServerDetector;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.config.ConfigResponse;

public class AICommandsService
implements AICommandsClient {
    private static final Log _log = LogFactory.getLog(AICommandsService.class);
    private final ProductPluginManager _productPluginManager;
    private final RuntimeAutodiscoverer _rtAutodiscoverer;
    private final ScanManager _scanManager;
    private final Object _lock = new Object();
    private ScanState _mostRecentState;

    public AICommandsService(ProductPluginManager productPluginManager, RuntimeAutodiscoverer rtAutodiscoverer, ScanManager scanManager) {
        this._productPluginManager = productPluginManager;
        this._rtAutodiscoverer = rtAutodiscoverer;
        this._scanManager = scanManager;
    }

    public ScanStateCore getScanStatus() throws AgentRemoteException {
        return this.getScanStatus(true);
    }

    ScanStateCore getScanStatus(boolean interruptHangingScan) throws AgentRemoteException {
        ScanState state;
        if (interruptHangingScan) {
            this._scanManager.interruptHangingScan();
        }
        try {
            state = this.doGetScanStatus();
            if (!state.getIsDone()) {
                state.initEndTime();
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error getting scan state.", (Throwable)e);
            throw new AgentRemoteException("Error getting scan status: " + e.toString());
        }
        return state.getCore();
    }

    public void pushRuntimeDiscoveryConfig(int type, int id, String typeName, String name, ConfigResponse response) throws AgentRemoteException {
        AgentRemoteValue args = AICommandsUtils.createArgForRuntimeDiscoveryConfig((int)type, (int)id, (String)typeName, (String)name, (ConfigResponse)response);
        this.pushRuntimeDiscoveryConfig(args, true);
    }

    void pushRuntimeDiscoveryConfig(AgentRemoteValue args, boolean interruptHangingScan) throws AgentRemoteException {
        if (interruptHangingScan) {
            this._scanManager.interruptHangingScan();
        }
        this._rtAutodiscoverer.updateConfig(args);
    }

    public void startScan(ScanConfigurationCore scanConfigCore) throws AgentRemoteException {
        this.startScan(scanConfigCore, true);
    }

    void startScan(ScanConfigurationCore scanConfigCore, boolean interruptHangingScan) throws AgentRemoteException {
        if (interruptHangingScan) {
            this._scanManager.interruptHangingScan();
        }
        if (scanConfigCore == null) {
            throw new AgentRemoteException("No scan configuration exists.");
        }
        ScanConfiguration scanConfig = new ScanConfiguration(scanConfigCore);
        this.startScan(scanConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startScan(ScanConfiguration scanConfig) {
        boolean userDefault;
        ServerSignature[] rgySigs;
        _log.debug((Object)("[startScan] scanConfig=\n" + scanConfig));
        ConfigResponse platformConfig = scanConfig.getConfigResponse();
        String platformType = null;
        boolean isDefault = scanConfig.getIsDefaultScan();
        ServerSignature[] autoSigs = rgySigs = scanConfig.getServerSignatures();
        boolean bl = userDefault = autoSigs == null || autoSigs.length == 0;
        if (platformConfig != null) {
            platformType = platformConfig.getValue("platform.type");
        }
        if (platformType == null) {
            platformType = OperatingSystem.getInstance().getName();
        }
        boolean isWin32 = PlatformDetector.isWin32((String)platformType);
        if (isDefault || userDefault) {
            autoSigs = this.getAutoScanners(platformType);
            if (isWin32) {
                rgySigs = this.getWindowsRegistryScanners();
            }
        }
        this.addScanners(scanConfig, (ScanMethod)new NullScan(), autoSigs);
        if (isWin32 && rgySigs != null) {
            this.addScanners(scanConfig, (ScanMethod)new WindowsRegistryScan(), rgySigs);
        }
        if (_log.isDebugEnabled()) {
            String type = isDefault ? "auto" : "user";
            ServerSignature[] sigs = scanConfig.getServerSignatures();
            ArrayList<String> types = new ArrayList<String>();
            for (int i = 0; i < sigs.length; ++i) {
                types.add(sigs[i].getServerTypeName());
            }
            _log.debug((Object)(type + " scan for: " + types));
        }
        ScanManager scanManager = this._scanManager;
        synchronized (scanManager) {
            this._scanManager.queueScan(scanConfig);
        }
    }

    public void stopScan() throws AgentRemoteException {
        this.stopScan(true);
    }

    void stopScan(boolean interruptHangingScan) throws AgentRemoteException {
        if (interruptHangingScan) {
            this._scanManager.interruptHangingScan();
        }
        try {
            if (!this.doStopScan()) {
                _log.warn((Object)"Scan stop was triggered, but there is no scan that is currently running. done.");
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error stopping scan.", (Throwable)e);
            throw new AgentRemoteException("Error stopping scan: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMostRecentState(ScanState scanState) {
        Object object = this._lock;
        synchronized (object) {
            this._mostRecentState = scanState;
        }
    }

    private ServerSignature[] getAutoScanners(String type) {
        ArrayList<ServerSignature> sigs = new ArrayList<ServerSignature>();
        Map plugins = AgentDaemon.getMainInstance().getAutoinventoryPluginManager().getPlatformPlugins(type);
        TreeSet<ServerDetector> detectors = new TreeSet<ServerDetector>(new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((GenericPlugin)o1).getName();
                String name2 = ((GenericPlugin)o2).getName();
                return name1.compareTo(name2);
            }
        });
        for (Map.Entry entry : plugins.entrySet()) {
            ServerDetector detector;
            TypeInfo info;
            if (!(entry.getValue() instanceof ServerDetector) || (info = (detector = (ServerDetector)entry.getValue()).getTypeInfo()).getType() != 2 || !(detector instanceof AutoServerDetector)) continue;
            detectors.add(detector);
        }
        for (ServerDetector detector : detectors) {
            sigs.add(detector.getServerSignature());
        }
        return sigs.toArray(new ServerSignature[0]);
    }

    private ServerSignature[] getWindowsRegistryScanners() {
        ArrayList<ServerSignature> sigs = new ArrayList<ServerSignature>();
        Map plugins = AgentDaemon.getMainInstance().getAutoinventoryPluginManager().getPlatformPlugins();
        for (Map.Entry entry : plugins.entrySet()) {
            ServerDetector detector;
            TypeInfo info;
            if (!(entry.getValue() instanceof RegistryServerDetector) || (info = (detector = (ServerDetector)entry.getValue()).getTypeInfo()).getType() != 2) continue;
            sigs.add(detector.getServerSignature());
        }
        return sigs.toArray(new ServerSignature[0]);
    }

    private void addScanners(ScanConfiguration scanConfig, ScanMethod method, ServerSignature[] sigs) {
        Object[] signatures = scanConfig.getServerSignatures();
        signatures = (ServerSignature[])ArrayUtil.combine((Object[])signatures, (Object[])sigs);
        scanConfig.setServerSignatures((ServerSignature[])signatures);
        scanConfig.setScanMethodConfig(method, new ConfigResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doStopScan() {
        try {
            this.doGetScanStatus();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ScanManager scanManager = this._scanManager;
        synchronized (scanManager) {
            try {
                return this._scanManager.stopScan();
            }
            catch (AutoinventoryException e) {
                _log.error((Object)("Error stopping scan, restarting scan manager: " + (Object)((Object)e)));
                this._scanManager.shutdown(1000L);
                this._scanManager.startup();
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScanState doGetScanStatus() throws AutoinventoryException {
        ScanState scanState = this._scanManager.getStatus();
        Object object = this._lock;
        synchronized (object) {
            if (scanState == null) {
                if (this._mostRecentState == null) {
                    throw new AutoinventoryException("No autoinventory scan has been started.");
                }
                return this._mostRecentState;
            }
            this._mostRecentState = scanState;
        }
        return scanState;
    }
}

