/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.configuration.agent.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.CommandInvokerUtil;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.autoinventory.agent.client.AICommandsUtils;
import org.hyperic.hq.configuration.agent.client.ConfigurationCommandsClient;
import org.hyperic.hq.configuration.agent.commands.Configuration_args;
import org.hyperic.hq.configuration.agent.repository.ConfigurationInfoTranslator;
import org.hyperic.hq.configuration.agent.repository.ResourceRepositoryException;
import org.hyperic.hq.configuration.agent.repository.ResourceRepositoryService;
import org.hyperic.hq.configuration.agent.repository.model.ConfigurationInfo;
import org.hyperic.hq.configuration.agent.repository.model.MergedSchedulingInfo;
import org.hyperic.hq.configuration.agent.repository.model.ResourceKey;
import org.hyperic.hq.configuration.agent.repository.model.SchedulingInfo;
import org.hyperic.hq.measurement.agent.commands.ScheduleMeasurements_args;
import org.hyperic.hq.measurement.agent.commands.UnscheduleMeasurementsById_args;
import org.hyperic.hq.measurement.agent.commands.UnscheduleMeasurements_args;
import org.hyperic.hq.measurement.server.session.SRN;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.config.ConfigResponse;

public class ConfigurationCommandsService
implements ConfigurationCommandsClient {
    private static final Log log = LogFactory.getLog(ConfigurationCommandsService.class);
    private static final int DEFAULT_REVISION_NUMBER = 1;
    private static final String LWO_INSTANCE_DELIMITER = ":";
    private final ResourceRepositoryService resourceRepositoryService;
    private final AgentDaemon agentDaemon;

    public ConfigurationCommandsService(AgentDaemon agentDaemon) {
        this.agentDaemon = agentDaemon;
        this.resourceRepositoryService = ResourceRepositoryService.getInstance();
    }

    public void configure(Configuration_args configurationArgs) throws AgentRemoteException {
        if (configurationArgs.isDeletedResource()) {
            this.delete(configurationArgs);
        } else {
            this.configurationAndScheduling(configurationArgs);
        }
    }

    public void configurationAndScheduling(Configuration_args configurationArgs) throws AgentRemoteException {
        try {
            ConfigurationInfo newConfigInfo = ConfigurationInfoTranslator.translate(configurationArgs, this.agentDaemon);
            this.handleSyncMode(newConfigInfo);
            ConfigurationInfo.ChangeType changeType = this.resourceRepositoryService.compareAndSwap(newConfigInfo);
            if (this.resourceRepositoryService.isResourceReadyForConfigurationAndScheduling(newConfigInfo.getResourceKey())) {
                this.handlePushRuntimeDiscoveryConfig(changeType, newConfigInfo);
                this.handleScheduling(changeType, newConfigInfo);
                this.handleDescendants(changeType, newConfigInfo.getResourceKey());
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception during configuration and scheduling", (Throwable)e);
        }
    }

    private void handleSyncMode(ConfigurationInfo config) {
        if (config == null || 2 != config.getTypeInfo().getType()) {
            return;
        }
        if (!this.resourceRepositoryService.isResourceExists(config.getResourceKey())) {
            this.agentDaemon.getSyncModeManager().setSyncMode(true);
        }
    }

    public void delete(Configuration_args configurationArgs) throws AgentRemoteException {
        try {
            ConfigurationInfo initConfigInfo = new ConfigurationInfo();
            ConfigurationInfoTranslator.translateResourceInternalId(configurationArgs, initConfigInfo);
            int resourceInternalId = initConfigInfo.getResourceInternalId();
            ConfigurationInfo configInfo = this.resourceRepositoryService.getConfigInfoByInternalId(resourceInternalId);
            if (configInfo != null) {
                ResourceKey resourceKey = configInfo.getResourceKey();
                if (this.resourceRepositoryService.isResourceReadyForConfigurationAndScheduling(resourceKey)) {
                    this.UnScheduleAllDescendants(resourceKey);
                    this.triggerUnScheduleMeasurementsCommand(configInfo);
                }
                this.resourceRepositoryService.removeResource(resourceKey);
                this.handlePushRuntimeDiscoveryConfig(ConfigurationInfo.ChangeType.CONFIGURATION, configInfo);
            } else {
                this.triggerUnscheduleMeasurementsByIdCommand(resourceInternalId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception during delete", (Throwable)e);
        }
    }

    private void handlePushRuntimeDiscoveryConfig(ConfigurationInfo.ChangeType changeType, ConfigurationInfo config) throws AgentRemoteException, ResourceRepositoryException {
        if (this.isSyncMode() || ConfigurationInfo.ChangeType.CONFIGURATION.equals((Object)changeType) || ConfigurationInfo.ChangeType.BOTH.equals((Object)changeType)) {
            if (2 == config.getTypeInfo().getType()) {
                AgentRemoteValue arg = this.buildPushRuntimeDiscoveryConfigArgs(config, config.getTypeInfo().getType(), config.getResourceKind());
                CommandInvokerUtil.triggerCommand((String)"autoinv:pushRuntimeDiscoveryConfig", (AgentRemoteValue)arg);
            } else if (1 == config.getTypeInfo().getType() && !MapUtils.isEmpty(config.getVirtualServerConfiguration())) {
                Map<String, Map<String, String>> virtualServers = config.getVirtualServerConfiguration();
                for (Map.Entry<String, Map<String, String>> virtualServerEntry : virtualServers.entrySet()) {
                    AgentRemoteValue arg = this.buildPushRuntimeDiscoveryConfigArgs(config, 2, virtualServerEntry.getKey());
                    CommandInvokerUtil.triggerCommand((String)"autoinv:pushRuntimeDiscoveryConfig", (AgentRemoteValue)arg);
                }
            }
        }
    }

    private void handleScheduling(ConfigurationInfo.ChangeType changeType, ConfigurationInfo configInfo) throws AgentRemoteException, AgentRunningException, PluginException, ResourceRepositoryException {
        if (this.isSyncMode() || !ConfigurationInfo.ChangeType.EQUAL.equals((Object)changeType)) {
            List<SchedulingInfo> scheduling = configInfo.getScheduling();
            Map<String, List<SchedulingInfo>> lwoScheduling = configInfo.getLwoScheduling();
            if (CollectionUtils.isEmpty(scheduling) && MapUtils.isEmpty(lwoScheduling)) {
                this.triggerUnScheduleMeasurementsCommand(configInfo);
            } else {
                this.triggerScheduleMeasurementsCommand(configInfo);
            }
        }
    }

    private void handleDescendants(ConfigurationInfo.ChangeType changeType, ResourceKey resourceKey) {
        if (!this.isSyncMode() && ConfigurationInfo.ChangeType.CONFIGURATION.equals((Object)changeType) || ConfigurationInfo.ChangeType.BOTH.equals((Object)changeType)) {
            List<ConfigurationInfo> descendants = this.resourceRepositoryService.getResourceDescendents(resourceKey);
            for (ConfigurationInfo descendant : descendants) {
                try {
                    this.handlePushRuntimeDiscoveryConfig(changeType, descendant);
                    this.handleScheduling(changeType, descendant);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to handle " + resourceKey + " descendat configuration. Skipping."), (Throwable)e);
                }
            }
        }
    }

    private void UnScheduleAllDescendants(ResourceKey resourceKey) {
        List<ConfigurationInfo> descendants = this.resourceRepositoryService.getResourceDescendents(resourceKey);
        for (ConfigurationInfo descendant : descendants) {
            try {
                this.triggerUnScheduleMeasurementsCommand(descendant);
            }
            catch (Exception e) {
                log.error((Object)("Failed to handle " + resourceKey + " descendat unscheduling. Skipping."), (Throwable)e);
            }
        }
    }

    private AgentRemoteValue buildPushRuntimeDiscoveryConfigArgs(ConfigurationInfo config, int typeInfo, String resourceKind) throws ResourceRepositoryException {
        Map<String, String> configuration = this.resourceRepositoryService.getResourceAndAncestorsConfiguration(config.getResourceKey());
        AgentRemoteValue args = AICommandsUtils.createArgForRuntimeDiscoveryConfig((int)typeInfo, (int)config.getResourceInternalId(), (String)resourceKind, (String)resourceKind, (ConfigResponse)new ConfigResponse(configuration));
        return args;
    }

    private boolean isSyncMode() {
        return this.agentDaemon.getSyncModeManager().isSyncMode();
    }

    private void triggerScheduleMeasurementsCommand(ConfigurationInfo configInfo) throws AgentRunningException, PluginException, ResourceRepositoryException, AgentRemoteException {
        TypeInfo typeInfo = configInfo.getTypeInfo();
        List<MergedSchedulingInfo> dsns = this.createDSNs(configInfo);
        ScheduleMeasurements_args commandArg = this.buildScheduleMeasurementCommand(configInfo.getResourceKey(), configInfo.getResourceInternalId(), typeInfo, dsns);
        CommandInvokerUtil.triggerCommand((String)"rtm:scheduleMeasurements", (AgentRemoteValue)commandArg);
    }

    private void triggerUnScheduleMeasurementsCommand(ConfigurationInfo configInfo) throws AgentRemoteException {
        UnscheduleMeasurements_args unschedCommandArg = this.buildUnscheduleMeasurementCommand(configInfo.getResourceInternalId(), configInfo.getTypeInfo());
        CommandInvokerUtil.triggerCommand((String)"rtm:unscheduleMeasurements", (AgentRemoteValue)unschedCommandArg);
    }

    private void triggerUnscheduleMeasurementsByIdCommand(int resourceInternalId) throws AgentRemoteException {
        UnscheduleMeasurementsById_args unschedCommandArg = new UnscheduleMeasurementsById_args(resourceInternalId);
        CommandInvokerUtil.triggerCommand((String)"rtm:unscheduleMeasurementsById", (AgentRemoteValue)unschedCommandArg);
    }

    private ScheduleMeasurements_args buildScheduleMeasurementCommand(ResourceKey resourceKey, int resourceInternalId, TypeInfo typeInfo, List<MergedSchedulingInfo> mergedSchedulingInfos) {
        ScheduleMeasurements_args command = new ScheduleMeasurements_args();
        for (MergedSchedulingInfo mergedSchedulingInfo : mergedSchedulingInfos) {
            SchedulingInfo serverScheduling = mergedSchedulingInfo.getServerScheduling();
            long measurementId = this.convertToMeasurementId(resourceInternalId, serverScheduling.getMetricId());
            command.addMeasurement(mergedSchedulingInfo.getDsn(), serverScheduling.getPollingInterval(), measurementId, measurementId, mergedSchedulingInfo.getCategory(), mergedSchedulingInfo.getUnits());
        }
        AppdefEntityID entityId = this.createAppDefEntityId(resourceInternalId, typeInfo);
        command.setSRN(new SRN(entityId, 1));
        return command;
    }

    private UnscheduleMeasurements_args buildUnscheduleMeasurementCommand(int resourceInternalId, TypeInfo typeInfo) {
        UnscheduleMeasurements_args command = new UnscheduleMeasurements_args();
        AppdefEntityID entityId = this.createAppDefEntityId(resourceInternalId, typeInfo);
        command.addEntity(entityId);
        return command;
    }

    private List<MergedSchedulingInfo> createDSNs(ConfigurationInfo configInfo) throws AgentRunningException, PluginException, ResourceRepositoryException {
        List<SchedulingInfo> scheduling = configInfo.getScheduling();
        Map<String, List<SchedulingInfo>> lwoScheduling = configInfo.getLwoScheduling();
        if (CollectionUtils.isEmpty(scheduling) && MapUtils.isEmpty(lwoScheduling)) {
            return Collections.emptyList();
        }
        ArrayList<MergedSchedulingInfo> mergedSchedulingInfos = new ArrayList<MergedSchedulingInfo>();
        Map<String, String> configMap = this.resourceRepositoryService.getFullResourceConfiguration(configInfo.getResourceKey());
        List<MergedSchedulingInfo> resourceDsn = this.createResourceDSN(configInfo, configMap);
        mergedSchedulingInfos.addAll(resourceDsn);
        List<MergedSchedulingInfo> lwoDsn = this.createLwoDSN(configInfo, configMap);
        mergedSchedulingInfos.addAll(lwoDsn);
        return mergedSchedulingInfos;
    }

    private List<MergedSchedulingInfo> createResourceDSN(ConfigurationInfo configInfo, Map<String, String> resourceConfigMap) throws AgentRunningException, PluginException {
        ArrayList<MergedSchedulingInfo> mergedSchedulingInfos = new ArrayList<MergedSchedulingInfo>();
        List<SchedulingInfo> schedulingInfos = configInfo.getScheduling();
        Map<String, MeasurementInfo> measurements = this.getMeasurements(configInfo.getResourceKind(), configInfo.getTypeInfo());
        if (!MapUtils.isEmpty(measurements)) {
            ConfigResponse resourceConfigResponse = new ConfigResponse(resourceConfigMap);
            log.debug((Object)("Generating DSNs for " + configInfo.getResourceKind()));
            for (SchedulingInfo schedInfo : schedulingInfos) {
                MergedSchedulingInfo mergedSchedulingInfo = this.getMergedSchedulingInfo(schedInfo, measurements, resourceConfigResponse);
                if (mergedSchedulingInfo == null) continue;
                mergedSchedulingInfos.add(mergedSchedulingInfo);
            }
        }
        return mergedSchedulingInfos;
    }

    private List<MergedSchedulingInfo> createLwoDSN(ConfigurationInfo configInfo, Map<String, String> resourceConfigMap) throws AgentRunningException, PluginException {
        ArrayList<MergedSchedulingInfo> mergedSchedulingInfos = new ArrayList<MergedSchedulingInfo>();
        Map<String, List<SchedulingInfo>> lwoScheduling = configInfo.getLwoScheduling();
        Map<String, Map<String, String>> lwoConfiguration = configInfo.getLwoConfiguration();
        for (Map.Entry<String, List<SchedulingInfo>> entry : lwoScheduling.entrySet()) {
            String lwoKind = this.extractLwoResourceKind(entry.getKey());
            if (lwoKind == null) {
                log.error((Object)("Failed to extract LWO type from " + entry.getKey()));
                continue;
            }
            TypeInfo lwoTypeInfo = this.agentDaemon.getTypeInfo(lwoKind, null);
            Map<String, MeasurementInfo> lwoMeasurements = this.getMeasurements(lwoKind, lwoTypeInfo);
            Map<String, String> lwoConfig = lwoConfiguration.get(entry.getKey());
            HashMap<String, String> fullConfiguration = new HashMap<String, String>();
            fullConfiguration.putAll(resourceConfigMap);
            if (lwoConfig != null) {
                fullConfiguration.putAll(lwoConfig);
            }
            ConfigResponse lwoConfigResponse = new ConfigResponse(fullConfiguration);
            List<SchedulingInfo> schedlingInfos = entry.getValue();
            for (SchedulingInfo schedInfo : schedlingInfos) {
                MergedSchedulingInfo mergedSchedulingInfo = this.getMergedSchedulingInfo(schedInfo, lwoMeasurements, lwoConfigResponse);
                if (mergedSchedulingInfo == null) continue;
                mergedSchedulingInfos.add(mergedSchedulingInfo);
            }
        }
        return mergedSchedulingInfos;
    }

    private MergedSchedulingInfo getMergedSchedulingInfo(SchedulingInfo schedInfo, Map<String, MeasurementInfo> measurements, ConfigResponse configResponse) {
        MergedSchedulingInfo mergedSchedulingInfo = null;
        try {
            MeasurementInfo measurementInfo = measurements.get(this.alignMetricName(schedInfo.getMetricName()));
            String template = measurementInfo.getTemplate();
            String dsn = AgentDaemon.getMainInstance().getMeasurementPluginManager().translate(template, configResponse);
            mergedSchedulingInfo = new MergedSchedulingInfo();
            mergedSchedulingInfo.setServerScheduling(schedInfo);
            mergedSchedulingInfo.setDsn(dsn);
            mergedSchedulingInfo.setCategory(measurementInfo.getCategory());
            mergedSchedulingInfo.setUnits(measurementInfo.getUnits());
        }
        catch (Exception e) {
            log.error((Object)("Failed to create Measurement DSN for " + schedInfo.getMetricName()));
        }
        return mergedSchedulingInfo;
    }

    private String extractLwoResourceKind(String lwo) {
        int delimiterLoc = lwo.indexOf(LWO_INSTANCE_DELIMITER);
        if (delimiterLoc == -1) {
            return null;
        }
        return lwo.substring(0, delimiterLoc);
    }

    private Map<String, MeasurementInfo> getMeasurements(String resourceKind, TypeInfo typeInfo) throws AgentRunningException, PluginException {
        HashMap<String, MeasurementInfo> filteredMeasurements = new HashMap<String, MeasurementInfo>();
        MeasurementInfo[] measurements = AgentDaemon.getMainInstance().getMeasurementPluginManager().getMeasurements(typeInfo);
        for (int i = 0; i < measurements.length; ++i) {
            String measurementKey = this.alignMetricName(measurements[i].getName());
            filteredMeasurements.put(measurementKey, measurements[i]);
        }
        return filteredMeasurements;
    }

    private AppdefEntityID createAppDefEntityId(int resourceId, TypeInfo typeInfo) {
        return new AppdefEntityID(typeInfo.getType() + LWO_INSTANCE_DELIMITER + resourceId);
    }

    private long convertToMeasurementId(int resId, int metricId) {
        return (long)resId << 32 | 0xFFFFFFFFL & (long)metricId;
    }

    private String alignMetricName(String metricName) {
        return metricName.replaceAll(" ", "").toLowerCase();
    }
}

