/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.ref.AppModel;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.security.CachedCertificatesHelper;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.ArrayUtil;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLNodeBuilder;
import com.sun.deploy.xml.XMLable;
import com.sun.javaws.HtmlOptions;
import com.sun.javaws.exceptions.JNLPSigningException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.JavaFXAppDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LDUpdater;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.jnl.LibraryDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.UpdateDesc;
import com.sun.javaws.jnl.XMLFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class LaunchDesc
implements XMLable {
    private final String _specVersion;
    private final String _version;
    private final URL _home;
    private final URL _codebase;
    private final InformationDesc _information;
    private final int _securityModel;
    private final UpdateDesc _update;
    private final ResourcesDesc _resources;
    private final ResourcesDesc _rawResources;
    private final int _launchType;
    private final ApplicationDesc _applicationDesc;
    private final AppletDesc _appletDesc;
    private final JavaFXAppDesc _jfxDesc;
    private final LibraryDesc _libraryDesc;
    private final InstallerDesc _installerDesc;
    private final String _internalCommand;
    private volatile String _source;
    private volatile boolean _propsSet;
    private volatile byte[] _bits;
    private volatile JREInfo _selectedJRE;
    private volatile boolean _signed;
    private volatile LDUpdater _updater;
    private final XMLNode _xmlNode;
    private final CachedCertificatesHelper[] _certificates;
    private volatile String _hashString;
    private volatile boolean _trusted;
    private Object lock = new Object();
    private Object jreMatcherLock = new Object();
    private volatile JARDesc _mainJar;
    private volatile DeploymentRuleSet _drs;
    private volatile JREMatcher _jreMatcher;
    private volatile boolean nestedResourcesProcessed;
    private volatile URL _originalURL;
    private volatile URL _parentURL;
    public static final int SANDBOX_SECURITY = 0;
    public static final int ALLPERMISSIONS_SECURITY = 1;
    public static final int J2EE_APP_CLIENT_SECURITY = 2;
    public static final int APPLICATION_DESC_TYPE = 1;
    public static final int APPLET_DESC_TYPE = 2;
    public static final int LIBRARY_DESC_TYPE = 3;
    public static final int INSTALLER_DESC_TYPE = 4;
    public static final int INTERNAL_TYPE = 5;
    public static final int FXAPP_TYPE = 6;

    public LaunchDesc(String string, URL uRL, URL uRL2, String string2, InformationDesc informationDesc, int n, CachedCertificatesHelper[] cachedCertificatesHelperArray, UpdateDesc updateDesc, ResourcesDesc resourcesDesc, int n2, ApplicationDesc applicationDesc, AppletDesc appletDesc, JavaFXAppDesc javaFXAppDesc, LibraryDesc libraryDesc, InstallerDesc installerDesc, String string3, XMLNode xMLNode, String string4) {
        this(string, uRL, uRL2, string2, informationDesc, n, cachedCertificatesHelperArray, updateDesc, resourcesDesc, n2, applicationDesc, appletDesc, javaFXAppDesc, libraryDesc, installerDesc, string3, xMLNode, string4, null);
    }

    public JARDesc getMainJar() {
        if (this._mainJar == null && this._resources != null) {
            this.addNestedResourcesForRunningJRE();
            this._mainJar = this._resources.getMainJar();
            if (this._mainJar != null) {
                this._mainJar.setLazyDownload(false);
            }
            this.storeVersionsInAppContext();
        }
        return this._mainJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNestedResourcesForRunningJRE() {
        if (!this.nestedResourcesProcessed) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.nestedResourcesProcessed) {
                    LaunchSelection.addNestedResourcesForRunningJRE(this);
                    this.nestedResourcesProcessed = true;
                }
            }
        }
    }

    public String getDownloadHost() {
        URL uRL;
        JARDesc jARDesc = this.getMainJar();
        if (jARDesc != null && (uRL = jARDesc.getLocation()) != null) {
            return uRL.getHost();
        }
        if (this._codebase != null) {
            return this._codebase.getHost();
        }
        return null;
    }

    public LaunchDesc(String string, URL uRL, URL uRL2, String string2, InformationDesc informationDesc, int n, CachedCertificatesHelper[] cachedCertificatesHelperArray, UpdateDesc updateDesc, ResourcesDesc resourcesDesc, int n2, ApplicationDesc applicationDesc, AppletDesc appletDesc, JavaFXAppDesc javaFXAppDesc, LibraryDesc libraryDesc, InstallerDesc installerDesc, String string3, XMLNode xMLNode, String string4, JREMatcher jREMatcher) {
        this._specVersion = string;
        this._version = string2;
        this._codebase = uRL;
        this._home = uRL2;
        this._information = informationDesc;
        this._securityModel = n;
        this._update = updateDesc;
        this._resources = resourcesDesc;
        this._launchType = n2;
        this._applicationDesc = applicationDesc;
        this._appletDesc = appletDesc;
        this._jfxDesc = javaFXAppDesc;
        this._libraryDesc = libraryDesc;
        this._installerDesc = installerDesc;
        this._internalCommand = string3;
        this._xmlNode = xMLNode;
        this._source = string4;
        this._signed = false;
        this._certificates = cachedCertificatesHelperArray;
        if (this._resources != null) {
            this._resources.setParent(this);
            this._rawResources = this._resources.clone();
        } else {
            this._rawResources = null;
        }
    }

    public CachedCertificatesHelper[] getCachedCertificates() {
        return this._certificates;
    }

    public URL getSourceURL() {
        return this._originalURL;
    }

    public void setSourceURL(URL uRL) {
        this._originalURL = uRL;
    }

    public void setParentURL(URL uRL) {
        this._parentURL = uRL;
    }

    public URL getParentURL() {
        return this._parentURL;
    }

    public JREInfo getHomeJRE() {
        return HomeJreInitializer.homeJRE;
    }

    public JREMatcher getJREMatcher() {
        JREMatcher jREMatcher = this.getMatchImpl();
        if (!jREMatcher.hasBeenRun()) {
            this.selectJRE(jREMatcher.getSecureOnly());
        }
        return jREMatcher;
    }

    public JREInfo selectJRE(boolean bl) {
        this.getMatchImpl().setSecureOnly(bl);
        this._selectedJRE = LaunchSelection.selectJRE(this, this.getMatchImpl());
        Trace.println((String)("LaunchDesc.selectJRE( returning selected jre: " + this._selectedJRE), (TraceLevel)TraceLevel.BASIC);
        return this._selectedJRE;
    }

    public String getSpecVersion() {
        return this._specVersion;
    }

    public URL getCodebase() {
        return this._codebase;
    }

    public URL getDocumentBase() {
        URL uRL;
        if (this.getLaunchType() == 2 && (uRL = this.getAppletDescriptor().getDocumentBase()) != null) {
            return uRL;
        }
        return this.getCodebase();
    }

    public byte[] getBytes() {
        if (this._bits == null) {
            this._bits = this.getSource().getBytes();
        }
        return this._bits;
    }

    public URL getLocation() {
        return this._home;
    }

    public URL getCanonicalHome() {
        if (this._home != null) {
            return this._home;
        }
        if (this._originalURL != null && Environment.isJavaPlugin() && !Environment.isJavawsAppletLifecycle()) {
            return this._originalURL;
        }
        if (this._resources != null) {
            JARDesc jARDesc = this.getMainJar();
            try {
                if (jARDesc != null) {
                    URL uRL = HttpUtils.removeQueryStringFromURL((URL)jARDesc.getLocation());
                    return new URL(uRL.toString() + "jnlp");
                }
                ExtensionDesc[] extensionDescArray = this._resources.getExtensionDescs();
                if (extensionDescArray.length > 0) {
                    URL uRL = HttpUtils.removeQueryStringFromURL((URL)extensionDescArray[0].getLocation());
                    return new URL(uRL.toString() + ".jarjnlp");
                }
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
        }
        return null;
    }

    public final URL getRealLocation() {
        return this._home == null ? this._originalURL : this._home;
    }

    private URL getJNLPSrcForAppInfo() {
        URL uRL = this.getRealLocation();
        if (uRL == null) {
            uRL = AppInfo.getJNLPFromUnknownSource();
        }
        return uRL;
    }

    private URL getAppFromLocation() {
        URL uRL = null;
        if (this._resources != null) {
            JARDesc jARDesc = this.getMainJar();
            try {
                if (jARDesc != null) {
                    URL uRL2 = HttpUtils.removeQueryStringFromURL((URL)jARDesc.getLocation());
                    uRL = new URL(uRL2.toString() + "jnlp");
                } else {
                    uRL = this.getCodebase();
                }
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
        }
        if (uRL == null) {
            uRL = this._originalURL != null ? this._originalURL : this._home;
        }
        return uRL;
    }

    public String getSplashCanonicalHome() {
        if (this._home == null) {
            if (this._resources == null) {
                return null;
            }
            JARDesc jARDesc = this.getMainJar();
            return jARDesc != null ? jARDesc.getLocation().toString() + "jnlp" : null;
        }
        return this._home.toString();
    }

    public InformationDesc getInformation() {
        return this._information;
    }

    public String getInternalCommand() {
        return this._internalCommand;
    }

    public int getSecurityModel() {
        return this._securityModel;
    }

    public UpdateDesc getUpdate() {
        return this._update;
    }

    public boolean isSigned() {
        return this._signed;
    }

    public boolean hasIdenticalContent(LaunchDesc launchDesc) {
        return this._xmlNode != null && launchDesc != null && this._xmlNode.equals((Object)launchDesc._xmlNode);
    }

    public boolean hasIdenticalContent(File file) {
        try {
            byte[] byArray = SystemUtils.readBytes((InputStream)new FileInputStream(file), (long)file.length());
            XMLNode xMLNode = XMLFormat.parseBits(byArray);
            return this._xmlNode.equals((Object)xMLNode);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equalsTemplate(XMLNode xMLNode) {
        return this._xmlNode != null && !XMLFormat.isBlacklisted(xMLNode) && this._xmlNode.equalsTemplate((Object)xMLNode);
    }

    public boolean checkSigningTemplate(byte[] byArray) throws JNLPSigningException {
        XMLNode xMLNode = null;
        try {
            xMLNode = XMLFormat.parseBits(byArray);
            if (this.equalsTemplate(xMLNode)) {
                this._signed = true;
                return true;
            }
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
        throw new JNLPSigningException(this, xMLNode == null ? new String(byArray) : xMLNode.toString(true));
    }

    public void setTrusted() {
        Trace.println((String)("Mark trusted: " + this._home), (TraceLevel)TraceLevel.SECURITY);
        this._trusted = true;
    }

    public boolean isTrusted() {
        Trace.println((String)("Istrusted: " + this._home + " " + this._trusted), (TraceLevel)TraceLevel.SECURITY);
        return this._trusted;
    }

    public boolean isSecure() {
        return 0 == this.getSecurityModel();
    }

    public boolean isSecureJVMArgs() {
        return this.getJREMatcher().getSelectedJVMParameters().isSecure();
    }

    public ResourcesDesc getResources() {
        return this._resources;
    }

    public boolean arePropsSet() {
        return this._propsSet;
    }

    public void setPropsSet(boolean bl) {
        this._propsSet = bl;
    }

    public ResourcesDesc getRawResources() {
        return this._rawResources;
    }

    public JREInfo getSelectedJRE() {
        if (this._selectedJRE == null) {
            this.selectJRE(this.getMatchImpl().getSecureOnly());
        }
        return this._selectedJRE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JREMatcher getMatchImpl() {
        if (this._jreMatcher == null) {
            DeploymentRuleSet deploymentRuleSet = this.getMainDeploymentRuleSet();
            Object object = this.jreMatcherLock;
            synchronized (object) {
                if (this._jreMatcher == null) {
                    this._jreMatcher = new JREMatcher();
                    this._jreMatcher.setDRSVersion(deploymentRuleSet.getVersionString(), deploymentRuleSet.isVersionForced());
                }
            }
        }
        return this._jreMatcher;
    }

    public int getLaunchType() {
        return this._launchType;
    }

    public ApplicationDesc getApplicationDescriptor() {
        return this._applicationDesc;
    }

    public AppletDesc getAppletDescriptor() {
        return this._appletDesc;
    }

    public JavaFXAppDesc getJavaFXAppDescriptor() {
        return this._jfxDesc;
    }

    public InstallerDesc getInstallerDescriptor() {
        return this._installerDesc;
    }

    public final boolean isApplication() {
        return this._launchType == 1;
    }

    public final boolean isApplet() {
        return this._launchType == 2;
    }

    public final boolean isLibrary() {
        return this._launchType == 3;
    }

    public final boolean isInstaller() {
        return this._launchType == 4;
    }

    public final boolean isFXAppOnly() {
        return this._launchType == 6;
    }

    public final boolean isFXApp() {
        return this.getJavaFXAppDescriptor() != null;
    }

    public final boolean needFX() {
        return this.isFXApp() || null != this.getJavaFXRuntimeDescriptor();
    }

    public final boolean isApplicationDescriptor() {
        return this.isApplication() || this.isApplet() || this.isFXAppOnly();
    }

    public String getMainClassName() {
        if (this.isFXApp()) {
            return this.getJavaFXAppDescriptor().getMainClass();
        }
        switch (this.getLaunchType()) {
            case 1: {
                return this.getApplicationDescriptor().getMainClass();
            }
            case 4: {
                return this.getInstallerDescriptor().getMainClass();
            }
            case 2: {
                return this.getAppletDescriptor().getAppletClass();
            }
        }
        return null;
    }

    public String getArgumentsString() {
        if (this.isFXApp()) {
            return ArrayUtil.propertiesToString((Properties)this.getJavaFXAppDescriptor().getParameters());
        }
        switch (this.getLaunchType()) {
            case 1: {
                return ArrayUtil.arrayToString((String[])this.getApplicationDescriptor().getArguments());
            }
            case 2: {
                return ArrayUtil.propertiesToString((Properties)this.getAppletDescriptor().getParameters());
            }
        }
        return null;
    }

    public boolean isHttps() {
        if (this._codebase != null) {
            return this._codebase.getProtocol().equals("https");
        }
        this.getCanonicalHome();
        if (this._home != null) {
            return this._home.getProtocol().equals("https");
        }
        return false;
    }

    public String getSource() {
        if (this._source == null) {
            this._source = this._xmlNode.toString();
        }
        return this._source;
    }

    public XMLNode getXmlNode() {
        return this._xmlNode;
    }

    public void checkSigning(LaunchDesc launchDesc) throws JNLPSigningException {
        if (launchDesc == null || !launchDesc.getXmlNode().equals((Object)this.getXmlNode())) {
            throw new JNLPSigningException(this, launchDesc.getXmlNode().toString(true));
        }
        this._signed = true;
    }

    public boolean isJRESpecified() {
        final boolean[] blArray = new boolean[1];
        final boolean[] blArray2 = new boolean[1];
        if (this.getResources() != null) {
            this.getResources().visit(new ResourceVisitor(){

                public void visitJARDesc(JARDesc jARDesc) {
                    blArray2[0] = true;
                }

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    blArray2[0] = true;
                }

                public void visitJREDesc(JREDesc jREDesc) {
                    blArray[0] = true;
                }
            });
        }
        if (this._launchType == 1 || this._launchType == 2) {
            blArray2[0] = true;
        }
        return blArray[0] || !blArray2[0];
    }

    public AppInfo getAppInfo() {
        String[] stringArray;
        AppInfo appInfo = new AppInfo(this.getLaunchType(), this._information.getTitle(), this._information.getVendor(), this.getAppFromLocation(), this.getJNLPSrcForAppInfo(), null, null, false, false, null, null);
        appInfo.setSecurity(this.isSecure() ? 1 : 2);
        appInfo.setLapURL(this.getCanonicalHome());
        appInfo.setDocumentBase(this._parentURL);
        IconDesc iconDesc = this._information.getIconLocation(48, 0);
        if (iconDesc != null) {
            appInfo.setIconRef(iconDesc.getLocation());
            appInfo.setIconVersion(iconDesc.getVersion());
        }
        appInfo.setSignedJNLPL(this.isSigned());
        JARDesc jARDesc = this.getMainJar();
        if (jARDesc != null) {
            appInfo.setEMURL(jARDesc.getLocation());
            appInfo.setEMVersion(jARDesc.getVersion());
        }
        String string = this.getSource();
        if (HtmlOptions.get() != null && (stringArray = HtmlOptions.get().getHtmlApplicationArgs()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + "," + stringArray[i];
            }
        }
        appInfo.setAppArgs(string);
        appInfo.setAppModel(this.getAppModel());
        return appInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDUpdater getUpdater() {
        if (this._updater == null) {
            LaunchDesc launchDesc = this;
            synchronized (launchDesc) {
                if (this._updater == null) {
                    this._updater = new LDUpdater(this);
                }
            }
        }
        return this._updater;
    }

    protected boolean isNestedResourcesProcessed() {
        return this.nestedResourcesProcessed;
    }

    protected void setNestedResourcesProcessed(boolean bl) {
        this.nestedResourcesProcessed = bl;
    }

    public String getProgressClassName() {
        String string = null;
        string = this._jfxDesc != null ? this._jfxDesc.getPreloaderClass() : (this._applicationDesc != null ? this._applicationDesc.getProgressClass() : (this._appletDesc != null ? this._appletDesc.getProgressClass() : (this._libraryDesc != null ? this._libraryDesc.getProgressClass() : null)));
        if (string != null) {
            return string;
        }
        final String[] stringArray = new String[1];
        if (this.getResources() != null) {
            this.getResources().visit(new ResourceVisitor(){

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    LaunchDesc launchDesc = extensionDesc.getExtensionDesc();
                    if (launchDesc != null && stringArray[0] == null) {
                        stringArray[0] = launchDesc.getProgressClassName();
                    }
                }
            });
        }
        return stringArray[0];
    }

    public JavaFXRuntimeDesc getJavaFXRuntimeDescriptor() {
        final JavaFXRuntimeDesc[] javaFXRuntimeDescArray = new JavaFXRuntimeDesc[]{null};
        if (this.getResources() != null) {
            this.getResources().visit(new ResourceVisitor(){

                public void visitJFXDesc(JavaFXRuntimeDesc javaFXRuntimeDesc) {
                    javaFXRuntimeDescArray[0] = javaFXRuntimeDesc;
                }
            });
        }
        return javaFXRuntimeDescArray[0];
    }

    public boolean isValidSpecificationVersion() {
        VersionString versionString = new VersionString(this.getSpecVersion());
        return versionString.contains(new VersionID("8.20")) || versionString.contains(new VersionID("7.0")) || versionString.contains(new VersionID("6.0.18")) || versionString.contains(new VersionID("6.0.10")) || versionString.contains(new VersionID("6.0")) || versionString.contains(new VersionID("1.5")) || versionString.contains(new VersionID("1.0"));
    }

    public URL getHtmlLocation() {
        URL uRL;
        if (this.getLaunchType() == 2 && (uRL = this.getAppletDescriptor().getDocumentBase()) != null) {
            return uRL;
        }
        return null;
    }

    public URL getMainJarURL() {
        JARDesc jARDesc = this._resources.getMainJar();
        if (jARDesc != null) {
            URL uRL = jARDesc.getLocation();
            return URLUtil.getBase((URL)uRL);
        }
        return null;
    }

    public URL getAnchorURL() {
        JARDesc jARDesc;
        URL uRL = this.getRealLocation();
        if (uRL == null && (jARDesc = this.getMainJar()) != null) {
            uRL = jARDesc.getLocation();
        }
        return uRL;
    }

    public static AppRef getJNLPAppRef(LaunchDesc launchDesc) {
        URL uRL = launchDesc.getRealLocation();
        URL uRL2 = uRL != null ? uRL : null;
        URL uRL3 = launchDesc.getHtmlLocation();
        return new AppRef(AppRef.Type.JNLP, launchDesc.getInformation().getTitle(), uRL3, uRL2, launchDesc.getAnchorURL(), launchDesc.getHash());
    }

    public String getHash() {
        if (this._hashString == null) {
            this._hashString = SystemUtils.getChecksum((byte[])this.getBytes(), (String)"SHA-256");
        }
        return this._hashString;
    }

    public DeploymentRuleSet getMainDeploymentRuleSet() {
        if (this._drs == null) {
            JARDesc jARDesc = this.getMainJar();
            CodeRef codeRef = jARDesc != null ? jARDesc.getCodeRef() : new CodeRef(null, null, false, false);
            AppRef appRef = LaunchDesc.getJNLPAppRef(this);
            Trace.println((String)("Jnlp based appRef: " + appRef), (TraceLevel)TraceLevel.RULESET);
            Trace.println((String)("Jnlp based codeRef: " + codeRef), (TraceLevel)TraceLevel.RULESET);
            this._drs = DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, codeRef));
        }
        return this._drs;
    }

    public void storeVersionsInAppContext() {
        ResourcesDesc resourcesDesc = this.getResources();
        if (resourcesDesc == null) {
            return;
        }
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        if (jARDescArray == null) {
            return;
        }
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (jARDescArray[i] == null) continue;
            String string = jARDescArray[i].getVersion();
            URL uRL = jARDescArray[i].getLocation();
            if (string == null) continue;
            ToolkitStore.get().getAppContext().put((Object)("deploy-" + uRL.toString()), (Object)string);
            if (!jARDescArray[i].isPack200Enabled() && !jARDescArray[i].isVersionEnabled()) continue;
            if (jARDescArray[i].isVersionEnabled()) {
                uRL = URLUtil.getEmbeddedVersionURL((URL)uRL, (String)string);
            }
            if (jARDescArray[i].isPack200Enabled()) {
                uRL = URLUtil.getPack200URL((URL)uRL, (boolean)false);
            }
            ToolkitStore.get().getAppContext().put((Object)("deploy-" + uRL.toString()), (Object)string);
        }
    }

    public XMLNode asXML() {
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        xMLAttributeBuilder.add("spec", this._specVersion);
        xMLAttributeBuilder.add("codebase", this._codebase);
        xMLAttributeBuilder.add("version", this._version);
        xMLAttributeBuilder.add("href", this._home);
        XMLNodeBuilder xMLNodeBuilder = new XMLNodeBuilder("jnlp", xMLAttributeBuilder.getAttributeList());
        xMLNodeBuilder.add((XMLable)this._information);
        if (this._securityModel != 0) {
            XMLNode xMLNode = null;
            String string = "all-permissions";
            if (this._securityModel == 2) {
                string = "j2ee-application-client-permissions";
            }
            if (this._certificates != null) {
                XMLAttributeBuilder xMLAttributeBuilder2 = new XMLAttributeBuilder();
                xMLAttributeBuilder2.add("signedjnlp", this._certificates[0].isSignedJNLP());
                XMLNodeBuilder xMLNodeBuilder2 = new XMLNodeBuilder("security", null);
                XMLNodeBuilder xMLNodeBuilder3 = new XMLNodeBuilder("jfx:details", xMLAttributeBuilder2.getAttributeList());
                for (int i = 0; i < this._certificates.length; ++i) {
                    XMLAttributeBuilder xMLAttributeBuilder3 = new XMLAttributeBuilder();
                    if (this._certificates[i].getTimestamp() != null) {
                        xMLAttributeBuilder3.add("timestamp", "" + this._certificates[i].getTimestamp().getTime());
                    }
                    XMLNodeBuilder xMLNodeBuilder4 = new XMLNodeBuilder("jfx:certificate-path", xMLAttributeBuilder3.getAttributeList());
                    xMLNodeBuilder4.add(new XMLNode(this._certificates[i].exportCertificatesToBase64()));
                    xMLNodeBuilder3.add(xMLNodeBuilder4.getNode());
                }
                xMLNodeBuilder2.add(new XMLNode(string, null));
                xMLNodeBuilder2.add(xMLNodeBuilder3.getNode());
                xMLNode = xMLNodeBuilder2.getNode();
            } else {
                xMLNode = new XMLNode("security", null, new XMLNode(string, null), null);
            }
            xMLNodeBuilder.add(xMLNode);
        }
        xMLNodeBuilder.add((XMLable)this._update);
        xMLNodeBuilder.add((XMLable)this._resources);
        xMLNodeBuilder.add((XMLable)this._applicationDesc);
        xMLNodeBuilder.add((XMLable)this._appletDesc);
        xMLNodeBuilder.add((XMLable)this._jfxDesc);
        xMLNodeBuilder.add((XMLable)this._libraryDesc);
        xMLNodeBuilder.add((XMLable)this._installerDesc);
        return xMLNodeBuilder.getNode();
    }

    public String toString() {
        return this.asXML().toString();
    }

    public String getVersion() {
        return this._version;
    }

    private AppModel.SecurityMode getSecurityMode() {
        switch (this.getSecurityModel()) {
            case 0: {
                return AppModel.SecurityMode.SANDBOX;
            }
            case 1: {
                return AppModel.SecurityMode.ALL_PERMISSIONS;
            }
            case 2: {
                return AppModel.SecurityMode.J2EE_APPLICATION_CLIENT_PERMISSIONS;
            }
        }
        return null;
    }

    public AppModel getAppModel() {
        AppModel appModel = new AppModel();
        appModel.setType(this.isApplication() ? AppModel.Type.APPLICATION : AppModel.Type.APPLET);
        appModel.setSecurityMode(this.getSecurityMode());
        appModel.setTitle(this.getInformation().getTitle());
        appModel.setVendor(this.getInformation().getVendor());
        appModel.setDescription(this.getInformation().getDescription(0));
        appModel.setLocation(this.getLocation());
        appModel.setCodebase(this.getCodebase());
        appModel.setMainClass(this.getMainClassName());
        if (this.getResources() != null) {
            for (JARDesc resourceType : this.getResources().getLocalJarDescs()) {
                appModel.addJarResource(resourceType.getLocation(), resourceType.getVersion());
            }
            for (ResourceType resourceType : this.getResources().getExtensionDescs()) {
                appModel.addExtensionResource(((ExtensionDesc)resourceType).getLocation(), ((ExtensionDesc)resourceType).getName());
            }
        }
        return appModel;
    }

    private static class HomeJreInitializer {
        static final JREInfo homeJRE = JREInfo.getHomeJRE();

        private HomeJreInitializer() {
        }
    }
}

