/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.server.AgentStorageProvider;

public class SyncModeManager {
    private static final String NEXT_SYNC_TIME = "nextSyncScanTime";
    private static Log _log = LogFactory.getLog(SyncModeManager.class);
    private final AtomicBoolean syncMode = new AtomicBoolean(false);
    private AgentStorageProvider storageProvider;
    private long _syncScanInterval;
    private long _nextSyncScanTime;

    public SyncModeManager(AgentStorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    public boolean isSyncMode() {
        return this.syncMode.get();
    }

    public void setSyncMode(boolean syncMode) {
        this.syncMode.set(syncMode);
    }

    public boolean initSyncScanFromStorage(long loadScanInterval) {
        this.setSyncScanInterval(loadScanInterval);
        return this.initNextSyncScanTimeFromStorage();
    }

    private void setSyncScanInterval(long loadScanInterval) {
        this._syncScanInterval = loadScanInterval;
    }

    private boolean initNextSyncScanTimeFromStorage() {
        try {
            this._nextSyncScanTime = (Long)this.storageProvider.getObject(NEXT_SYNC_TIME);
            this.storageProvider.deleteObject(NEXT_SYNC_TIME);
            _log.debug((Object)"got nextSyncScanTime from storage ");
            return true;
        }
        catch (Exception e) {
            this._nextSyncScanTime = System.currentTimeMillis();
            return false;
        }
    }

    public void storeNextSyncScanTime() {
        this.storageProvider.saveObject(this._nextSyncScanTime, NEXT_SYNC_TIME);
        _log.debug((Object)"storing nextSyncScanTime in storage ");
    }

    public long getNextSyncScanTime() {
        return this._nextSyncScanTime;
    }

    public void tickNextSyncScanTime() {
        this._nextSyncScanTime += this._syncScanInterval;
    }
}

