/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.autoinventory.ScanMethodState;
import org.hyperic.hq.bizapp.shared.lather.AiServerLatherValue;
import org.hyperic.hq.bizapp.shared.lather.StringifiedExceptionLatherValue;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;
import org.hyperic.util.StringifiedException;

public class ScanMethodStateLatherValue
extends LatherValue {
    private static final String PROP_EXCEPTIONS = "exceptions";
    private static final String PROP_METHODCLASS = "methodClass";
    private static final String PROP_SERVERS = "servers";
    private static final String PROP_STATUS = "status";

    public ScanMethodStateLatherValue() {
    }

    public ScanMethodStateLatherValue(ScanMethodState v) {
        int i;
        if (v.getMethodClass() != null) {
            this.setStringValue(PROP_METHODCLASS, v.getMethodClass());
        }
        if (v.getStatus() != null) {
            this.setStringValue(PROP_STATUS, v.getStatus());
        }
        if (v.getExceptions() != null) {
            StringifiedException[] excs = v.getExceptions();
            for (i = 0; i < excs.length; ++i) {
                this.addObjectToList(PROP_EXCEPTIONS, (Object)new StringifiedExceptionLatherValue(excs[i]));
            }
        }
        if (v.getServers() != null) {
            AIServerValue[] svrs = v.getServers();
            for (i = 0; i < svrs.length; ++i) {
                this.addObjectToList(PROP_SERVERS, (Object)new AiServerLatherValue(svrs[i]));
            }
        }
    }

    public ScanMethodState getScanMethodState() {
        int i;
        ScanMethodState r = new ScanMethodState();
        try {
            r.setMethodClass(this.getStringValue(PROP_METHODCLASS));
        }
        catch (LatherKeyNotFoundException exc) {
            // empty catch block
        }
        try {
            r.setStatus(this.getStringValue(PROP_STATUS));
        }
        catch (LatherKeyNotFoundException exc) {
            // empty catch block
        }
        try {
            LatherValue[] lexcs = (LatherValue[])this.getObjectList(PROP_EXCEPTIONS);
            StringifiedException[] excs = new StringifiedException[lexcs.length];
            for (i = 0; i < lexcs.length; ++i) {
                StringifiedExceptionLatherValue lExc = (StringifiedExceptionLatherValue)lexcs[i];
                excs[i] = lExc.getException();
            }
            r.setExceptions(excs);
        }
        catch (LatherKeyNotFoundException exc) {
            // empty catch block
        }
        try {
            LatherValue[] lsvrs = (LatherValue[])this.getObjectList(PROP_SERVERS);
            AIServerValue[] svrs = new AIServerValue[lsvrs.length];
            for (i = 0; i < lsvrs.length; ++i) {
                AiServerLatherValue lSvr = (AiServerLatherValue)lsvrs[i];
                svrs[i] = lSvr.getAIServerValue();
            }
            r.setServers(svrs);
        }
        catch (LatherKeyNotFoundException latherKeyNotFoundException) {
            // empty catch block
        }
        return r;
    }

    public void validate() throws LatherRemoteException {
    }
}

