/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.measurement.data.TrackEventReport;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;

public class TrackSend_args
extends LatherValue {
    private static final String PROP_TIMESTAMP = "timestamps";
    private static final String PROP_LEVEL = "levels";
    private static final String PROP_MESSAGE = "messages";
    private static final String PROP_ID = "ids";
    private static final String PROP_TYPE = "types";
    private static final String PROP_SOURCE = "sources";
    public static final int TYPE_LOG = 1;
    public static final int TYPE_CONFIG = 2;

    public int getType() {
        return super.getIntValue(PROP_TYPE);
    }

    public void setType(int type) {
        super.setIntValue(PROP_TYPE, type);
    }

    public TrackEventReport getEvents() throws LatherRemoteException {
        double[] tstamps = this.getDoubleList(PROP_TIMESTAMP);
        int[] levels = this.getIntList(PROP_LEVEL);
        String[] msgs = this.getStringList(PROP_MESSAGE);
        String[] srcs = this.getStringList(PROP_SOURCE);
        int[] ids = this.getIntList(PROP_ID);
        int[] types = this.getIntList(PROP_TYPE);
        TrackEventReport report = new TrackEventReport();
        if (tstamps.length != levels.length || levels.length != msgs.length || msgs.length != srcs.length || srcs.length != ids.length || ids.length != types.length) {
            throw new LatherRemoteException("TrackEvent report mismatch");
        }
        for (int i = 0; i < tstamps.length; ++i) {
            TrackEvent event = new TrackEvent(new AppdefEntityID(types[i], ids[i]), (long)tstamps[i], levels[i], srcs[i], msgs[i]);
            report.addEvent(event);
        }
        return report;
    }

    public void setEvents(TrackEventReport eventsReport) {
        TrackEvent[] events = eventsReport.getEvents();
        for (int i = 0; i < events.length; ++i) {
            TrackEvent event = events[i];
            if (event.getAppdefId() == null) {
                throw new IllegalArgumentException("AppdefEntityID for event cannot be NULL");
            }
            super.addDoubleToList(PROP_TIMESTAMP, (double)event.getTime());
            super.addIntToList(PROP_LEVEL, event.getLevel());
            super.addStringToList(PROP_MESSAGE, event.getMessage());
            super.addStringToList(PROP_SOURCE, event.getSource());
            super.addIntToList(PROP_ID, event.getAppdefId().getID());
            super.addIntToList(PROP_TYPE, event.getAppdefId().getType());
        }
    }

    public void validate() throws LatherRemoteException {
    }
}

