/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.GenericPlugin;

public class ClientPluginDeployer {
    private static final Log log = LogFactory.getLog((String)ClientPluginDeployer.class.getName());
    private final String plugin;
    private final String pdk;
    private static HashMap handlers = new HashMap();
    private static final String[] EX_DIRS = new String[]{"scripts", "lib"};
    private static final String[] DIRS = new String[]{"tmp"};

    public ClientPluginDeployer(String pdk, String type) {
        this.pdk = pdk;
        this.plugin = type;
    }

    public static void addHandler(String dir, boolean isExecutable) {
        Handler handler = new Handler(dir);
        handlers.put(handler.getName(), handler);
        handler.setExecutable(isExecutable);
    }

    public static void addHandlers(String[] dirs, boolean isExecutable) {
        for (int i = 0; i < dirs.length; ++i) {
            ClientPluginDeployer.addHandler(dirs[i], isExecutable);
        }
    }

    public Handler getHandler(String name) {
        Handler handler = (Handler)handlers.get(name);
        if (handler != null) {
            return handler;
        }
        return (Handler)handlers.get(name + 's');
    }

    public static File getSubDirectory(String root, String name, String plugin) {
        File dir;
        String subdir = "";
        if (!new File(root).getName().equals("work")) {
            subdir = subdir + "work" + File.separator;
        }
        if (!(dir = new File(root, subdir = subdir + name + File.separator + plugin)).exists()) {
            if (!dir.mkdirs()) {
                log.error((Object)("mkdir(" + dir + ") failed for plugin: " + plugin));
                return null;
            }
            log.debug((Object)("mkdir(" + dir + ") succeeded for plugin: " + plugin));
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List unpackJar(String jar) throws IOException {
        ArrayList<String> jars = new ArrayList<String>();
        ZipFile zipfile = new ZipFile(jar);
        InputStream is = null;
        try {
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                String prefix;
                File file;
                int ix;
                ZipEntry entry = e.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || (ix = name.indexOf(47)) == -1 || (file = this.getFile(prefix = name.substring(0, ix), name = name.substring(ix + 1))) == null) continue;
                if (name.endsWith(".jar")) {
                    jars.add(file.toString());
                }
                if (this.upToDate(entry, file)) continue;
                is = zipfile.getInputStream(entry);
                this.write(is, file);
            }
        }
        finally {
            try {
                if (null != zipfile) {
                    zipfile.close();
                }
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException exc) {}
        }
        return jars;
    }

    public boolean isDeployableType(String type) {
        return this.getHandler(type) != null;
    }

    public File getFile(String type, String file) {
        Handler handler = this.getHandler(type);
        if (handler == null) {
            return null;
        }
        File dir = handler.getSubDirectory(this);
        if (dir == null) {
            log.debug((Object)("Unable to determine subdirectory to write: " + file));
            return null;
        }
        PluginFile pluginFile = new PluginFile(dir, file);
        pluginFile.handler = handler;
        return pluginFile;
    }

    public boolean upToDate(long source, long target) {
        return source < target;
    }

    public boolean upToDate(ZipEntry source, File target) {
        boolean upToDate = this.upToDate(source.getTime(), target.lastModified());
        if (upToDate) {
            log.debug((Object)("Unchanged zip file: " + target));
        }
        return upToDate;
    }

    public boolean upToDate(File source, File target) {
        boolean upToDate = this.upToDate(source.lastModified(), target.lastModified());
        if (upToDate) {
            log.debug((Object)("Unchanged file: " + target));
        }
        return upToDate;
    }

    public void write(String data, File file) throws IOException {
        this.write(new ByteArrayInputStream(data.getBytes()), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream is, File file) throws IOException {
        Handler handler;
        FileOutputStream os;
        if (file == null) {
            return;
        }
        boolean exists = file.exists();
        try {
            os = new FileOutputStream(file);
            log.debug((Object)((exists ? "Updated" : "Created") + " file: " + file));
        }
        catch (IOException e) {
            if (file.exists() && file.length() > 0L) {
                return;
            }
            String msg = "Error writing " + file + ": " + e.getMessage();
            throw new IOException(msg);
        }
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            os.close();
        }
        if (file instanceof PluginFile && (handler = ((PluginFile)file).handler).isExecutable()) {
            this.chmodx(file);
        }
    }

    public boolean chmod(File file, String mode) {
        if (GenericPlugin.isWin32() || file == null) {
            return false;
        }
        if (!file.exists()) {
            log.error((Object)String.format("Cannot chmod, file at %s doesn't exist.", file.getAbsolutePath()));
            return false;
        }
        if (!ChmodModeValidator.validateChmodMode(mode)) {
            log.error((Object)String.format("Cannot chmod file at %s, invalid mode.", file.getAbsolutePath()));
            return false;
        }
        try {
            String cmd = "chmod " + mode + " " + file;
            Process process = Runtime.getRuntime().exec(cmd);
            try {
                return process.waitFor() == 0;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean chmodx(File file) {
        return this.chmod(file, "+x");
    }

    static {
        ClientPluginDeployer.addHandlers(EX_DIRS, true);
        ClientPluginDeployer.addHandlers(DIRS, false);
    }

    private static class ChmodModeValidator {
        private static final String SYMBOLIC_MODE_REGEX;
        private static final Pattern SYMBOLIC_MODE_PATTERN;
        private static final String ABSOLUTE_MODE_REGEX = "[0-7]{1,4}";
        private static final Pattern ABSOLUTE_MODE_PATTERN;

        private ChmodModeValidator() {
        }

        private static boolean validateChmodMode(String mode) {
            if (ChmodModeValidator.validateAbsoluteMode(mode)) {
                return true;
            }
            return ChmodModeValidator.validateSymbolicMode(mode);
        }

        private static boolean validateAbsoluteMode(String mode) {
            Matcher m = ABSOLUTE_MODE_PATTERN.matcher(mode);
            return m.matches();
        }

        private static String createSymbolicModeRegex() {
            String perm = "rstwxXugo";
            String op = "\\+\\-\\=";
            String who = "augo";
            String action = String.format("%s\\s*%s", ChmodModeValidator.groupChars(op, false), ChmodModeValidator.groupChars(perm, true));
            String clause = String.format("%s\\s*%s", ChmodModeValidator.groupChars(who, true), ChmodModeValidator.groupAndQuantifyRegex(action, false));
            String modeRegex = String.format("%s%s", ChmodModeValidator.groupAndQuantifyRegex(clause, false), ChmodModeValidator.groupAndQuantifyRegex(",\\s*" + clause, true));
            return modeRegex;
        }

        private static boolean validateSymbolicMode(String mode) {
            Matcher m = SYMBOLIC_MODE_PATTERN.matcher(mode);
            return m.matches();
        }

        private static String groupChars(String chars, boolean multipleTimes) {
            String wrappedChars = String.format("[%s]", chars);
            if (!multipleTimes) {
                return wrappedChars;
            }
            return String.format("%s*", wrappedChars);
        }

        private static String groupAndQuantifyRegex(String regex, boolean allowZeroTimes) {
            String quanitifiedRegex = String.format("(%s)", regex);
            if (allowZeroTimes) {
                return String.format("%s*", quanitifiedRegex);
            }
            return String.format("%s+", quanitifiedRegex);
        }

        static {
            ABSOLUTE_MODE_PATTERN = Pattern.compile(ABSOLUTE_MODE_REGEX);
            SYMBOLIC_MODE_REGEX = ChmodModeValidator.createSymbolicModeRegex();
            SYMBOLIC_MODE_PATTERN = Pattern.compile(SYMBOLIC_MODE_REGEX);
        }
    }

    public class PluginFile
    extends File {
        static final long serialVersionUID = 255L;
        Handler handler;

        public PluginFile(String pathname) {
            super(pathname);
        }

        public PluginFile(File parent, String child) {
            super(parent, child);
        }

        public PluginFile(String parent, String child) {
            super(parent, child);
        }
    }

    public static class Handler {
        private final String name;
        private boolean isExecutable;

        Handler(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isExecutable() {
            return this.isExecutable;
        }

        public void setExecutable(boolean value) {
            this.isExecutable = value;
        }

        public File getSubDirectory(ClientPluginDeployer deployer) {
            return ClientPluginDeployer.getSubDirectory(deployer.pdk, this.name, deployer.plugin);
        }
    }
}

