/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.JDBCQueryCacheException;
import org.hyperic.util.jdbc.DBUtil;

public class JDBCQueryCache {
    private static final String _logCtx = JDBCQueryCache.class.getName();
    private final Log _log = LogFactory.getLog((String)_logCtx);
    private final Map _cache = new HashMap();
    private final String _query;
    private final String _queryKey;
    private long _last = -1L;
    private final long _cacheTimeout;

    public JDBCQueryCache(String query, String queryKey, long cacheTimeout) {
        this._query = query;
        this._queryKey = queryKey;
        this._cacheTimeout = cacheTimeout;
    }

    public void clearCache() {
        this._cache.clear();
    }

    public void setExpireTime(long expireTime) {
        this._last = expireTime - this._cacheTimeout;
    }

    public Object getOnlyRow(Connection conn, String column) throws SQLException, JDBCQueryCacheException {
        Set keys;
        long now = System.currentTimeMillis();
        if (this._cache.isEmpty() || now - this._cacheTimeout > this._last) {
            this.repopulateCache(conn);
        }
        if ((keys = this._cache.keySet()).size() > 1) {
            throw new JDBCQueryCacheException("cache contains more than one row");
        }
        if (keys.size() <= 0) {
            throw new JDBCQueryCacheException("cache does not contain any results");
        }
        List list = null;
        Iterator it = this._cache.entrySet().iterator();
        if (it.hasNext()) {
            Map.Entry entry = it.next();
            list = (List)entry.getValue();
        }
        if (list == null) {
            return null;
        }
        for (NameValuePair pair : list) {
            if (!pair.getName().equals(column)) continue;
            return pair.getValue();
        }
        throw new JDBCQueryCacheException("column " + column + " not found.");
    }

    public Object get(Connection conn, String key, String column) throws JDBCQueryCacheException, SQLException {
        List list;
        long now = System.currentTimeMillis();
        if (this._cache.isEmpty() || now - this._cacheTimeout > this._last) {
            this.repopulateCache(conn);
        }
        if ((list = (List)this._cache.get(key)) == null) {
            return null;
        }
        for (NameValuePair pair : list) {
            if (!pair.getName().equalsIgnoreCase(column)) continue;
            return pair.getValue();
        }
        throw new JDBCQueryCacheException("key " + key + ", column " + column + " not found.");
    }

    private void repopulateCache(Connection conn) throws SQLException, JDBCQueryCacheException {
        Statement stmt = null;
        ResultSet rs = null;
        if (this._log.isDebugEnabled()) {
            String msg = "re-populating JDBCQueryCache for " + this._query + " with queryKey of " + this._queryKey;
            this._log.debug((Object)msg);
        }
        try {
            this._cache.clear();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(this._query);
            List columns = this.getQueryColumns(rs);
            boolean debug = this._log.isDebugEnabled();
            while (rs.next()) {
                int i = 1;
                ArrayList<NameValuePair> vals = new ArrayList<NameValuePair>();
                String key = null;
                for (String column : columns) {
                    if (column.equalsIgnoreCase(this._queryKey)) {
                        key = rs.getString(i);
                    } else {
                        String tmp = rs.getString(i);
                        String string = tmp = rs.wasNull() ? null : tmp;
                        if (debug) {
                            this._log.debug((Object)("adding nameValuePair=" + column + "/" + tmp));
                        }
                        vals.add(new NameValuePair(column, tmp));
                    }
                    ++i;
                }
                if (key == null) {
                    throw new JDBCQueryCacheException("queryKey, " + this._queryKey + " was not represented in the query");
                }
                if (debug) {
                    this._log.debug((Object)("adding key=" + key));
                }
                this._cache.put(key, vals);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, rs);
                this._last = System.currentTimeMillis();
                throw throwable;
            }
        }
        DBUtil.closeJDBCObjects((Object)_logCtx, null, (Statement)stmt, (ResultSet)rs);
        this._last = System.currentTimeMillis();
    }

    private List getQueryColumns(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int size = rsmd.getColumnCount();
        ArrayList<String> rtn = new ArrayList<String>(size);
        for (int i = 1; i <= size; ++i) {
            rtn.add(rsmd.getColumnLabel(i));
        }
        return rtn;
    }

    private class NameValuePair {
        private final String _name;
        private final Object _value;

        public NameValuePair(String name, Object value) {
            this._name = name;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public Object getValue() {
            return this._value;
        }
    }
}

