/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.util.StringUtil;

public abstract class TypeInfo {
    public static final int TYPE_PLATFORM = 1;
    public static final int TYPE_SERVER = 2;
    public static final int TYPE_SERVICE = 3;
    private String name;
    private String description;
    private String formattedName = null;

    public abstract int getType();

    public static String formatName(String name) {
        return StringUtil.replace((String)name.toLowerCase(), (String)" ", (String)"-");
    }

    public String getFormattedName() {
        if (this.formattedName == null) {
            this.formattedName = TypeInfo.formatName(this.getName());
        }
        return this.formattedName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object otherObj) {
        String[] mPlatformTypes;
        TypeInfo other = (TypeInfo)otherObj;
        String[] oPlatformTypes = other.getPlatformTypes();
        if (oPlatformTypes.length != (mPlatformTypes = this.getPlatformTypes()).length) {
            return false;
        }
        for (int i = 0; i < oPlatformTypes.length; ++i) {
            if (oPlatformTypes[i].equals(mPlatformTypes[i])) continue;
            return false;
        }
        return other.getName().equals(this.name) && other.getType() == this.getType();
    }

    public boolean isServer(String name) {
        return this.isServer(name, null);
    }

    public boolean isServer(String name, String version) {
        if (this.getType() != 2) {
            return false;
        }
        if (version == null) {
            version = ((ServerTypeInfo)this).getVersion();
        }
        return this.getName().equals(name + " " + version);
    }

    public boolean isService(String name) {
        return this.isService(name, null);
    }

    public boolean isService(String name, String version) {
        if (this.getType() != 3) {
            return false;
        }
        ServiceTypeInfo si = (ServiceTypeInfo)this;
        if (version != null && !version.equals(si.getServerVersion())) {
            return false;
        }
        return this.getName().equals(si.getServerName() + " " + name);
    }

    public String getVersion() {
        String sVersion;
        switch (this.getType()) {
            case 3: {
                sVersion = ((ServiceTypeInfo)this).getServerVersion();
                break;
            }
            case 2: {
                sVersion = ((ServerTypeInfo)this).getVersion();
                break;
            }
            default: {
                throw new IllegalArgumentException("not a server or service");
            }
        }
        return sVersion;
    }

    public boolean isVersion(String version) {
        return this.getVersion().equals(version);
    }

    public String[] getPlatformTypes() {
        ServerTypeInfo server;
        switch (this.getType()) {
            case 2: {
                server = (ServerTypeInfo)this;
                break;
            }
            case 3: {
                server = ((ServiceTypeInfo)this).getServerTypeInfo();
                break;
            }
            case 1: {
                return new String[]{this.getName()};
            }
            default: {
                return null;
            }
        }
        return server.getValidPlatformTypes();
    }

    public boolean isUnixPlatform() {
        return this.getPlatformTypes().length != 1 || !PlatformDetector.isWin32(this.getPlatformTypes()[0]);
    }

    public boolean isWin32Platform() {
        return this.getPlatformTypes().length == 1 && PlatformDetector.isWin32(this.getPlatformTypes()[0]);
    }
}

