/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.measurement.MeasurementConstants;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.MeasurementInfos;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceType;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.StringConfigOption;
import org.hyperic.util.filter.TokenReplacer;

public class ServiceTypeFactory {
    private static final Set VALID_CATEGORIES = new HashSet<String>(Arrays.asList(MeasurementConstants.VALID_CATEGORIES));
    private static final Set VALID_UNITS = new HashSet<String>(Arrays.asList(MeasurementConstants.VALID_UNITS));
    private Log log = LogFactory.getLog(ServiceTypeFactory.class);

    private void addControlActions(ServiceType serviceType, ModelMBeanInfo serviceInfo) {
        HashSet<String> actions = new HashSet<String>();
        MBeanOperationInfo[] operations = serviceInfo.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            actions.add(operations[i].getName());
        }
        serviceType.setControlActions(actions);
    }

    private void addCustomProperties(ServiceType serviceType, ModelMBeanInfo serviceInfo) {
        ConfigSchema propertiesSchema = new ConfigSchema();
        MBeanAttributeInfo[] attributes = serviceInfo.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (this.isMetric(attributes[i])) continue;
            String description = attributes[i].getDescription();
            if (description == null) {
                description = "";
            }
            propertiesSchema.addOption((ConfigOption)new StringConfigOption(attributes[i].getName(), description));
            if (!attributes[i].isWritable()) continue;
            serviceType.addControlAction("set" + attributes[i].getName());
        }
        serviceType.setCustomProperties(propertiesSchema);
    }

    private void addFilter(String key, Properties properties, TokenReplacer replacer) {
        String val = properties.getProperty(key);
        if (val != null) {
            replacer.addFilter(key, val);
        }
    }

    private void addMeasurements(ServiceType serviceType, ProductPlugin productPlugin, ModelMBeanInfo serviceInfo) {
        MeasurementInfos measurements = new MeasurementInfos();
        MBeanAttributeInfo[] attributes = serviceInfo.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!this.isMetric(attributes[i])) continue;
            measurements.addMeasurementInfo(this.createMeasurementInfo(serviceType, productPlugin, (ModelMBeanAttributeInfo)attributes[i]));
        }
        measurements.addMeasurementInfo(this.createAvailabilityMeasurement(serviceType, productPlugin));
        serviceType.setMeasurements(measurements);
    }

    private void addMeasurementTemplate(Properties measurementProperties, ProductPlugin productPlugin, ServiceType serviceType) {
        TokenReplacer replacer = new TokenReplacer();
        String objectName = serviceType.getProperties().getValue(serviceType.getInfo().getName() + ".OBJECT_NAME");
        this.addFilter("alias", measurementProperties, replacer);
        this.addFilter("name", measurementProperties, replacer);
        replacer.addFilter("OBJECT_NAME", objectName);
        String template = this.filter(productPlugin.getPluginProperty("template"), productPlugin, replacer);
        measurementProperties.put("template", template);
    }

    private void addPlugins(ServiceType serviceType, ProductPlugin productPlugin) {
        ConfigResponse pluginClasses = new ConfigResponse();
        pluginClasses.setValue("measurement", productPlugin.getPluginProperty("measurement-class"));
        pluginClasses.setValue("control", productPlugin.getPluginProperty("control-class"));
        serviceType.setPluginClasses(pluginClasses);
    }

    private void addProperties(ServiceType serviceType, ObjectName objectName) {
        ConfigResponse properties = new ConfigResponse();
        properties.setValue(serviceType.getInfo().getName() + ".NAME", serviceType.getServiceName());
        properties.setValue(serviceType.getInfo().getName() + ".OBJECT_NAME", this.getObjectNameProperty(objectName));
        serviceType.setProperties(properties);
    }

    public Set create(ProductPlugin productPlugin, ServerTypeInfo serverType, MBeanServerConnection mServer, Set objectNames) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        HashSet<ServiceType> serviceTypes = new HashSet<ServiceType>();
        for (ObjectName objectName : objectNames) {
            ServiceType serviceType;
            ServiceType identityType;
            MBeanInfo serviceInfo = mServer.getMBeanInfo(objectName);
            if (!(serviceInfo instanceof ModelMBeanInfo) || (identityType = this.getServiceType(productPlugin.getName(), serverType, (ModelMBeanInfo)((Object)serviceInfo), objectName)) == null || serviceTypes.contains(identityType) || (serviceType = this.create(productPlugin, serverType, (ModelMBeanInfo)((Object)serviceInfo), objectName)) == null) continue;
            serviceTypes.add(serviceType);
        }
        return serviceTypes;
    }

    public ServiceType create(ProductPlugin productPlugin, ServerTypeInfo serverType, ModelMBeanInfo serviceInfo, ObjectName objectName) {
        ServiceType serviceType = this.getServiceType(productPlugin.getName(), serverType, serviceInfo, objectName);
        if (serviceType == null) {
            return null;
        }
        this.addControlActions(serviceType, serviceInfo);
        this.addCustomProperties(serviceType, serviceInfo);
        this.addProperties(serviceType, objectName);
        this.addPlugins(serviceType, productPlugin);
        this.addMeasurements(serviceType, productPlugin, serviceInfo);
        return serviceType;
    }

    private MeasurementInfo createAvailabilityMeasurement(ServiceType serviceType, ProductPlugin productPlugin) {
        Properties measurementProperties = new Properties();
        measurementProperties.put("units", "percentage");
        measurementProperties.put("name", "Availability");
        measurementProperties.put("alias", "Availability");
        measurementProperties.put("collectionType", "dynamic");
        measurementProperties.put("category", "AVAILABILITY");
        measurementProperties.put("indicator", "true");
        measurementProperties.put("defaultOn", "true");
        measurementProperties.put("interval", "600000");
        this.addMeasurementTemplate(measurementProperties, productPlugin, serviceType);
        return this.createMeasurementInfo(measurementProperties);
    }

    private MeasurementInfo createMeasurementInfo(Properties measurementProperties) {
        MeasurementInfo metric = new MeasurementInfo();
        try {
            metric.setAttributes(measurementProperties);
        }
        catch (Exception e) {
            this.log.warn((Object)("Error setting metric attributes.  Cause: " + e.getMessage()));
        }
        metric.setCategory(metric.getCategory().toUpperCase());
        return metric;
    }

    private MeasurementInfo createMeasurementInfo(ServiceType serviceType, ProductPlugin productPlugin, ModelMBeanAttributeInfo attribute) {
        String category;
        Properties measurementProperties = new Properties();
        Descriptor descriptor = attribute.getDescriptor();
        String units = (String)descriptor.getFieldValue("units");
        if ("s".equals(units)) {
            units = "sec";
        }
        if (!VALID_UNITS.contains(units)) {
            measurementProperties.put("units", "none");
        } else {
            measurementProperties.put("units", units);
        }
        String displayName = (String)descriptor.getFieldValue("displayName");
        if (displayName == null) {
            measurementProperties.put("name", attribute.getName());
        } else {
            measurementProperties.put("name", displayName);
        }
        measurementProperties.put("alias", attribute.getName());
        String metricType = (String)descriptor.getFieldValue("metricType");
        if (metricType == null || !"COUNTER".equals(metricType.toUpperCase())) {
            measurementProperties.put("collectionType", "dynamic");
            measurementProperties.put("interval", "300000");
        } else {
            measurementProperties.put("collectionType", "trendsup");
            String rate = (String)descriptor.getFieldValue("rate");
            if (rate != null) {
                measurementProperties.put("rate", rate);
            } else {
                measurementProperties.put("rate", "none");
            }
            measurementProperties.put("interval", "600000");
        }
        String collectionInterval = (String)descriptor.getFieldValue("collectionInterval");
        if (collectionInterval != null) {
            try {
                Long.valueOf(collectionInterval);
                measurementProperties.put("interval", collectionInterval);
            }
            catch (NumberFormatException e) {
                this.log.warn((Object)("Specified collection interval " + collectionInterval + " is not numeric.  Default value will be used instead."));
            }
        }
        if ((category = (String)descriptor.getFieldValue("metricCategory")) == null || !VALID_CATEGORIES.contains(category.toUpperCase())) {
            measurementProperties.put("category", "UTILIZATION");
        } else {
            measurementProperties.put("category", category.toUpperCase());
        }
        String indicator = (String)descriptor.getFieldValue("indicator");
        if (indicator == null || "true".equals(indicator.toLowerCase())) {
            measurementProperties.put("indicator", "true");
            measurementProperties.put("defaultOn", "true");
        } else {
            measurementProperties.put("indicator", "false");
            measurementProperties.put("defaultOn", "false");
        }
        String defaultOn = (String)descriptor.getFieldValue("defaultOn");
        if (defaultOn != null) {
            if ("true".equals(defaultOn.toLowerCase()) || "false".equals(defaultOn.toLowerCase())) {
                measurementProperties.put("defaultOn", defaultOn.toLowerCase());
            } else {
                this.log.warn((Object)("Invalid value of " + defaultOn + " specified for defaultOn.  Default value will be used instead."));
            }
        }
        this.addMeasurementTemplate(measurementProperties, productPlugin, serviceType);
        return this.createMeasurementInfo(measurementProperties);
    }

    private String filter(String val, ProductPlugin productPlugin, TokenReplacer replacer) {
        return replacer.replaceTokens(val);
    }

    private String getObjectNameProperty(ObjectName objectName) {
        StringBuffer objectNameProperty = new StringBuffer(objectName.getDomain()).append(':');
        Hashtable<String, String> keyProperties = objectName.getKeyPropertyList();
        for (Map.Entry<String, String> keyProperty : keyProperties.entrySet()) {
            objectNameProperty.append((Object)keyProperty.getKey()).append('=');
            if ("type".equals(keyProperty.getKey()) || "subtype".equals(keyProperty.getKey())) {
                objectNameProperty.append((Object)keyProperty.getValue());
            } else {
                objectNameProperty.append('%').append((Object)keyProperty.getKey()).append('%');
            }
            objectNameProperty.append(',');
        }
        objectNameProperty.deleteCharAt(objectNameProperty.length() - 1);
        return objectNameProperty.toString();
    }

    public ServiceType getServiceType(String productName, ServerTypeInfo serverType, ModelMBeanInfo serviceInfo, ObjectName objectName) {
        String serviceTypeName = objectName.getKeyProperty("type");
        String subType = objectName.getKeyProperty("subtype");
        if (subType != null) {
            serviceTypeName = serviceTypeName + " " + subType;
        }
        try {
            Descriptor serviceDescriptor = serviceInfo.getMBeanDescriptor();
            if ("false".equals(serviceDescriptor.getFieldValue("export"))) {
                return null;
            }
            String serviceType = (String)serviceDescriptor.getFieldValue("typeName");
            if (serviceType != null) {
                serviceTypeName = serviceType;
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Error obtaining MBeanInfo descriptor field values.  Default values will be used.  Cause: " + e.getMessage()));
        }
        return new ServiceType(serviceTypeName, productName, new ServiceTypeInfo(serverType.getName() + ' ' + serviceTypeName, serviceInfo.getDescription(), serverType));
    }

    private boolean isMetric(MBeanAttributeInfo attribute) {
        if (attribute instanceof ModelMBeanAttributeInfo) {
            String attributeType = (String)((ModelMBeanAttributeInfo)attribute).getDescriptor().getFieldValue("attributeType");
            if (attributeType != null) {
                return "Metric".equals(attributeType);
            }
            String metricType = (String)((ModelMBeanAttributeInfo)attribute).getDescriptor().getFieldValue("metricType");
            if (metricType != null) {
                return true;
            }
        }
        return false;
    }
}

