/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.jmx;

import java.util.ArrayList;
import java.util.List;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.jmx.MxServerDetector;
import org.hyperic.sigar.ProcUtil;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;

public class SunMxServerDetector
extends MxServerDetector {
    private static final String HQ_NAME = "-Dhq." + StringUtil.replace((String)"AUTOINVENTORY_NAME".toLowerCase(), (String)"_", (String)".") + "=";
    private static final String URL_QUERY = "State.Name.sw=java,Args.*.eq=";

    private String getMainClass(long pid) {
        try {
            return ProcUtil.getJavaMainClass((SigarProxy)SunMxServerDetector.getSigar(), (long)pid);
        }
        catch (SigarException e) {
            return null;
        }
    }

    @Override
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.setPlatformConfig(platformConfig);
        String enabled = this.getManager().getProperty("jmx.sun.discover", "false");
        if (enabled.equals("false")) {
            return null;
        }
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        long[] pids = SunMxServerDetector.getPids("State.Name.sw=java");
        for (int i = 0; i < pids.length; ++i) {
            long pid = pids[i];
            String[] args = SunMxServerDetector.getProcArgs(pid);
            ConfigResponse config = new ConfigResponse();
            String name = null;
            String query = null;
            String identifier = null;
            boolean configuredURL = false;
            for (int j = 0; j < args.length; ++j) {
                String arg = args[j];
                if (!arg.startsWith("-Dcom.sun.management.jmxremote")) {
                    if (!arg.startsWith(HQ_NAME)) continue;
                    query = URL_QUERY + arg;
                    identifier = name = arg.substring(HQ_NAME.length());
                    continue;
                }
                if (name == null && (name = this.getMainClass(pid)) != null) {
                    query = URL_QUERY + arg;
                }
                if (!this.configureMxURL(config, arg) && !this.configureLocalMxURL(config, arg, query)) continue;
                configuredURL = true;
                if (name == null || (name = name.trim()).length() == 0) {
                    String port = this.parseMxPort(arg);
                    if (port == null) {
                        name = " (local)";
                        continue;
                    }
                    name = "@ " + port;
                    if (identifier != null) continue;
                    identifier = arg;
                    continue;
                }
                String productName = this.getProperties().getProperty("MAIN-CLASS." + name);
                if (productName == null) continue;
                name = productName;
            }
            if (!configuredURL) continue;
            String installpath = SunMxServerDetector.getCanonicalPath(SunMxServerDetector.getProcExe(pid));
            ServerResource server = this.newServerResource(installpath);
            if (identifier != null && server.getIdentifier().equals(installpath)) {
                server.setIdentifier(identifier);
            }
            server.setName(server.getName() + " " + name);
            this.discoverServerConfig(server, pid);
            this.getLog().debug((Object)(server.getName() + " identifier=" + identifier));
            this.setProductConfig(server, config);
            server.setMeasurementConfig();
            servers.add(server);
        }
        return servers;
    }
}

