/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.hq.product.pluginxml.ProductTag;
import org.hyperic.util.filter.TokenReplacer;
import org.hyperic.util.xmlparser.XmlParseException;
import org.hyperic.util.xmlparser.XmlParser;
import org.hyperic.util.xmlparser.XmlTagHandler;
import org.xml.sax.EntityResolver;

public class PluginParser {
    private static final Log log = LogFactory.getLog((String)"PluginParser");
    private TokenReplacer replacer;
    private boolean collectMetrics = true;
    private boolean collectHelp = true;

    public void collectMetrics(boolean collect) {
        this.collectMetrics = collect;
    }

    public void collectHelp(boolean collect) {
        this.collectHelp = collect;
    }

    public void parse(InputStream in, PluginData data) throws PluginException {
        this.parse(in, data, new PluginData.PluginResolver(data));
    }

    public void parse(InputStream in, PluginData data, EntityResolver resolver) throws PluginException {
        this.replacer = new TokenReplacer();
        this.replacer.addFilters(PluginData.getGlobalProperties());
        this.replacer.addFilters((Map)System.getProperties());
        data.parser = this;
        data.scratch = new HashMap();
        ProductTag tag = new ProductTag(data);
        tag.collectMetrics = this.collectMetrics;
        tag.collectHelp = this.collectHelp;
        try {
            XmlParser.parse((InputStream)in, (XmlTagHandler)tag, (EntityResolver)resolver);
        }
        catch (XmlParseException e) {
            throw new PluginException(e);
        }
        String[] keys = new String[data.help.size()];
        data.help.keySet().toArray(keys);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!Character.isLowerCase(key.charAt(0)) || !Character.isLowerCase(key.charAt(1))) continue;
            data.help.remove(key);
        }
        this.replacer = null;
        data.parser = null;
        data.scratch.clear();
        data.scratch = null;
    }

    String applyFilters(String s) {
        String orig;
        do {
            orig = s;
        } while (!(s = this.replacer.replaceTokens(s)).equals(orig));
        return s;
    }

    void addFilter(String key, String value) {
        this.replacer.addFilter(key, value);
    }

    String getFilter(String key) {
        return this.replacer.getFilter(key);
    }

    void addFilters(Map props) {
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.addFilter(key, value);
        }
    }

    public static void dumpFormat(PrintStream out) {
        XmlParser.dump((XmlTagHandler)new ProductTag(null), (PrintStream)out);
    }

    public static void dumpFormatWiki(PrintStream out) {
        XmlParser.dumpWiki((XmlTagHandler)new ProductTag(null), (PrintStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int i;
        if (args.length == 0) {
            PluginParser.dumpFormat(System.out);
            return;
        }
        new ProductPluginManager().init();
        ArrayList<String> files = new ArrayList<String>();
        PluginParser parser = new PluginParser();
        PluginData data = new PluginData();
        for (i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                files.add(args[i]);
                continue;
            }
            if (args[i].equals("-nometrics")) {
                parser.collectMetrics(false);
                continue;
            }
            if (args[i].equals("-nohelp")) {
                parser.collectHelp(false);
                continue;
            }
            if (!args[i].equals("-wiki")) continue;
            PluginParser.dumpFormatWiki(System.out);
            return;
        }
        for (i = 0; i < files.size(); ++i) {
            String name = (String)files.get(i);
            FileInputStream is = null;
            try {
                System.out.println(name);
                is = new FileInputStream(new File(name));
                parser.parse(is, data, null);
                continue;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        data.dumpXML();
    }
}

