/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hyperic.hq.product.ObjectModel;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ServerTypeInfo;
import org.hyperic.hq.product.ServiceTypeInfo;
import org.hyperic.hq.product.TypeBuilder;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.hq.product.pluginxml.MetricsTag;
import org.hyperic.hq.product.pluginxml.PlatformTag;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.hq.product.pluginxml.ProductTag;
import org.hyperic.hq.product.pluginxml.ResourceTag;
import org.hyperic.hq.product.pluginxml.ScanTag;
import org.hyperic.hq.product.pluginxml.ServiceTag;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.xmlparser.XmlAttrException;
import org.hyperic.util.xmlparser.XmlEndAttrHandler;
import org.hyperic.util.xmlparser.XmlTagException;
import org.hyperic.util.xmlparser.XmlTagHandler;
import org.hyperic.util.xmlparser.XmlTagInfo;

class ServerTag
extends ResourceTag
implements XmlEndAttrHandler {
    static final String ATTR_PLATFORMS = "platforms";
    static final String ATTR_VIRTUAL = "virtual";
    static final String ATTR_ROAMING = "roaming";
    private static final String[] OPTIONAL_ATTRS = new String[]{"name", "version", "platforms", "description", "include", "virtual", "roaming"};
    ProductTag product;
    PlatformTag platform = null;
    boolean isIncluded;
    private HashMap serverMap;
    private TypeBuilder builder;
    private String[][] platformTypes;
    private ServerTypeInfo server;
    HashMap includedServices = new HashMap();

    ServerTag(BaseTag parent) {
        super(parent);
        if (parent instanceof PlatformTag) {
            this.platform = (PlatformTag)parent;
            this.product = (ProductTag)this.platform.parent;
        } else {
            this.product = (ProductTag)parent;
        }
    }

    private ServiceTypeInfo addBuilderService(ServerTypeInfo server, String name) {
        String serviceName = server.getName() + " " + name;
        if (this.platform != null) {
            if (this.platform.type.isDevice() && this.server.isVirtual()) {
                serviceName = this.platform.typeName + " " + name;
            }
        } else if (server.isVirtual()) {
            serviceName = name;
        }
        ServiceTypeInfo service = new ServiceTypeInfo(serviceName, server.getDescription() + " " + name, server);
        this.builder.add(service);
        return service;
    }

    ServiceTypeInfo addService(String name, boolean isInternal) {
        return this.addService(name, isInternal, ObjectModel.STANDARD);
    }

    ServiceTypeInfo addService(String name, boolean isInternal, ObjectModel model) {
        ServiceTypeInfo service = null;
        if (this.isIncluded) {
            String typeName = this.server.getName() + " " + name;
            service = (ServiceTypeInfo)this.includedServices.get(typeName);
            if (service != null) {
                return service;
            }
            for (ServerTypeInfo server : this.serverMap.values()) {
                service = this.addBuilderService(server, name);
                service.setInternal(isInternal);
                service.setModel(model);
            }
        } else {
            service = this.addBuilderService(this.server, name);
            service.setInternal(isInternal);
            service.setModel(model);
        }
        return service;
    }

    @Override
    int getResourceType() {
        return 2;
    }

    @Override
    public String getName() {
        return "server";
    }

    @Override
    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    @Override
    public XmlTagInfo[] getSubTags() {
        XmlTagInfo[] tags = new XmlTagInfo[]{new XmlTagInfo((XmlTagHandler)new ServiceTag(this), 3), new XmlTagInfo((XmlTagHandler)new ScanTag(this), 3)};
        return this.getMergedSubTags(super.getSubTags(), tags);
    }

    @Override
    public void startTag() {
        this.isIncluded = false;
        this.builder = new TypeBuilder();
    }

    private TypeInfo[] getSavedTypes(String key) {
        return (TypeInfo[])this.getScratch(key);
    }

    private void putSavedTypes(TypeInfo[] types) {
        this.putScratch(this.typeName, types);
    }

    private void includePlugin(String type, String from, String to) {
        String plugin = this.data.getPlugin(type, from);
        if (plugin != null) {
            this.data.addPlugin(type, to, plugin);
        }
    }

    private void includePlugins(String from, String to) {
        for (int j = 0; j < ProductPlugin.TYPES.length; ++j) {
            this.includePlugin(ProductPlugin.TYPES[j], from, to);
        }
        this.includePlugin("collector", from, to);
    }

    private void includeConfigSchema(String from, String to) {
        for (int i = 0; i < ProductPlugin.CONFIGURABLE_TYPES.length; ++i) {
            ConfigSchema schema = this.data.getConfigSchema(from, i);
            if (schema == null) continue;
            this.data.addConfigSchema(to, i, schema);
        }
    }

    private void includeCustomPropertiesSchema(String from, String to) {
        ConfigSchema schema = this.data.getCustomPropertiesSchema(from);
        if (schema != null) {
            ConfigSchema cpropSchema = new ConfigSchema();
            cpropSchema.addOptions(schema.getOptions());
            this.data.addCustomPropertiesSchema(to, cpropSchema);
        }
    }

    private void includeHelp(String from, String to) {
        if (!this.collectHelp) {
            return;
        }
        if (this.data.help.get(to) != null) {
            return;
        }
        String help = (String)this.data.help.get(from);
        if (help != null) {
            this.data.help.put(to, help);
        }
    }

    private void includeActions(String from, String to) {
        if (this.data.getControlActions(to) != null) {
            return;
        }
        List controlActions = this.data.getControlActions(from);
        if (controlActions != null) {
            this.data.addControlActions(to, controlActions);
        }
    }

    private void includeComponents(TypeInfo fromType, TypeInfo toType) {
        String[] platforms = fromType.getPlatformTypes();
        String from = fromType.getName();
        String to = toType.getName();
        for (int i = 0; i < platforms.length; ++i) {
            String fromTypeName = from + " " + platforms[i];
            String toTypeName = to + " " + platforms[i];
            this.includeHelp(fromTypeName, toTypeName);
            this.includePlugins(fromTypeName, toTypeName);
            this.includeConfigSchema(fromTypeName, toTypeName);
            this.includeCustomPropertiesSchema(fromTypeName, toTypeName);
            this.includeActions(fromTypeName, toTypeName);
        }
        this.includeHelp(from, to);
        this.includePlugins(from, to);
        this.includeConfigSchema(from, to);
        this.includeCustomPropertiesSchema(from, to);
        this.includeActions(from, to);
        this.data.includeGlobalProperties(fromType.getName(), toType.getName());
    }

    private void includeMetrics(String name, String include, boolean overrideMetrics) {
        MetricsTag.includeMetrics(this.data, name, include, overrideMetrics);
    }

    private void includeServer(String name, String version, String description, String include) throws XmlAttrException {
        String nameValue;
        TypeInfo info;
        TypeInfo type;
        int i;
        List keys;
        List sigs;
        String key;
        TypeInfo[] types = this.getSavedTypes(include);
        if (types == null && (types = this.getSavedTypes(key = name + " " + include)) != null) {
            include = key;
        }
        if (types == null) {
            throw new XmlAttrException("server include='" + include + "', name=" + name + " not found");
        }
        this.isIncluded = true;
        String serverType = name + " " + version;
        if (this.collectMetrics) {
            this.includeMetrics(serverType, include, false);
        }
        if ((sigs = this.data.getFileScanIncludes(include)) != null) {
            this.data.addFileScanIncludes(serverType, sigs);
        }
        if ((sigs = this.data.getRegistryScanIncludes(include)) != null) {
            this.data.addRegistryScanIncludes(serverType, sigs);
        }
        if ((keys = this.data.getRegistryScanKeys(include)) != null) {
            for (i = 0; i < keys.size(); ++i) {
                this.data.addRegistryScanKey(serverType, (String)keys.get(i));
            }
        }
        this.serverMap = new HashMap();
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            if (type.getType() != 2) continue;
            info = (ServerTypeInfo)type;
            nameValue = this.getNameProperty(info);
            info = (ServerTypeInfo)((ServerTypeInfo)info).clone();
            this.serverMap.put(type, info);
            info.setName(serverType);
            ((ServerTypeInfo)info).setVersion(version);
            if (description != null) {
                info.setDescription(description);
            }
            this.setNameProperty(info.getName(), nameValue);
            this.builder.add(info);
            this.includeComponents(type, info);
            this.server = info;
            this.typeName = info.getName();
        }
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            if (type.getType() != 3) continue;
            info = (ServiceTypeInfo)type;
            nameValue = this.getNameProperty(info);
            info = (ServiceTypeInfo)((ServiceTypeInfo)info).clone();
            ServerTypeInfo server = (ServerTypeInfo)this.serverMap.get(((ServiceTypeInfo)info).getServerTypeInfo());
            ((ServiceTypeInfo)info).setServerTypeInfo(server);
            info.setName(StringUtil.replace((String)info.getName(), (String)include, (String)serverType));
            this.includedServices.put(info.getName(), info);
            this.setNameProperty(info.getName(), nameValue);
            this.builder.add(info);
            this.includeComponents(type, info);
            if (!this.collectMetrics) continue;
            this.includeMetrics(info.getName(), type.getName(), false);
        }
        Map serviceInventoryPlugins = this.data.getServiceInventoryPlugins(include);
        if (serviceInventoryPlugins != null) {
            for (Map.Entry entry : serviceInventoryPlugins.entrySet()) {
                String serviceName = (String)entry.getKey();
                String impl = (String)entry.getValue();
                if (PluginData.getServiceExtension(serviceName) != null) continue;
                serviceName = StringUtil.replace((String)serviceName, (String)include, (String)serverType);
                this.data.addServiceInventoryPlugin(this.typeName, serviceName, impl);
            }
        }
    }

    public void endAttributes() throws XmlAttrException {
        String include = this.getAttribute("include");
        String name = this.getAttribute("name");
        String version = this.getAttribute("version");
        String platforms = this.getAttribute(ATTR_PLATFORMS);
        String description = this.getAttribute("description");
        String virtual = this.getAttribute(ATTR_VIRTUAL);
        String roaming = this.getAttribute(ATTR_ROAMING);
        if (this.platform != null) {
            if (name == null) {
                name = this.platform.typeName + " Server";
                if (virtual == null) {
                    virtual = "true";
                }
            }
        } else if (name == null) {
            throw new XmlAttrException("missing server 'name' attribute");
        }
        if (version == null) {
            version = "x";
        }
        if (roaming == null) {
            roaming = "false";
        }
        if (include != null) {
            this.includeServer(name, version, description, include);
            return;
        }
        if (platforms == null) {
            this.platformTypes = this.platform != null && this.platform.type.isDevice() ? new String[][]{{this.platform.typeName}} : new String[][]{TypeBuilder.ALL_PLATFORM_NAMES};
        } else {
            List platformList = StringUtil.explode((String)platforms, (String)",");
            int len = platformList.size();
            int offset = 0;
            this.platformTypes = new String[len][];
            if (platformList.remove("Unix")) {
                offset = 1;
                this.platformTypes[0] = TypeBuilder.UNIX_PLATFORM_NAMES;
            } else if (platformList.remove("Win32")) {
                offset = 1;
                this.platformTypes[0] = TypeBuilder.WIN32_PLATFORM_NAMES;
            }
            for (int i = 0; i < platformList.size(); ++i) {
                this.platformTypes[i + offset] = new String[]{(String)platformList.get(i)};
            }
        }
        this.server = this.builder.addServer(name, version, this.platformTypes[0]);
        if (description == null) {
            description = name + " Server";
        }
        this.server.setDescription(description);
        this.typeName = this.server.getName();
        if ("true".equals(virtual)) {
            this.server.setVirtual(true);
        }
        if ("true".equals(roaming)) {
            this.server.setRoaming(true);
        }
        this.setNameProperty(name);
    }

    @Override
    void endTag() throws XmlTagException {
        if (!this.isIncluded && this.platformTypes.length != 1) {
            for (int j = 1; j < this.platformTypes.length; ++j) {
                this.builder.addServerAndServices(this.server, this.platformTypes[j]);
            }
        }
        this.includedServices.clear();
        TypeInfo[] types = this.builder.getTypes();
        this.server = null;
        this.platformTypes = null;
        this.serverMap = null;
        this.putSavedTypes(types);
        this.data.addTypes(types);
        super.endTag();
    }
}

