/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerExtValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.ScanConfiguration;
import org.hyperic.hq.autoinventory.ScanListener;
import org.hyperic.hq.autoinventory.ScanManager;
import org.hyperic.hq.autoinventory.ScanMethod;
import org.hyperic.hq.autoinventory.ScanState;
import org.hyperic.hq.autoinventory.Scanner;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.hq.autoinventory.scanimpl.FileScan;
import org.hyperic.hq.autoinventory.scanimpl.NullScan;
import org.hyperic.hq.autoinventory.scanimpl.WindowsRegistryScan;
import org.hyperic.hq.common.SystemException;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.hq.product.FileServerDetector;
import org.hyperic.hq.product.PlatformDetector;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PlatformTypeInfo;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.RegistryServerDetector;
import org.hyperic.hq.product.RuntimeDiscoverer;
import org.hyperic.hq.product.RuntimeResourceReport;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.util.PluginDumper;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.AutoApproveConfig;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.file.FileUtil;

public class PluginDiscoverer
implements ScanListener {
    private static final boolean IS_WIN32 = PlatformDetector.IS_WIN32;
    private final ProductPluginManager ppm;
    private final ScanManager scanManager;
    private final Log log;
    private final ArrayList autoSignatures = new ArrayList();
    private final ArrayList rgySignatures = new ArrayList();
    private final ArrayList fileSignatures = new ArrayList();
    private Set servers;
    private final PluginDumper pd;
    private boolean dumpProps = false;
    private boolean fetchMetrics = false;
    private final ConfigResponse platformConfig;
    private String os;

    public PluginDiscoverer(PluginDumper pd) {
        this.pd = pd;
        this.log = LogFactory.getLog(PluginDiscoverer.class);
        this.ppm = pd.ppm;
        this.platformConfig = this.getPlatformConfig();
        String aacPath = System.getProperty("autoapproveconfig.path", "config");
        AutoApproveConfig aac = null;
        try {
            aac = new AutoApproveConfig(aacPath, AgentConfig.PROP_ENC_KEY_FILE[1]);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        this.scanManager = new ScanManager(this, this.log, this.ppm, null, aac, null);
        this.scanManager.startup();
        this.fetchMetrics = "metric".equals(this.pd.config.action);
        this.dumpProps = this.fetchMetrics || "properties".equals(this.pd.config.action);
    }

    private ServerDetector getPlugin(String name) throws PluginNotFoundException {
        ServerDetector detector = (ServerDetector)this.getAutoinventoryPluginManager().getPlatformPlugin(this.os, name);
        return detector;
    }

    @Override
    public void scanComplete(ScanState state) throws AutoinventoryException, SystemException {
        this.servers = state.getAllServers();
    }

    private void addScanners(ScanConfiguration scanConfig, ScanMethod method, List sigList, ConfigResponse config) {
        Object[] sigs = sigList.toArray(new ServerSignature[0]);
        Object[] signatures = scanConfig.getServerSignatures();
        signatures = (ServerSignature[])ArrayUtil.combine((Object[])signatures, (Object[])sigs);
        scanConfig.setServerSignatures((ServerSignature[])signatures);
        scanConfig.setScanMethodConfig(method, config);
    }

    public void add(String name) {
        ServerDetector plugin;
        try {
            plugin = this.getPlugin(name);
        }
        catch (PluginNotFoundException e) {
            this.log.debug((Object)("No detector for " + name));
            return;
        }
        ServerSignature sig = plugin.getServerSignature();
        if (plugin instanceof FileServerDetector) {
            this.fileSignatures.add(sig);
        }
        if (plugin instanceof AutoServerDetector) {
            this.autoSignatures.add(sig);
        }
        if (IS_WIN32 && plugin instanceof RegistryServerDetector) {
            this.rgySignatures.add(sig);
        }
    }

    private ConfigResponse getFileScanConfig(FileScan fileScan) {
        String key;
        ConfigOption option;
        int i;
        List options;
        ConfigResponse config = new ConfigResponse();
        Properties props = this.getAutoinventoryPluginManager().getProperties();
        try {
            options = fileScan.getConfigSchema().getOptions();
        }
        catch (AutoinventoryException e) {
            e.printStackTrace();
            return null;
        }
        for (i = 0; i < options.size(); ++i) {
            option = (ConfigOption)options.get(i);
            key = option.getName();
            String propName = "fileScan." + key;
            String value = props.getProperty(propName);
            if (value == null) continue;
            config.setValue(key, value);
        }
        if (config.getKeys().size() > 0) {
            for (i = 0; i < options.size(); ++i) {
                option = (ConfigOption)options.get(i);
                key = option.getName();
                if (config.getValue(key) != null) continue;
                config.setValue(key, option.getDefault());
            }
            return config;
        }
        return null;
    }

    private ConfigResponse getPlatformConfig() {
        int i;
        ConfigResponse config = new ConfigResponse();
        String name = this.pd.config.plugin;
        String configType = this.pd.config.type;
        if (name != null) {
            ProductPlugin plugin = this.pd.ppm.getProductPlugin(name);
            TypeInfo[] types = plugin.getTypes();
            for (i = 0; i < types.length; ++i) {
                PlatformTypeInfo type;
                if (!(types[i] instanceof PlatformTypeInfo) || !(type = (PlatformTypeInfo)types[i]).isDevice() || configType != null && !type.getName().equals(configType)) continue;
                config.setValue("platform.type", type.getName());
                this.log.debug((Object)("Set platform.type=" + type.getName()));
                String[] props = plugin.getConfigSchema(type, config).getOptionNames();
                for (int j = 0; j < props.length; ++j) {
                    String val = this.pd.getProperty(props[j]);
                    if (val == null) continue;
                    config.setValue(props[j], val);
                }
            }
        }
        Properties props = this.getAutoinventoryPluginManager().getProperties();
        String[][] platformProps = new String[][]{{"platform.type", PluginDumper.OS}, {"platform.fqdn", "localhost"}, {"platform.name", "localhost"}, {"platform.ip", "localhost"}};
        for (i = 0; i < platformProps.length; ++i) {
            String key = platformProps[i][0];
            String defval = platformProps[i][1];
            String value = props.getProperty(key, config.getValue(key, defval));
            if (value == null) continue;
            config.setValue(key, value);
        }
        this.os = config.getValue("platform.type");
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ScanConfiguration scanConfig = new ScanConfiguration();
        scanConfig.setConfigResponse(this.platformConfig);
        FileScan fileScan = new FileScan();
        ConfigResponse config = this.getFileScanConfig(fileScan);
        if (config != null) {
            this.log.debug((Object)("FileScan config=" + config));
            this.addScanners(scanConfig, fileScan, this.fileSignatures, config);
        } else {
            scanConfig.setIsDefaultScan(true);
            this.addScanners(scanConfig, new NullScan(), this.autoSignatures, config);
            this.log.debug((Object)("Adding Auto Scanners=" + this.autoSignatures));
            if (IS_WIN32) {
                this.log.debug((Object)("Adding Registry Scanners=" + this.rgySignatures));
                this.addScanners(scanConfig, new WindowsRegistryScan(), this.rgySignatures, config);
            }
        }
        this.getAutoinventoryPluginManager().endScan();
        ScanManager scanManager = this.scanManager;
        synchronized (scanManager) {
            this.scanManager.queueScan(scanConfig);
        }
        while (this.scanManager.isScanQueued() || this.scanManager.isScanRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (this.servers == null) {
            System.out.println("No servers detected");
            return;
        }
        System.out.println(this.servers.size() + " servers detected");
        String discoverServices = this.getAutoinventoryPluginManager().getProperties().getProperty("discover-services", "true");
        this.runtimeScan(discoverServices.equals("true"));
    }

    private void dumpConfig(ConfigResponse config, ConfigResponse metricConfig, ConfigResponse controlConfig, ConfigResponse cprops, String indent) {
        System.out.println(indent + "config...");
        System.out.println(indent + "product.." + config);
        System.out.println(indent + "metric..." + metricConfig);
        System.out.println(indent + "control.." + controlConfig);
        if (cprops != null) {
            System.out.println(indent + "cprops..." + cprops);
        }
    }

    private ConfigResponse decodeConfig(byte[] config) {
        if (config == null) {
            return null;
        }
        try {
            return ConfigResponse.decode((byte[])config);
        }
        catch (EncodingException e) {
            return null;
        }
    }

    private void dumpConfig(ConfigResponse config, ConfigResponse metricConfig, ConfigResponse controlConfig, ConfigResponse cprops, ConfigResponse rtConfig, String indent) {
        this.dumpConfig(config, metricConfig, controlConfig, cprops, indent);
        System.out.println(indent + "rt......." + rtConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpProperties(Properties props, String type, String name) {
        if (this.fetchMetrics) {
            TypeInfo info = this.pd.ppm.getTypeInfo(this.os, type);
            if (info == null) {
                this.log.error((Object)("No TypeInfo found for: " + type));
                return;
            }
            props.putAll((Map<?, ?>)this.pd.getProperties());
            ConfigResponse config = new ConfigResponse((Map)props);
            try {
                this.pd.fetchMetrics(info, false, config);
            }
            catch (PluginException e) {
                e.printStackTrace();
            }
            return;
        }
        PrintStream ps = null;
        String file = FileUtil.escape((String)name);
        String dir = "plugin-properties" + File.separator + TypeInfo.formatName(type);
        String plugin = (String)this.pd.productTypes.get(type);
        try {
            ps = PluginDumper.openFile(dir, file + ".properties");
            ps.println("# same as '-p \"" + plugin + "\"'");
            ps.println("dumper.plugin=" + plugin);
            ps.println("# same as '-t \"" + type + "\"'");
            ps.println("dumper.type=" + type);
            props.store(ps, name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private void dumpProperties(Properties props, ConfigResponse pConfig, ConfigResponse mConfig, ConfigResponse cConfig, String type, String name) {
        if (pConfig != null) {
            props.putAll((Map<?, ?>)pConfig.toProperties());
        }
        if (mConfig != null) {
            props.putAll((Map<?, ?>)mConfig.toProperties());
        }
        if (cConfig != null) {
            props.putAll((Map<?, ?>)cConfig.toProperties());
        }
        this.dumpProperties(props, type, name);
    }

    private String getDescription(String desc) {
        if (desc == null) {
            return "";
        }
        return " (" + desc + ")";
    }

    private void dumpService(Properties serverProps, String sName, AIServiceValue service, String indent) {
        System.out.println("\nServer:  " + sName + "\nService: " + service.getName() + " [" + service.getServiceTypeName() + "]" + this.getDescription(service.getDescription()));
        ConfigResponse config = this.decodeConfig(service.getProductConfig());
        ConfigResponse metricConfig = this.decodeConfig(service.getMeasurementConfig());
        ConfigResponse controlConfig = this.decodeConfig(service.getControlConfig());
        ConfigResponse rtConfig = this.decodeConfig(service.getResponseTimeConfig());
        ConfigResponse cprops = this.decodeConfig(service.getCustomProperties());
        this.dumpConfig(config, metricConfig, controlConfig, cprops, rtConfig, indent + "    ");
        if (this.dumpProps) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)serverProps);
            this.dumpProperties(props, config, metricConfig, controlConfig, service.getServiceTypeName(), service.getName());
        }
    }

    private ConfigResponse dumpServer(AIServerValue server, Properties serverProps, ServerDetector detector) {
        ConfigResponse config = this.decodeConfig(server.getProductConfig());
        ConfigResponse metricConfig = this.decodeConfig(server.getMeasurementConfig());
        ConfigResponse controlConfig = this.decodeConfig(server.getControlConfig());
        ConfigResponse cprops = this.decodeConfig(server.getCustomProperties());
        System.out.println("\nServer: " + server.getName() + " [" + server.getInstallPath() + "]" + this.getDescription(server.getDescription()));
        System.out.println("    AIID....." + server.getAutoinventoryIdentifier());
        this.dumpConfig(config, metricConfig, controlConfig, cprops, "    ");
        if (config == null) {
            return null;
        }
        if (this.dumpProps) {
            this.dumpProperties(serverProps, config, metricConfig, controlConfig, server.getServerTypeName(), server.getName());
        }
        if (detector == null) {
            return null;
        }
        if (metricConfig != null) {
            config.merge(metricConfig, true);
        }
        if (this.pd.config.plugin != null) {
            ProductPlugin pPlugin = this.pd.ppm.getProductPlugin(this.pd.config.plugin);
            try {
                config.merge(this.pd.getPluginConfig(pPlugin, detector.getTypeInfo()), false);
            }
            catch (PluginException e) {
                e.printStackTrace();
            }
        }
        config.setValue("installpath", server.getInstallPath());
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runtimeScan(boolean discoverServices) {
        PlatformResource platform;
        try {
            platform = Scanner.detectPlatform(this.getAutoinventoryPluginManager(), this.platformConfig);
        }
        catch (AutoinventoryException e) {
            e.printStackTrace();
            return;
        }
        String fqdn = this.platformConfig.getValue("platform.fqdn");
        if ("localhost".equals(fqdn)) {
            this.platformConfig.setValue("platform.fqdn", platform.getFqdn());
        }
        ConfigResponse platformMeasurementConfig = this.decodeConfig(platform.getMeasurementConfig());
        boolean useDelim = this.servers.size() > 1;
        for (AIServerValue server : this.servers) {
            RuntimeResourceReport report;
            ServerDetector detector;
            String typeName = server.getServerTypeName();
            String name = server.getName();
            Properties serverProps = new Properties();
            if (useDelim) {
                System.out.println("\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=");
            }
            try {
                detector = this.getPlugin(typeName);
            }
            catch (PluginNotFoundException e) {
                detector = null;
            }
            ConfigResponse config = this.dumpServer(server, serverProps, detector);
            if (!discoverServices || detector == null || !detector.isRuntimeDiscoverySupported() || config == null) continue;
            this.log.debug((Object)("Runtime discover for " + name + ", config=" + config));
            config.merge(this.platformConfig, false);
            if (platformMeasurementConfig != null) {
                config.merge(platformMeasurementConfig, false);
            }
            try {
                PluginLoader.setClassLoader((Object)detector);
                RuntimeDiscoverer discoverer = detector.getRuntimeDiscoverer();
                platform.cleanAIServerValue();
                platform.cleanAIIpValue();
                platform.removeAllAIServerValues();
                platform.removeAllAIIpValues();
                try {
                    report = discoverer.discoverResources(0, platform, config);
                }
                catch (PluginException e) {
                    String msg = detector.getName() + "-->" + (Object)((Object)e);
                    if (server.measurementConfigHasBeenSet()) {
                        this.log.error((Object)msg, (Throwable)((Object)e));
                    } else {
                        this.log.debug((Object)msg, (Throwable)((Object)e));
                    }
                    PluginLoader.resetClassLoader((Object)detector);
                    continue;
                }
            }
            catch (NoClassDefFoundError e) {
                this.log.debug((Object)(detector.getName() + "-->" + e), (Throwable)e);
                continue;
            }
            finally {
                PluginLoader.resetClassLoader((Object)detector);
                continue;
            }
            System.out.print("\nRuntime Resource Report...");
            if (report == null) {
                System.out.println("none");
                continue;
            }
            System.out.print("\n");
            AIPlatformValue[] platforms = report.getAIPlatforms();
            if (platforms == null) {
                System.out.println("No platforms discovered");
                continue;
            }
            for (int i = 0; i < platforms.length; ++i) {
                System.out.println("Platform=" + platforms[i].getPlatformTypeName() + ", fqdn=" + platforms[i].getFqdn() + this.getDescription(platforms[i].getDescription()));
                System.out.println("config...");
                System.out.println("product.." + this.decodeConfig(platforms[i].getProductConfig()));
                System.out.println("metric..." + this.decodeConfig(platforms[i].getMeasurementConfig()));
                System.out.println("control.." + this.decodeConfig(platforms[i].getControlConfig()));
                System.out.println("cprops..." + this.decodeConfig(platforms[i].getCustomProperties()));
                AIServerValue[] servers = platforms[i].getAIServerValues();
                for (int j = 0; j < servers.length; ++j) {
                    AIServiceValue[] services;
                    String sName;
                    if (!(servers[j] instanceof AIServerExtValue)) continue;
                    AIServerExtValue s = (AIServerExtValue)servers[j];
                    if (s.getName() == null) {
                        sName = server.getName();
                    } else {
                        sName = s.getName();
                        if (!server.getName().equals(sName)) {
                            this.dumpServer(s, new Properties(), null);
                        }
                    }
                    if (s.getCustomProperties() != null) {
                        System.out.println("  " + sName + " cprops: " + this.decodeConfig(s.getCustomProperties()));
                    }
                    if ((services = s.getAIServiceValues()) == null || services.length == 0) {
                        System.out.println("  [No services discovered]");
                        continue;
                    }
                    System.out.println("  " + sName + " services:");
                    HashMap<String, Boolean> serviceNames = new HashMap<String, Boolean>();
                    for (int k = 0; k < services.length; ++k) {
                        String svcName = services[k].getName();
                        if (serviceNames.get(svcName) == null) {
                            serviceNames.put(svcName, Boolean.TRUE);
                        } else {
                            String msg = "!!!ERROR!!! duplicate service name=" + svcName;
                            System.out.println(msg);
                        }
                        this.dumpService(serverProps, sName, services[k], "    ");
                    }
                }
            }
        }
    }

    private AutoinventoryPluginManager getAutoinventoryPluginManager() {
        return this.ppm.getAutoinventoryPluginManager();
    }
}

