/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.snmp;

import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession_v2c;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.UserTarget;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

class SNMPSession_v3
extends SNMPSession_v2c {
    SNMPSession_v3() {
        this.version = 3;
    }

    @Override
    protected PDU newPDU() {
        ScopedPDU pdu = new ScopedPDU();
        return pdu;
    }

    private OctetString createOctetString(String val) {
        if (val == null || val.length() == 0) {
            return null;
        }
        return new OctetString(val);
    }

    private OID getPrivProtocol(String defVal) throws SNMPException {
        String val = System.getProperty("snmpPrivacyType", defVal);
        if (val == null || val.equalsIgnoreCase("none") || val.length() == 0) {
            return null;
        }
        if (val.equals("DES")) {
            return PrivDES.ID;
        }
        if (val.equals("3DES")) {
            return Priv3DES.ID;
        }
        if (val.equals("AES128") || val.equals("AES-128") || val.equals("AES")) {
            return PrivAES128.ID;
        }
        if (val.equals("AES192") || val.equals("AES-192")) {
            return PrivAES192.ID;
        }
        if (val.equals("AES256") || val.equals("AES-256")) {
            return PrivAES256.ID;
        }
        throw new SNMPException("Privacy protocol " + val + " not supported");
    }

    private OID getAuthProtocol(String authMethod) {
        if (authMethod == null || authMethod.equalsIgnoreCase("none") || authMethod.length() == 0) {
            return null;
        }
        if (authMethod.equalsIgnoreCase("md5")) {
            return AuthMD5.ID;
        }
        if (authMethod.equalsIgnoreCase("sha")) {
            return AuthSHA.ID;
        }
        throw new IllegalArgumentException("unknown authentication protocol: " + authMethod);
    }

    void init(String host, String port, String transport, String user, String authType, String authPassword, String privType, String privPassword, String retries, String timeout) throws SNMPException {
        OID authProtocol = this.getAuthProtocol(authType);
        OID privProtocol = this.getPrivProtocol(privType);
        OctetString securityName = this.createOctetString(user);
        OctetString authPassphrase = this.createOctetString(authPassword);
        OctetString privPassphrase = this.createOctetString(privPassword);
        UserTarget target = new UserTarget();
        target.setSecurityName(securityName);
        if (authPassphrase != null) {
            if (privPassphrase != null) {
                target.setSecurityLevel(3);
            } else {
                target.setSecurityLevel(2);
            }
        } else {
            target.setSecurityLevel(1);
        }
        this.target = target;
        this.initSession(host, port, transport, retries, timeout);
        if (this.target.getAddress() == null) {
            throw new SNMPException("Invalid SNMP address " + transport + ":" + host + "/" + port);
        }
        byte[] engineID = this.session.discoverAuthoritativeEngineID(this.target.getAddress(), this.target.getTimeout());
        UsmUser usmUser = new UsmUser(securityName, authProtocol, authPassphrase, privProtocol, privPassphrase);
        USM usm = this.session.getUSM();
        usm.addUser(securityName, engineID == null ? null : new OctetString(engineID), usmUser);
    }

    @Override
    protected void validateResponsePDU(String name, PDU response) throws SNMPException {
        super.validateResponsePDU(name, response);
        if (response.getType() == -88) {
            this.processReport(response);
        }
    }

    private void processReport(PDU report) throws SNMPException {
        if (report.size() < 1) {
            throw new SNMPException("REPORT PDU does not contain a variable binding.");
        }
        VariableBinding vb = report.get(0);
        OID oid = vb.getOid();
        if (SnmpConstants.usmStatsUnsupportedSecLevels.equals((Object)oid)) {
            throw new SNMPException("Unsupported Security Level.");
        }
        if (SnmpConstants.usmStatsNotInTimeWindows.equals((Object)oid)) {
            throw new SNMPException("Message not within time window.");
        }
        if (SnmpConstants.usmStatsUnknownUserNames.equals((Object)oid)) {
            throw new SNMPException("Unknown user name.");
        }
        if (SnmpConstants.usmStatsUnknownEngineIDs.equals((Object)oid)) {
            throw new SNMPException("Unknown engine id.");
        }
        if (SnmpConstants.usmStatsWrongDigests.equals((Object)oid)) {
            throw new SNMPException("Invalid authentication digest.");
        }
        if (SnmpConstants.usmStatsDecryptionErrors.equals((Object)oid)) {
            throw new SNMPException("Decryption error.");
        }
        if (SnmpConstants.snmpUnknownSecurityModels.equals((Object)oid)) {
            throw new SNMPException("Unknown security model.");
        }
        if (SnmpConstants.snmpInvalidMsgs.equals((Object)oid)) {
            throw new SNMPException("Invalid message.");
        }
        if (SnmpConstants.snmpUnknownPDUHandlers.equals((Object)oid)) {
            throw new SNMPException("Unknown PDU handler.");
        }
        if (SnmpConstants.snmpUnavailableContexts.equals((Object)oid)) {
            throw new SNMPException("Unavailable context.");
        }
        if (SnmpConstants.snmpUnknownContexts.equals((Object)oid)) {
            throw new SNMPException("Unknown context.");
        }
        throw new SNMPException("REPORT PDU contains unknown OID (" + oid + ").");
    }

    static {
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        if ("true".equals(System.getProperty("snmpLogging"))) {
            LogFactory.setLogFactory((LogFactory)new Log4jLogFactory());
        }
    }
}

