/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentConnectionException;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentUpgradeManager;
import org.hyperic.hq.agent.FileMetadata;
import org.hyperic.hq.agent.client.AgentCommandsClient;
import org.hyperic.hq.agent.commands.AgentUpdateFiles_result;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.bizapp.client.AgentCallbackClientException;
import org.hyperic.hq.bizapp.client.AgentCommandsCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.util.JDK;
import org.hyperic.util.StringUtil;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.security.MD5;
import org.tanukisoftware.wrapper.WrapperManager;

public class AgentCommandsService
implements AgentCommandsClient {
    private static final String AGENT_BUNDLE_HOME = "agent.bundle.home";
    private static final Log LOGGER = LogFactory.getLog(AgentCommandsService.class);
    private final AgentDaemon agentDaemon;
    private final AgentConfig agentConfig;
    private AgentCommandsCallbackClient agentCommandsCallbackClient = null;

    public AgentCommandsService(AgentDaemon agent) throws AgentRunningException {
        this.agentDaemon = agent;
        this.agentConfig = this.agentDaemon.getBootConfig();
        this.agentCommandsCallbackClient = new AgentCommandsCallbackClient((ProviderFetcher)new StorageProviderFetcher(this.agentDaemon.getStorageProvider()), this.agentDaemon.getBootConfig());
    }

    public AgentUpdateFiles_result agentUpdateFiles(FileMetadata[] filesToUpdate, String[] filesToRemove, Boolean restartIfSuccessful) throws AgentRemoteException, AgentConnectionException {
        return this.agentUpdateFiles(filesToUpdate, filesToRemove, (boolean)restartIfSuccessful);
    }

    public AgentUpdateFiles_result agentUpdateFiles(FileMetadata[] filesToUpdate, String[] filesToRemove, boolean restartIfSuccessful) throws AgentRemoteException, AgentConnectionException {
        boolean filesToUpdateRequestExists = !ArrayUtils.isEmpty((Object[])filesToUpdate);
        boolean filesToRemoveRequestExists = !ArrayUtils.isEmpty((Object[])filesToRemove);
        PLUGINS_STATUS pluginsStatus = PLUGINS_STATUS.NO_PLUGINS_INCLUDED;
        AgentUpdateFiles_result result = new AgentUpdateFiles_result();
        if (!filesToUpdateRequestExists && !filesToRemoveRequestExists) {
            LOGGER.info((Object)"An empty update files request has been recieved. Ignoring.");
            return result;
        }
        LOGGER.info((Object)"Update files request has been recieved");
        if (filesToRemoveRequestExists) {
            try {
                pluginsStatus = this.markFilesToRemoveIfNeeded(filesToRemove, result, pluginsStatus);
            }
            catch (Exception e) {
                result.setValue("FilesToRemove", "failed");
                LOGGER.error((Object)"Quitting as removing files has failed.", (Throwable)e);
                return result;
            }
        } else {
            LOGGER.info((Object)"No files to remove.");
        }
        if (filesToUpdateRequestExists) {
            try {
                pluginsStatus = this.updateFilesIfNeeded(filesToUpdate, result, pluginsStatus);
            }
            catch (Exception e) {
                result.setValue("FilesToUpdate", "failed");
                LOGGER.error((Object)"Quitting as updating files has failed.", (Throwable)e);
                return result;
            }
        } else {
            LOGGER.info((Object)"No files to update.");
        }
        if (restartIfSuccessful) {
            LOGGER.info((Object)"Update requires agent restart, restarting agent...");
            this.restart();
        } else if (pluginsStatus == PLUGINS_STATUS.PLUGINS_DIFFER_FROM_SERVER) {
            LOGGER.info((Object)"Update requires restarting the plugin managers, restarting them ...");
            this.applyPluginsChanges();
        } else if (pluginsStatus == PLUGINS_STATUS.PLUGINS_ALREADY_IN_SYNC) {
            LOGGER.info((Object)"Plugins from this request already exist on disk. Informing the server.");
            this.agentDaemon.sendPluginStatusToServer(false);
        }
        return result;
    }

    private FileMetadata[] filterFilesToUpdate(FileMetadata[] files) throws AgentCallbackClientException {
        List disabledPlugins = this.agentCommandsCallbackClient.getDisabledPlugins();
        ArrayList<FileMetadata> filteredPlugins = new ArrayList<FileMetadata>();
        for (FileMetadata fileMetaData : files) {
            boolean isDisabled = false;
            for (String disabledPlugin : disabledPlugins) {
                if (!fileMetaData.getDestFileRelativePath().contains(disabledPlugin)) continue;
                isDisabled = true;
                break;
            }
            if (isDisabled) continue;
            filteredPlugins.add(fileMetaData);
        }
        FileMetadata[] filteredArray = new FileMetadata[filteredPlugins.size()];
        filteredPlugins.toArray(filteredArray);
        return filteredArray;
    }

    private PLUGINS_STATUS updateFilesIfNeeded(FileMetadata[] filesToUpdate, AgentUpdateFiles_result result, PLUGINS_STATUS pluginsStatus) throws AgentRemoteException, AgentCallbackClientException {
        if (null == filesToUpdate || null == result) {
            return pluginsStatus;
        }
        FileMetadata[] filteredFiles = this.filterFilesToUpdate(filesToUpdate);
        if (filteredFiles.length == 0) {
            return PLUGINS_STATUS.PLUGINS_ALREADY_IN_SYNC;
        }
        ArrayList<FileMetadata> fileMetaDataList = new ArrayList<FileMetadata>(filesToUpdate.length);
        for (FileMetadata fileMetaData : filteredFiles) {
            String sourceFileUri = fileMetaData.getSourceFileUri();
            String md5CheckSum = fileMetaData.getMD5CheckSum();
            String destFileRelativePath = fileMetaData.getDestFileRelativePath();
            if (StringUtil.isNullOrEmpty((String)destFileRelativePath) || StringUtil.isNullOrEmpty((String)sourceFileUri) || StringUtil.isNullOrEmpty((String)md5CheckSum)) continue;
            String resolvedFilePath = this.resolveAgentBundleHomePath(destFileRelativePath);
            boolean isPlugin = this.isPluginFile(destFileRelativePath);
            if (isPlugin && pluginsStatus == PLUGINS_STATUS.NO_PLUGINS_INCLUDED) {
                pluginsStatus = PLUGINS_STATUS.PLUGINS_ALREADY_IN_SYNC;
            }
            if (this.shouldDownloadFileByMd5(resolvedFilePath, md5CheckSum)) {
                if (isPlugin) {
                    pluginsStatus = PLUGINS_STATUS.PLUGINS_DIFFER_FROM_SERVER;
                }
                resolvedFilePath = this.convertPdkDirToTmpDirIn(this.injectUpdatePluginSuffix(resolvedFilePath));
                LOGGER.info((Object)String.format("About to download file: %s, checksum = %s, into: %s", sourceFileUri, md5CheckSum, resolvedFilePath));
                FileMetadata resolvedFileMetaData = new FileMetadata(fileMetaData.getSourceFileUri(), resolvedFilePath, fileMetaData.getMD5CheckSum());
                fileMetaDataList.add(resolvedFileMetaData);
                continue;
            }
            LOGGER.info((Object)String.format("Skipping file download from: %s, file already exists locally.", sourceFileUri));
            result.setValue("FilesToUpdate-" + fileMetaData.getMD5CheckSum(), "true");
        }
        result.merge(this.agentCommandsCallbackClient.downloadFilesFromCurrentProvider(fileMetaDataList));
        return pluginsStatus;
    }

    private PLUGINS_STATUS markFilesToRemoveIfNeeded(String[] filesToRemove, AgentUpdateFiles_result result, PLUGINS_STATUS pluginsStatus) throws Exception {
        if (null == filesToRemove || null == result) {
            return pluginsStatus;
        }
        LinkedList<String> filesToRemoveWithCorrectedPath = new LinkedList<String>();
        for (String fileToRemove : filesToRemove) {
            if (StringUtil.isNullOrEmpty((String)fileToRemove)) continue;
            String resolvedFilePath = this.resolveAgentBundleHomePath(fileToRemove);
            boolean isPlugin = this.isPluginFile(resolvedFilePath);
            if (isPlugin && pluginsStatus == PLUGINS_STATUS.NO_PLUGINS_INCLUDED) {
                pluginsStatus = PLUGINS_STATUS.PLUGINS_ALREADY_IN_SYNC;
            }
            if (!new File(resolvedFilePath).exists()) {
                LOGGER.info((Object)String.format("Skipping remove request for %s, as it doesn't exist on local disk", resolvedFilePath));
                result.setValue("FilesToRemove-" + fileToRemove, "true");
                continue;
            }
            if (isPlugin) {
                pluginsStatus = PLUGINS_STATUS.PLUGINS_DIFFER_FROM_SERVER;
            }
            filesToRemoveWithCorrectedPath.add(this.convertPdkDirToTmpDirIn(this.injectRemovePluginSuffix(resolvedFilePath)));
        }
        Map<String, Boolean> filesRegisteredToRemove = this.agentRemoveFiles(filesToRemoveWithCorrectedPath);
        LOGGER.info((Object)String.format("%d files have been set to be removed", filesToRemoveWithCorrectedPath.size()));
        for (String key : filesRegisteredToRemove.keySet()) {
            result.setValue("FilesToRemove-" + key, filesRegisteredToRemove.get(key).toString());
        }
        return pluginsStatus;
    }

    private boolean isPluginFile(String fileName) {
        return ProductPluginManager.isValidPluginName((String)fileName);
    }

    private boolean isValidJavaVersionToApplyPluginsChanges() {
        return ProductPluginManager.isValidJavaVersionToApplyPluginsChanges();
    }

    private void applyPluginsChanges() throws AgentConnectionException, AgentRemoteException {
        if (!this.isValidJavaVersionToApplyPluginsChanges()) {
            LOGGER.debug((Object)"Invalid java version for calling applyPluginsChanges...");
            LOGGER.info((Object)"Update requires agent restart, restarting agent...");
            this.restart();
        }
        try {
            this.agentDaemon.applyPluginsChanges();
        }
        catch (IOException ioe) {
            throw new AgentConnectionException("IO Exception", (Exception)ioe);
        }
        catch (AgentStartException ase) {
            throw new AgentConnectionException("Agent Start Exception", (Exception)((Object)ase));
        }
        catch (PluginException pe) {
            throw new AgentRemoteException("Plugin Exception", (Exception)((Object)pe));
        }
    }

    private boolean shouldDownloadFileByMd5(String destFileRelativePath, String expectedMd5) {
        File destFile = new File(destFileRelativePath);
        if (!destFile.exists()) {
            return true;
        }
        String existingMd5 = MD5.getMD5Checksum((File)destFile);
        return !existingMd5.equals(expectedMd5);
    }

    public void die() throws AgentRemoteException {
        try {
            this.agentDaemon.die();
        }
        catch (AgentRunningException exc) {
            LOGGER.error((Object)"Killing a running agent!");
        }
    }

    public long ping() throws AgentRemoteException {
        return 0L;
    }

    public void restart() throws AgentRemoteException {
        AgentUpgradeManager.restartJVM();
    }

    private void restartKeepNextSyncScanTime() throws AgentRemoteException {
        try {
            this.agentDaemon.getSyncModeManager().storeNextSyncScanTime();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"failed to storeNextSyncScanTime.", (Throwable)ex);
        }
        this.agentDaemon.restartGracefully();
    }

    public String getCurrentAgentBundle() throws AgentRemoteException {
        return this.agentDaemon.getCurrentAgentBundle();
    }

    private void setExecuteBit(File file) throws AgentRemoteException {
        int rc;
        int timeout = 60000;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecuteWatchdog watch = new ExecuteWatchdog(timeout);
        Execute exec = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)output), watch);
        try {
            String[] arguments = new String[]{"chmod", "+x", file.getCanonicalPath()};
            exec.setCommandline(arguments);
            LOGGER.info((Object)("Running " + exec.getCommandLineString()));
            rc = exec.execute();
        }
        catch (Exception e) {
            rc = -1;
            LOGGER.error((Object)e);
        }
        if (rc != 0) {
            String msg = output.toString().trim();
            if (msg.length() == 0) {
                msg = "timeout after " + timeout + "ms";
            }
            throw new AgentRemoteException("Failed to set permissions: [" + exec.getCommandLineString() + "] " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map upgrade(String bundle, String destination) throws AgentRemoteException {
        bundle = this.resolveAgentBundleHomePath(bundle);
        destination = this.resolveAgentBundleHomePath(destination);
        File bundleFile = new File(bundle);
        File workDir = new File(destination, "work");
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            File bundleDir;
            String bundleHome;
            block38: {
                LOGGER.info((Object)("Preparing to upgrade agent bundle from file " + bundle + " at destination " + destination));
                if (!WrapperManager.isControlledByNativeWrapper()) {
                    throw new AgentRemoteException("Upgrade command is not supported without the Java Service Wrapper.");
                }
                if (!bundleFile.isFile()) {
                    throw new AgentRemoteException("Upgrade agent bundle " + bundle + " is not a valid file");
                }
                bundleHome = this.getBundleHome(bundleFile);
                FileUtil.deleteDir((File)workDir);
                try {
                    FileUtil.decompress((File)bundleFile, (File)workDir);
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Failed to decompress " + bundle + " at destination " + workDir), (Throwable)e);
                    throw new AgentRemoteException("Failed to decompress " + bundle + " at destination " + workDir);
                }
                bundleDir = new File(destination, bundleHome);
                File extractedBundleDir = new File(workDir, bundleHome);
                if (!extractedBundleDir.isDirectory()) {
                    throw new AgentRemoteException("Invalid agent bundle file detected; missing top-level " + bundleDir + " directory");
                }
                if (bundleDir.exists()) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                    bundleHome = bundleHome + "-" + dateFormat.format(new Date(System.currentTimeMillis()));
                    bundleDir = new File(destination, bundleHome);
                }
                if (!extractedBundleDir.renameTo(bundleDir)) {
                    throw new AgentRemoteException("Failed to copy agent bundle from " + extractedBundleDir + " to " + bundleDir);
                }
                if (!JDK.IS_WIN32) {
                    File[] scripts;
                    File pdkscriptsdir;
                    File[] libs;
                    File pdkdir = new File(bundleDir, "pdk");
                    File pdklibdir = new File(pdkdir, "lib");
                    File jredir = new File(pdkdir, "jre");
                    if (!pdklibdir.exists()) {
                        throw new AgentRemoteException("Invalid PDK library directory " + pdklibdir.getAbsolutePath());
                    }
                    for (File lib : libs = pdklibdir.listFiles()) {
                        if (!lib.getName().endsWith("sl")) continue;
                        this.setExecuteBit(lib);
                    }
                    if (jredir.exists()) {
                        File[] bins;
                        File jrebin = new File(jredir, "bin");
                        File[] arr$ = bins = jrebin.listFiles();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            File bin = arr$[i$];
                            this.setExecuteBit(bin);
                        }
                    }
                    if (!(pdkscriptsdir = new File(pdkdir, "scripts")).exists()) {
                        throw new AgentRemoteException("Invalid PDK scripts directory " + pdklibdir.getAbsolutePath());
                    }
                    for (File script : scripts = pdkscriptsdir.listFiles()) {
                        this.setExecuteBit(script);
                    }
                }
                boolean success = false;
                try {
                    success = AgentUpgradeManager.upgrade((String)bundleHome);
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Failed to write new bundle home " + bundleHome + " into rollback properties"), (Throwable)e);
                }
                finally {
                    if (success) break block38;
                    throw new AgentRemoteException("Failed to write new bundle home " + bundleHome + " into rollback properties");
                }
            }
            LOGGER.info((Object)"Successfully upgraded to new agent bundle");
            FileInputStream versionInputStream = null;
            try {
                LOGGER.debug((Object)"Creating result map");
                File versionFile = new File(bundleDir, "lib/hq-version.properties");
                versionInputStream = new FileInputStream(versionFile);
                Properties newVersionProperties = new Properties();
                newVersionProperties.load(versionInputStream);
                String version = newVersionProperties.getProperty("version");
                LOGGER.debug((Object)("VERSION: " + version));
                LOGGER.debug((Object)("BUNDLE_NAME: " + bundleHome));
                result.put("version", version);
                result.put("bundleName", bundleHome);
            }
            catch (MalformedURLException e) {
                LOGGER.warn((Object)"Could not access new hq-version.properties due to a malformed url, version value will not be updated in the database.", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Could not read new hq-version.properties file, version value will not be updated in the database.", (Throwable)e);
            }
            finally {
                if (versionInputStream != null) {
                    try {
                        versionInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        finally {
            this.doUpgradeCleanup(bundleFile, workDir);
        }
        return result;
    }

    private void doUpgradeCleanup(File bundleFile, File workDir) {
        bundleFile.delete();
        FileUtil.deleteDir((File)workDir);
    }

    private String getBundleHome(File bundleFile) throws AgentRemoteException {
        int index;
        String fileName = bundleFile.getName();
        if (fileName.endsWith(".tar.gz")) {
            index = fileName.lastIndexOf(".tar.gz");
        } else if (fileName.endsWith(".tgz")) {
            index = fileName.lastIndexOf(".tgz");
        } else if (fileName.endsWith(".zip")) {
            index = fileName.lastIndexOf(".zip");
        } else {
            throw new AgentRemoteException("Invalid file format for the agent bundle tar file (.zip, .tar.gz or .tgz expected)");
        }
        return fileName.substring(0, index);
    }

    private Map<String, Boolean> agentRemoveFiles(Collection<String> files) throws Exception {
        HashMap<String, Boolean> rtn = new HashMap<String, Boolean>();
        boolean debug = LOGGER.isDebugEnabled();
        for (String filename : files) {
            if (filename == null) continue;
            try {
                File file = new File(this.resolveAgentBundleHomePath(filename));
                file.createNewFile();
                if (debug) {
                    LOGGER.debug((Object)("Preparing file for removal:" + file.getAbsolutePath()));
                }
                rtn.put(filename, file.exists());
            }
            catch (Exception e) {
                LOGGER.error((Object)("Quitting. Could not prepare file for removal - " + filename + ": " + e));
                throw e;
            }
        }
        return rtn;
    }

    private String resolveAgentBundleHomePath(String path) throws AgentRemoteException {
        String agentBundleHome = System.getProperty(AGENT_BUNDLE_HOME);
        if (agentBundleHome == null) {
            throw new AgentRemoteException("Could not resolve system property agent.bundle.home");
        }
        String resolvedFilePath = StringUtil.replace((String)path, (String)"${agent.bundle.home}", (String)agentBundleHome);
        if (!path.equals(resolvedFilePath)) {
            LOGGER.debug((Object)String.format("Converted bundle home path from %s to %s", path, resolvedFilePath));
        }
        return resolvedFilePath;
    }

    private String convertPdkDirToTmpDirIn(String path) throws AgentRemoteException {
        Properties bootProps = this.agentConfig.getBootProperties();
        String tmpDir = bootProps.getProperty(AgentConfig.PROP_TMPDIR[0]);
        String pluginsDir = bootProps.getProperty(AgentConfig.PROP_PDK_PLUGIN_DIR[0]);
        if (StringUtil.isNullOrEmpty((String)tmpDir) || StringUtil.isNullOrEmpty((String)pluginsDir)) {
            throw new AgentRemoteException("Could not resolve one of the following system properties, or both:" + AgentConfig.PROP_TMPDIR[0] + "," + AgentConfig.PROP_PDK_PLUGIN_DIR[0]);
        }
        String resolvedFilePath = StringUtil.replace((String)path, (String)pluginsDir, (String)tmpDir);
        if (!path.equals(resolvedFilePath)) {
            LOGGER.debug((Object)String.format("Converted pdk dir path from %s to %s", path, resolvedFilePath));
        }
        return resolvedFilePath;
    }

    private String injectRemovePluginSuffix(String path) {
        return this.injectSuffixIfPluginFilePath(path, "-remove");
    }

    private String injectUpdatePluginSuffix(String path) {
        return this.injectSuffixIfPluginFilePath(path, "-update");
    }

    private String injectSuffixIfPluginFilePath(String path, String suffix) {
        if (this.isPluginFile(path)) {
            return new StringBuilder(path).insert(path.length() - 4, suffix).toString();
        }
        return path;
    }

    private static enum PLUGINS_STATUS {
        NO_PLUGINS_INCLUDED,
        PLUGINS_DIFFER_FROM_SERVER,
        PLUGINS_ALREADY_IN_SYNC;

    }
}

