/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.lather.xcode;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SafeLatherObjectInputStream
extends ObjectInputStream {
    private static Logger logger = Logger.getLogger(SafeLatherObjectInputStream.class);
    private static final TreeMap<String, Class<?>> safeClasses = new TreeMap();
    private static final String[] safeClassList = new String[]{"java.lang.Boolean", "java.util.ArrayList", "java.util.HashMap", "[Ljava.lang.Class;", "[Ljava.lang.Object;", "[Ljava.lang.String;", "[Lorg.hyperic.hq.agent.FileMetadata;", "org.hyperic.hq.agent.AgentRemoteValue", "org.hyperic.hq.agent.client.AgentCommandsClient", "org.hyperic.hq.agent.FileMetadata", "org.hyperic.hq.common.InvocationRequest", "org.hyperic.hq.common.InvocationResponse", "org.hyperic.hq.configuration.agent.client.ConfigurationCommandsClient", "org.hyperic.hq.configuration.agent.commands.Configuration_args", "org.hyperic.hq.configuration.agent.commands.Configuration_result", "org.hyperic.hq.agent.commands.AgentUpdateFiles_result", "org.hyperic.hq.agent.commands.AgentBundle_args", "org.hyperic.hq.agent.commands.AgentBundle_result", "org.hyperic.hq.agent.commands.AgentDie_args", "org.hyperic.hq.agent.commands.AgentDie_result", "org.hyperic.hq.agent.commands.AgentPing_args", "org.hyperic.hq.agent.commands.AgentPing_result", "org.hyperic.hq.agent.commands.AgentRemoveFileData_args", "org.hyperic.hq.agent.commands.AgentRestart_args", "org.hyperic.hq.agent.commands.AgentRestart_result", "org.hyperic.hq.agent.commands.AgentUpdateFiles_args", "org.hyperic.hq.agent.commands.AgentUpdateFiles_result", "org.hyperic.hq.agent.commands.AgentUpgrade_args", "org.hyperic.hq.agent.commands.AgentUpgrade_result", "org.hyperic.hq.agent.commands.DeleteProperties_args", "org.hyperic.hq.agent.commands.DeleteProperties_result", "org.hyperic.hq.agent.commands.FileRemoval_result", "org.hyperic.hq.agent.commands.SetProperties_args", "org.hyperic.hq.agent.commands.SetProperties_result", "org.hyperic.hq.agent.AgentAssertionException", "org.hyperic.hq.agent.AgentException", "org.hyperic.hq.agent.AgentConnectionException", "org.hyperic.hq.agent.AgentRemoteException", "org.hyperic.lather.LatherRemoteException", "org.hyperic.bizapp.shared.lather.AgentInfo_args", "org.hyperic.bizapp.shared.lather.AiIpLatherValue", "org.hyperic.bizapp.shared.lather.AiLatherValue", "org.hyperic.bizapp.shared.lather.AiPlatformLatherValue", "org.hyperic.bizapp.shared.lather.AiSendReport_args", "org.hyperic.bizapp.shared.lather.AiSendRuntimeReport_args", "org.hyperic.bizapp.shared.lather.AiServerLatherValue", "org.hyperic.bizapp.shared.lather.AiServiceLatherValue", "org.hyperic.bizapp.shared.lather.AiServiceTypeLatherValue", "org.hyperic.bizapp.shared.lather.CommandInfo", "org.hyperic.bizapp.shared.lather.CompositeRuntimeResourceReportLatherValue", "org.hyperic.bizapp.shared.lather.ControlGetPluginConfig_args", "org.hyperic.bizapp.shared.lather.ControlGetPluginConfig_result", "org.hyperic.bizapp.shared.lather.ControlSendCommandResult_args", "org.hyperic.bizapp.shared.lather.GetAgentCommands_args", "org.hyperic.bizapp.shared.lather.GetAgentCommands_result", "org.hyperic.bizapp.shared.lather.GetDisabledPlugins_args", "org.hyperic.bizapp.shared.lather.GetDisabledPlugins_result", "org.hyperic.bizapp.shared.lather.MeasurementGetConfigs_args", "org.hyperic.bizapp.shared.lather.MeasurementGetConfigs_result", "org.hyperic.bizapp.shared.lather.MeasurementSendReport_args", "org.hyperic.bizapp.shared.lather.MeasurementSendReport_result", "org.hyperic.bizapp.shared.lather.PluginReport_args", "org.hyperic.bizapp.shared.lather.RegisterAgent_args", "org.hyperic.bizapp.shared.lather.RegisterAgent_result", "org.hyperic.bizapp.shared.lather.RuntimeResourceReportLatherValue", "org.hyperic.bizapp.shared.lather.ScanConfigurationCoreValue", "org.hyperic.bizapp.shared.lather.ScanMethodConfigValue", "org.hyperic.bizapp.shared.lather.ScanMethodStateLatherValue", "org.hyperic.bizapp.shared.lather.ScanStateCoreLatherValue", "org.hyperic.bizapp.shared.lather.SendAgentResponses_args", "org.hyperic.bizapp.shared.lather.SendAgentResponses_result", "org.hyperic.bizapp.shared.lather.ServerInfo_result", "org.hyperic.bizapp.shared.lather.ServerSignatureValue", "org.hyperic.bizapp.shared.lather.StringifiedExceptionLatherValue", "org.hyperic.bizapp.shared.lather.TopNSendReport_args", "org.hyperic.bizapp.shared.lather.TrackSend_args"};

    public SafeLatherObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        Class<?> cl = safeClasses.get(name);
        if (cl != null) {
            return cl;
        }
        logger.debug((Object)("The class '" + name + "' is not in safelist"));
        throw new ClassNotFoundException("Suspicious de-serialization attempt of  non safe class " + name);
    }

    static {
        try {
            safeClasses.put("boolean", Boolean.TYPE);
            safeClasses.put("byte", Byte.TYPE);
            safeClasses.put("char", Character.TYPE);
            safeClasses.put("short", Character.TYPE);
            safeClasses.put("int", Integer.TYPE);
            safeClasses.put("long", Long.TYPE);
            safeClasses.put("float", Float.TYPE);
            safeClasses.put("double", Double.TYPE);
            safeClasses.put("void", Void.TYPE);
            safeClasses.put("java.lang.String", String.class);
            for (String safeClass : safeClassList) {
                safeClasses.put(safeClass, Class.forName(safeClass));
            }
        }
        catch (ClassNotFoundException cnfe) {
            logger.debug((Object)"Unable to Load class", (Throwable)cnfe);
        }
    }
}

