/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.db;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.db.FreeList;
import org.hyperic.hq.agent.stats.AgentStatsCollector;

public class DiskList {
    private static final int IDX_REC_LEN = 17;
    private static final Log log = LogFactory.getLog((String)DiskList.class.getName());
    private final String fileName;
    private final String idxFileName;
    private final RandomAccessFile indexFile;
    protected RandomAccessFile dataFile;
    private int recordSize;
    private long firstRec;
    private long lastRec;
    private final byte[] padBytes;
    protected FreeList freeList;
    private int modNum;
    private final long checkSize;
    private final int checkPerc;
    private final long maxLength;
    private final SecureRandom rand;
    private boolean closed;
    private static final AgentStatsCollector statsCollector = AgentStatsCollector.getInstance();
    private static final String DISK_LIST_DISK_ITERATOR_REMOVE_TIME = "DISK_LIST_DISK_ITERATOR_REMOVE_TIME";
    private static final String DISK_LIST_READ_RECORD_TIME = "DISK_LIST_READ_RECORD_TIME";
    private static final String DISK_LIST_ADD_TO_LIST_TIME = "DISK_LIST_ADD_TO_LIST_TIME";
    private static final String DISK_LIST_DELETE_ALL_RECORDS_TIME = "DISK_LIST_DELETE_ALL_RECORDS_TIME";

    public DiskList(File dataFile, int recordSize, long checkSize, int checkPerc) throws IOException {
        this(dataFile, recordSize, checkSize, checkPerc, Long.MAX_VALUE);
    }

    public DiskList(File dataFile, int recordSize, long checkSize, int checkPerc, long maxLength) throws IOException {
        File idxFile = new File(dataFile + ".idx");
        this.fileName = dataFile.getName();
        this.idxFileName = idxFile.getName();
        this.rand = new SecureRandom();
        this.dataFile = new RandomAccessFile(dataFile, "rw");
        this.recordSize = recordSize;
        this.padBytes = new byte[Math.max(recordSize, 17)];
        this.modNum = this.rand.nextInt();
        this.checkSize = checkSize;
        this.checkPerc = checkPerc;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting max length for " + this.fileName + " to " + maxLength + " bytes"));
        }
        this.maxLength = maxLength;
        this.indexFile = new RandomAccessFile(idxFile, "rw");
        this.genFreeList(idxFile);
        this.closed = false;
    }

    private long getDataFileFreePercentage() throws IOException {
        double dataBytes = this.dataFile.length();
        double freeBytes = this.freeList.cardinality() * this.recordSize;
        return Math.round(freeBytes * 100.0 / dataBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMaintenence() throws IOException {
        int lastFree;
        long lastData = this.dataFile.length() / (long)this.recordSize;
        if (lastData != (long)((lastFree = this.freeList.getLast()) + 1)) {
            return;
        }
        int firstFree = this.freeList.startingIndexOfLastFreeRange();
        RandomAccessFile randomAccessFile = this.dataFile;
        synchronized (randomAccessFile) {
            this.dataFile.setLength(firstFree * this.recordSize);
            this.indexFile.setLength(firstFree * 17);
            this.freeList.clear(firstFree, lastFree);
        }
        long num = lastFree - firstFree + 1;
        log.info((Object)String.format("Deleted %d bytes from %s (%d blocks)", num * (long)this.recordSize, this.fileName, num));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void genFreeList(File idxFile) throws IOException {
        FileInputStream fIs = null;
        this.firstRec = -1L;
        this.lastRec = -1L;
        this.freeList = new FreeList();
        RandomAccessFile randomAccessFile = this.dataFile;
        synchronized (randomAccessFile) {
            block23: {
                fIs = new FileInputStream(idxFile);
                BufferedInputStream bIs = new BufferedInputStream(fIs);
                DataInputStream dIs = new DataInputStream(bIs);
                long idx = 0L;
                while (true) {
                    boolean used;
                    try {
                        used = dIs.readBoolean();
                    }
                    catch (EOFException exc) {
                        break;
                    }
                    long prev = dIs.readLong();
                    long next = dIs.readLong();
                    if (!used) {
                        this.freeList.set((int)idx);
                    } else {
                        if (prev == -1L) {
                            this.firstRec = idx;
                        }
                        if (next == -1L) {
                            this.lastRec = idx;
                        }
                    }
                    ++idx;
                }
                try {
                    if (fIs != null) {
                        fIs.close();
                    }
                    break block23;
                }
                catch (IOException exc) {}
                break block23;
                catch (FileNotFoundException exc) {
                    try {
                        if (fIs != null) {
                            fIs.close();
                        }
                    }
                    catch (IOException exc2) {
                        // empty catch block
                    }
                    return;
                    catch (Throwable throwable) {
                        try {
                            if (fIs != null) {
                                fIs.close();
                            }
                        }
                        catch (IOException exc3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToList(String data) throws IOException {
        if (this.closed) {
            throw new IOException("Datafile already closed");
        }
        ByteArrayOutputStream bOs = new ByteArrayOutputStream(this.recordSize);
        DataOutputStream dOs = new DataOutputStream(bOs);
        dOs.writeUTF(data);
        if (bOs.size() > this.recordSize) {
            throw new IOException("Data length(" + bOs.size() + ") exceeds " + "maximum record length(" + this.recordSize + ")");
        }
        long start = DiskList.now();
        bOs.write(this.padBytes, 0, this.recordSize - bOs.size());
        byte[] bytes = bOs.toByteArray();
        RandomAccessFile randomAccessFile = this.dataFile;
        synchronized (randomAccessFile) {
            this.modNum = this.rand.nextInt();
            long firstFree = this.freeList.getFirst();
            if (firstFree < 0L) {
                firstFree = this.indexFile.length() / 17L;
            } else {
                this.freeList.clear((int)firstFree);
            }
            this.dataFile.seek(firstFree * (long)this.recordSize);
            this.dataFile.write(bytes);
            bOs.reset();
            dOs.writeBoolean(true);
            dOs.writeLong(this.lastRec);
            dOs.writeLong(-1L);
            this.indexFile.seek(firstFree * 17L);
            bytes = bOs.toByteArray();
            this.indexFile.write(bytes, 0, bytes.length);
            if (this.lastRec != -1L) {
                this.indexFile.seek(this.lastRec * 17L + 1L + 8L);
                this.indexFile.writeLong(firstFree);
            }
            this.lastRec = firstFree;
            if (this.firstRec == -1L) {
                this.firstRec = firstFree;
            }
        }
        if (this.dataFile.length() > this.maxLength) {
            log.error((Object)("Maximum file size for data file: " + this.fileName + " reached (" + this.maxLength + " bytes), truncating."));
            this.deleteAllRecords();
        }
        long duration = DiskList.now() - start;
        statsCollector.addStat(duration, DISK_LIST_ADD_TO_LIST_TIME);
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Record readRecord(long recNo) throws IOException {
        Record res = new Record();
        if (recNo < 0L) {
            throw new IllegalArgumentException("IDX must be positive");
        }
        long start = DiskList.now();
        RandomAccessFile randomAccessFile = this.dataFile;
        synchronized (randomAccessFile) {
            this.dataFile.seek(recNo * (long)this.recordSize);
            res.data = this.dataFile.readUTF();
            this.indexFile.seek(recNo * 17L);
            res.isUsed = this.indexFile.readBoolean();
            res.prevIdx = this.indexFile.readLong();
            res.nextIdx = this.indexFile.readLong();
        }
        long duration = DiskList.now() - start;
        statsCollector.addStat(duration, DISK_LIST_READ_RECORD_TIME);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllRecords() throws IOException {
        IOException sExc = null;
        if (this.closed) {
            throw new IOException("Datafile already closed");
        }
        long start = DiskList.now();
        RandomAccessFile randomAccessFile = this.dataFile;
        synchronized (randomAccessFile) {
            block11: {
                this.modNum = this.rand.nextInt();
                this.firstRec = -1L;
                this.lastRec = -1L;
                try {
                    this.indexFile.setLength(0L);
                }
                catch (IOException exc) {
                    log.error((Object)("IOException while truncating index file: " + this.idxFileName));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("IOException while truncating index file: " + this.idxFileName), (Throwable)exc);
                    }
                    sExc = exc;
                }
                try {
                    this.dataFile.setLength(0L);
                }
                catch (IOException exc) {
                    log.error((Object)("IOException while truncating data file: " + this.fileName));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("IOException while truncating data file: " + this.fileName), (Throwable)exc);
                    }
                    if (sExc == null) break block11;
                    sExc = exc;
                }
            }
            this.freeList.clear();
        }
        long duration = DiskList.now() - start;
        statsCollector.addStat(duration, DISK_LIST_DELETE_ALL_RECORDS_TIME);
        if (sExc != null) {
            throw sExc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecord(long recNo) throws IOException {
        if (recNo < 0L) {
            throw new IllegalArgumentException("IDX must be positive");
        }
        RandomAccessFile randomAccessFile = this.dataFile;
        synchronized (randomAccessFile) {
            this.modNum = this.rand.nextInt();
            if (recNo == this.firstRec) {
                if (recNo == this.lastRec) {
                    this.firstRec = -1L;
                    this.lastRec = -1L;
                } else {
                    this.indexFile.seek(recNo * 17L + 1L + 8L);
                    long nextIdx = this.indexFile.readLong();
                    this.indexFile.seek(nextIdx * 17L + 1L);
                    this.indexFile.writeLong(-1L);
                    this.firstRec = nextIdx;
                }
            } else if (recNo == this.lastRec) {
                this.indexFile.seek(recNo * 17L + 1L);
                long prevIdx = this.indexFile.readLong();
                this.indexFile.seek(prevIdx * 17L + 1L + 8L);
                this.indexFile.writeLong(-1L);
                this.lastRec = prevIdx;
            } else {
                this.indexFile.seek(recNo * 17L + 1L);
                long prevIdx = this.indexFile.readLong();
                long nextIdx = this.indexFile.readLong();
                this.indexFile.seek(prevIdx * 17L + 1L + 8L);
                this.indexFile.writeLong(nextIdx);
                this.indexFile.seek(nextIdx * 17L + 1L);
                this.indexFile.writeLong(prevIdx);
            }
            this.indexFile.seek(recNo * 17L);
            this.indexFile.writeBoolean(false);
            this.freeList.set((int)recNo);
        }
        long length = this.dataFile.length();
        long percFree = this.getDataFileFreePercentage();
        if (length > this.checkSize && percFree > (long)this.checkPerc) {
            this.doMaintenence();
        }
    }

    public void close() throws IOException {
        IOException sExc;
        block8: {
            sExc = null;
            if (this.closed) {
                throw new IOException("Datafile already closed");
            }
            this.closed = true;
            try {
                this.dataFile.close();
            }
            catch (IOException exc) {
                log.error((Object)("IOException while closing data file: " + this.fileName));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IOException while closing data file: " + this.fileName), (Throwable)exc);
                }
                sExc = exc;
            }
            try {
                this.indexFile.close();
            }
            catch (IOException exc) {
                log.error((Object)("IOException while closing index file: " + this.idxFileName));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IOException while closing index file: " + this.idxFileName), (Throwable)exc);
                }
                if (sExc != null) break block8;
                sExc = exc;
            }
        }
        if (sExc != null) {
            throw sExc;
        }
    }

    public void convertListToCurrentRecordSize(int oldSize) throws IOException {
        log.info((Object)("Converting list on file '" + this.fileName + "' from size " + oldSize + " to size " + this.recordSize));
        int realRecSize = this.recordSize;
        this.recordSize = oldSize;
        ArrayList<String> records = new ArrayList<String>();
        Iterator<String> iter = this.getListIterator();
        while (iter != null && iter.hasNext()) {
            String data = iter.next();
            records.add(data);
        }
        log.info((Object)("Read " + records.size() + " records from file '" + this.fileName + "'"));
        this.deleteAllRecords();
        this.recordSize = realRecSize;
        for (String rec : records) {
            this.addToList(rec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getListIterator() {
        RandomAccessFile randomAccessFile = this.dataFile;
        synchronized (randomAccessFile) {
            if (this.firstRec == -1L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getListIterator() - list '" + this.fileName + "' has no elements"));
                }
                return null;
            }
            return new DiskListIterator(this, this.firstRec, this.modNum);
        }
    }

    public static void main(String[] args) throws Exception {
        String val;
        long count;
        long NUM = 131072L;
        System.out.println("Creating DiskList..");
        DiskList d = new DiskList(new File("mydb"), 1024, 0x200000L, 10);
        System.out.println("Adding " + NUM + " records..");
        int i = 0;
        while ((long)i < NUM) {
            d.addToList("one " + i);
            ++i;
        }
        System.out.println("Removing " + NUM / 2L + " records..");
        Iterator<String> i2 = d.getListIterator();
        for (count = NUM / 2L; i2.hasNext() && count > 0L; --count) {
            val = i2.next();
            i2.remove();
        }
        System.out.println("Adding " + NUM / 4L + " records..");
        i = 0;
        while ((long)i < NUM / 4L) {
            d.addToList("two " + i);
            ++i;
        }
        System.out.println("Removing " + NUM / 2L + " records..");
        Iterator<String> i3 = d.getListIterator();
        for (count = NUM / 2L; i3.hasNext() && count > 0L; --count) {
            val = i3.next();
            i3.remove();
        }
        System.out.println("Adding " + NUM / 4L + " records..");
        i = 0;
        while ((long)i < NUM / 4L) {
            d.addToList("three " + i);
            ++i;
        }
        System.out.println("Removing all data..");
        Iterator<String> i4 = d.getListIterator();
        while (i4.hasNext()) {
            val = i4.next();
            i4.remove();
        }
        System.out.println("Adding " + NUM / 16L + " records..");
        i = 0;
        while ((long)i < NUM / 4L) {
            d.addToList("three " + i);
            ++i;
        }
        System.out.println("Removing all data..");
        Iterator<String> i5 = d.getListIterator();
        while (i5.hasNext()) {
            val = i5.next();
            i5.remove();
        }
        d.close();
    }

    static {
        statsCollector.register(DISK_LIST_ADD_TO_LIST_TIME);
        statsCollector.register(DISK_LIST_READ_RECORD_TIME);
        statsCollector.register(DISK_LIST_DISK_ITERATOR_REMOVE_TIME);
        statsCollector.register(DISK_LIST_DELETE_ALL_RECORDS_TIME);
    }

    public static class DiskListIterator
    implements Iterator<String> {
        private final DiskList diskList;
        private long nextIdx;
        private long curIdx;
        private boolean calledNext;
        private int modNum;

        private DiskListIterator(DiskList diskList, long nextIdx, int modNum) {
            this.diskList = diskList;
            this.nextIdx = nextIdx;
            this.curIdx = -1L;
            this.calledNext = false;
            this.modNum = modNum;
        }

        @Override
        public boolean hasNext() {
            return this.nextIdx != -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String next() throws NoSuchElementException {
            Record rec;
            if (this.nextIdx == -1L) {
                throw new NoSuchElementException();
            }
            this.curIdx = this.nextIdx;
            RandomAccessFile randomAccessFile = this.diskList.dataFile;
            synchronized (randomAccessFile) {
                if (this.diskList.modNum != this.modNum) {
                    throw new ConcurrentModificationException();
                }
                try {
                    rec = this.diskList.readRecord(this.curIdx);
                }
                catch (IOException e) {
                    log.error((Object)"IOException while reading record");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("IOException while trying to read record number " + this.curIdx), (Throwable)e);
                    }
                    NoSuchElementException ex = new NoSuchElementException("Error getting next element: " + e);
                    ex.initCause(e);
                    throw ex;
                }
            }
            this.nextIdx = rec.nextIdx;
            this.calledNext = true;
            return rec.data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (!this.calledNext) {
                throw new IllegalStateException("remove() called without first calling next()");
            }
            this.calledNext = false;
            long start = DiskList.now();
            RandomAccessFile randomAccessFile = this.diskList.dataFile;
            synchronized (randomAccessFile) {
                if (this.diskList.modNum != this.modNum) {
                    throw new ConcurrentModificationException();
                }
                try {
                    this.diskList.removeRecord(this.curIdx);
                }
                catch (IOException exc) {
                    log.error((Object)"IOException while removing record");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"IOException while removing record", (Throwable)exc);
                    }
                    throw new IllegalStateException("Error removing record: " + exc, exc);
                }
                this.modNum = this.diskList.modNum;
            }
            long duration = DiskList.now() - start;
            statsCollector.addStat(duration, DiskList.DISK_LIST_DISK_ITERATOR_REMOVE_TIME);
        }
    }

    private static class Record {
        private boolean isUsed;
        private long prevIdx;
        private long nextIdx;
        private String data;

        private Record() {
        }
    }
}

