/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Base64;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentKeystoreConfig;
import org.hyperic.hq.agent.db.DiskList;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.stats.AgentStatsCollector;
import org.hyperic.hq.common.SystemException;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.security.KeystoreConfig;
import org.hyperic.util.security.KeystoreManager;
import org.hyperic.util.security.SecuredPbeStringEncryptor;
import org.hyperic.util.security.SecurityUtil;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PBEStringEncryptor;

public class AgentDListProvider
implements AgentStorageProvider {
    private static final Log log = LogFactory.getLog(AgentDListProvider.class);
    private static final int RECSIZE = 4000;
    private static final int OLD_RECSIZE = 1024;
    private static final long MAXSIZE = 0x3200000L;
    private static final long CHKSIZE = 0xA00000L;
    private static final int CHKPERC = 50;
    private final AgentStatsCollector agentStatsCollector = AgentStatsCollector.getInstance();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private HashMap<EncVal, EncVal> keyVals;
    private HashMap<String, DiskList> lists;
    private HashMap<String, ListInfo> overloads;
    private File writeDir;
    private File keyValFile;
    private File keyValFileBackup;
    private AgentConfig cfg;
    private final AtomicBoolean keyValDirty = new AtomicBoolean(true);
    private long maxSize = 0x3200000L;
    private long chkSize = 0xA00000L;
    private int chkPerc = 50;
    private PBEStringEncryptor encryptor;

    protected PBEStringEncryptor createEncryptor() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException, IOException {
        SecuredPbeStringEncryptor encryptor = new SecuredPbeStringEncryptor(this.getKeyvalsPass().toCharArray());
        return encryptor;
    }

    public String getDescription() {
        return "Agent D-list provider.  Data is written to data/idx files for lists, and a single file for key/values";
    }

    private DiskList intrCreateList(String name, int recSize) throws IOException {
        long _maxSize = this.maxSize;
        long _chkSize = this.chkSize;
        int _chkPerc = this.chkPerc;
        ListInfo info = this.overloads.get(name);
        if (info != null) {
            _maxSize = info.maxSize;
            _chkSize = info.chkSize;
            _chkPerc = info.chkPerc;
        }
        return new DiskList(new File(this.writeDir, name), recSize, _chkSize, _chkPerc, _maxSize);
    }

    public void createList(String name, int recSize) throws AgentStorageException {
        try {
            DiskList dList = this.intrCreateList(name, recSize);
            this.lists.put(name, dList);
        }
        catch (IOException e) {
            AgentStorageException toThrow = new AgentStorageException("Unable to create DiskList: " + e);
            toThrow.initCause((Throwable)e);
            throw toThrow;
        }
    }

    private ListInfo parseInfo(String info) throws AgentStorageException {
        long factor;
        StringTokenizer st = new StringTokenizer(info, ":");
        if (st.countTokens() != 4) {
            throw new AgentStorageException(info + " is an invalid agent disklist configuration");
        }
        String s = st.nextToken().trim();
        if ("m".equalsIgnoreCase(s)) {
            factor = 0x100000L;
        } else if ("k".equalsIgnoreCase(s)) {
            factor = 1024L;
        } else {
            throw new AgentStorageException(info + " is an invalid agent disklist configuration");
        }
        ListInfo listInfo = new ListInfo();
        try {
            listInfo.maxSize = Long.parseLong(st.nextToken().trim()) * factor;
            listInfo.chkSize = Long.parseLong(st.nextToken().trim()) * factor;
            listInfo.chkPerc = Integer.parseInt(st.nextToken().trim());
        }
        catch (NumberFormatException e) {
            throw new AgentStorageException("Invalid agent disklist configuration: " + e);
        }
        return listInfo;
    }

    public void addOverloadedInfo(String listName, String info) {
        try {
            this.overloads.put(listName, this.parseInfo(info));
        }
        catch (AgentStorageException ex) {
            log.error((Object)("Failed to overload info: " + (Object)((Object)ex)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String key, String value) {
        boolean debug = log.isDebugEnabled();
        boolean mapChanged = false;
        if (value == null) {
            if (debug) {
                log.debug((Object)("Removing '" + key + "' from storage"));
            }
            HashMap<EncVal, EncVal> hashMap = this.keyVals;
            synchronized (hashMap) {
                EncVal encryptableKey = new EncVal(this.encryptor, key);
                EncVal removed = this.keyVals.remove(encryptableKey);
                if (removed != null) {
                    mapChanged = true;
                }
            }
        }
        if (debug) {
            log.debug((Object)("Setting '" + key + "' to '" + value + "'"));
        }
        HashMap<EncVal, EncVal> hashMap = this.keyVals;
        synchronized (hashMap) {
            EncVal encryptableKey = new EncVal(this.encryptor, key);
            EncVal encryptableValue = new EncVal(this.encryptor, value);
            if (this.isNewEntry(encryptableKey, encryptableValue)) {
                this.keyVals.put(encryptableKey, encryptableValue);
                mapChanged = true;
            }
        }
        if (mapChanged) {
            this.keyValDirty.set(true);
        }
    }

    private boolean isNewEntry(EncVal key, EncVal value) {
        return !value.equals(this.keyVals.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String key) {
        String res = null;
        HashMap<EncVal, EncVal> hashMap = this.keyVals;
        synchronized (hashMap) {
            EncVal encVal = this.keyVals.get(new EncVal(this.encryptor, key));
            res = encVal == null ? null : encVal.getVal();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got " + key + "='" + res + "'"));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeys() {
        HashSet<String> set = new HashSet<String>();
        HashMap<EncVal, EncVal> hashMap = this.keyVals;
        synchronized (hashMap) {
            for (EncVal v : this.keyVals.keySet()) {
                set.add(v.getVal());
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPropertiesKeys(String propertiesKeyPrefix) {
        HashSet<String> set = new HashSet<String>();
        HashMap<EncVal, EncVal> hashMap = this.keyVals;
        synchronized (hashMap) {
            for (EncVal v : this.keyVals.keySet()) {
                if (!v.getVal().startsWith(propertiesKeyPrefix)) continue;
                set.add(v.getVal());
            }
        }
        return set;
    }

    protected String getKeyvalsPass() throws KeyStoreException, IOException, NoSuchAlgorithmException, UnrecoverableEntryException {
        AgentKeystoreConfig keystoreConfig = new AgentKeystoreConfig(this.cfg);
        KeyStore keystore = KeystoreManager.getKeystoreManager().getKeyStore((KeystoreConfig)keystoreConfig);
        KeyStore.Entry e = keystore.getEntry(keystoreConfig.getAlias(), new KeyStore.PasswordProtection(keystoreConfig.getFilePassword()));
        if (e == null) {
            throw new UnrecoverableEntryException("Encryptor password generation failure: No such alias");
        }
        byte[] keyBytes = ((KeyStore.PrivateKeyEntry)e).getPrivateKey().getEncoded();
        return new String(Base64.encode((byte[])keyBytes), "US-ASCII");
    }

    public synchronized void flush() throws AgentStorageException {
        this.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void flush(boolean toShutdown) throws AgentStorageException {
        if (this.shutdown.get() && !toShutdown) {
            return;
        }
        long start = System.currentTimeMillis();
        BufferedOutputStream bOs = null;
        FileOutputStream fOs = null;
        DataOutputStream dOs = null;
        if (!this.keyValDirty.get()) {
            return;
        }
        Map.Entry<EncVal, EncVal> curr = null;
        try {
            fOs = new FileOutputStream(this.keyValFile);
            bOs = new BufferedOutputStream(fOs);
            dOs = new DataOutputStream(bOs);
            HashMap<EncVal, EncVal> hashMap = this.keyVals;
            synchronized (hashMap) {
                dOs.writeLong(this.keyVals.size());
                Iterator<Map.Entry<EncVal, EncVal>> i$ = this.keyVals.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry<EncVal, EncVal> entry;
                    curr = entry = i$.next();
                    String encKey = entry.getKey().getEnc();
                    String encVal = entry.getValue().getEnc();
                    dOs.writeUTF(encKey);
                    dOs.writeUTF(encVal);
                }
            }
            this.keyValDirty.set(false);
            this.close(dOs);
            this.close(bOs);
            this.close(fOs);
        }
        catch (UTFDataFormatException e) {
            if (curr != null) {
                log.error((Object)("error writing key=" + ((EncVal)curr.getKey()).getVal() + ", value=" + ((EncVal)curr.getValue()).getVal()), (Throwable)e);
            } else {
                log.error((Object)e, (Throwable)e);
            }
            this.close(dOs);
            this.close(bOs);
            this.close(fOs);
        }
        catch (IOException e2) {
            log.error((Object)"Error flushing data", (Throwable)e2);
            AgentStorageException toThrow = new AgentStorageException("Error flushing data: " + e2);
            toThrow.initCause((Throwable)e2);
            throw toThrow;
            {
                catch (Throwable throwable) {
                    this.close(dOs);
                    this.close(bOs);
                    this.close(fOs);
                    throw throwable;
                }
            }
        }
        try {
            HashMap<EncVal, EncVal> e2 = this.keyVals;
            synchronized (e2) {
                FileUtil.copyFile((File)this.keyValFile, (File)this.keyValFileBackup);
            }
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("File not found: " + e));
            log.debug((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error backing up keyvals", (Throwable)e);
            AgentStorageException toThrow = new AgentStorageException("Error backing up keyvals: " + e);
            toThrow.initCause((Throwable)e);
            throw toThrow;
        }
        this.agentStatsCollector.addStat(System.currentTimeMillis() - start, "DISK_LIST_KEYVALS_FLUSH_TIME");
    }

    private void close(OutputStream os) {
        try {
            if (os != null) {
                os.flush();
                os.close();
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void init(AgentConfig cfg) throws AgentStorageException {
        long factor;
        this.cfg = cfg;
        this.keyVals = null;
        this.lists = null;
        try {
            this.encryptor = this.createEncryptor();
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        String info = cfg.getStorageProviderInfo();
        FileInputStream fIs = null;
        StringTokenizer st = new StringTokenizer(info, "|");
        if (st.countTokens() != 5) {
            throw new AgentStorageException(info + " is an invalid agent storage provider configuration");
        }
        this.keyVals = new HashMap();
        this.lists = new HashMap();
        this.overloads = new HashMap();
        String dir = st.nextToken();
        this.writeDir = new File(dir);
        this.keyValFile = new File(this.writeDir, "keyvals");
        this.keyValFileBackup = new File(this.writeDir, "keyvals.backup");
        String s = st.nextToken().trim();
        if ("m".equalsIgnoreCase(s)) {
            factor = 0x100000L;
        } else if ("k".equalsIgnoreCase(s)) {
            factor = 1024L;
        } else {
            throw new AgentStorageException(info + " is an invalid agent storage provider configuration");
        }
        try {
            this.maxSize = Long.parseLong(st.nextToken().trim()) * factor;
            this.chkSize = Long.parseLong(st.nextToken().trim()) * factor;
            this.chkPerc = Integer.parseInt(st.nextToken().trim());
        }
        catch (NumberFormatException e) {
            throw new AgentStorageException("Invalid agent storage provider configuration: " + e);
        }
        if (!this.writeDir.exists()) {
            this.writeDir.mkdir();
        }
        if (!this.writeDir.isDirectory()) {
            throw new AgentStorageException(dir + " is not a directory");
        }
        try {
            fIs = new FileInputStream(this.keyValFile);
            BufferedInputStream bIs = new BufferedInputStream(fIs);
            DataInputStream dIs = new DataInputStream(bIs);
            long nEnts = dIs.readLong();
            while (nEnts-- != 0L) {
                String encKey = dIs.readUTF();
                String encVal = dIs.readUTF();
                String key = SecurityUtil.isMarkedEncrypted((String)encKey) ? SecurityUtil.decryptRecursiveUnmark((StringEncryptor)this.encryptor, (String)encKey) : encKey;
                String val = SecurityUtil.isMarkedEncrypted((String)encVal) ? SecurityUtil.decryptRecursiveUnmark((StringEncryptor)this.encryptor, (String)encVal) : encVal;
                this.keyVals.put(new EncVal(this.encryptor, key, encKey), new EncVal(this.encryptor, val, encVal));
            }
            this.close(fIs);
        }
        catch (FileNotFoundException exc) {
            log.debug((Object)("file not found (this is ok): " + exc));
            this.close(fIs);
        }
        catch (IOException exc2) {
            log.error((Object)("Error reading " + this.keyValFile + " loading " + "last known good version"));
            this.close(fIs);
            try {
                fIs = new FileInputStream(this.keyValFileBackup);
                BufferedInputStream bIs = new BufferedInputStream(fIs);
                DataInputStream dIs = new DataInputStream(bIs);
                long nEnts = dIs.readLong();
                while (nEnts-- != 0L) {
                    String encKey = dIs.readUTF();
                    String encVal = dIs.readUTF();
                    String key = SecurityUtil.encrypt((StringEncryptor)this.encryptor, (String)encKey);
                    String val = SecurityUtil.encrypt((StringEncryptor)this.encryptor, (String)encVal);
                    this.keyVals.put(new EncVal(this.encryptor, key, encKey), new EncVal(this.encryptor, val, encVal));
                }
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("File not found: " + this.keyValFileBackup));
                log.debug((Object)e, (Throwable)e);
            }
            catch (IOException e) {
                AgentStorageException toThrow = new AgentStorageException("Error reading " + this.keyValFile + ": " + e);
                toThrow.initCause((Throwable)e);
                throw toThrow;
            }
            this.close(fIs);
            {
                catch (Throwable throwable) {
                    this.close(fIs);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectToFolder(String folderName, Object obj, long createTime, int maxElementsInFolder) {
        File[] files;
        int numberOfElementsInFolder;
        File folder = new File(this.writeDir + System.getProperty("file.separator") + folderName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if ((numberOfElementsInFolder = (files = folder.listFiles()).length) >= maxElementsInFolder) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                }
            });
            int i = 0;
            while (numberOfElementsInFolder >= maxElementsInFolder) {
                files[i].delete();
                --numberOfElementsInFolder;
                ++i;
            }
        }
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(folder.getAbsolutePath() + System.getProperty("file.separator") + createTime));
            outputStream.writeObject(obj);
        }
        catch (Exception ex) {
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public void deleteObjectsFromFolder(String folderName, String ... objects) {
        String folder = this.writeDir + System.getProperty("file.separator") + folderName;
        for (String object : objects) {
            File file = new File(folder + System.getProperty("file.separator") + object);
            if (!file.exists()) {
                log.warn((Object)("Cannot find file '" + object + "' to delete"));
                continue;
            }
            if (file.delete()) continue;
            log.warn((Object)("Cannot delete '" + object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getObjectsFromFolder(String folderName, int maxNumOfObjects) {
        ArrayList<Object> objects = new ArrayList<Object>();
        File folder = new File(this.writeDir + System.getProperty("file.separator") + folderName);
        if (!folder.exists()) {
            return objects;
        }
        File[] files = folder.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return -Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
            }
        });
        for (File fileEntry : files) {
            if (maxNumOfObjects <= 0) break;
            ObjectInputStream inputStream = null;
            try {
                inputStream = new ObjectInputStream(new FileInputStream(fileEntry));
                objects.add(inputStream.readObject());
                --maxNumOfObjects;
            }
            catch (Exception ex) {
                log.error((Object)("Cannot read objects from '" + folderName + "'" + ex.getMessage()));
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
        return objects;
    }

    public void deleteObject(String objectName) {
        File file = new File(this.writeDir + System.getProperty("file.separator") + objectName);
        if (file.exists()) {
            if (!file.delete()) {
                log.warn((Object)("Cannot delete '" + objectName + "'"));
            }
        } else {
            log.warn((Object)("File does not exists '" + objectName + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveObject(Object obj, String objectName) {
        File file = new File(this.writeDir + System.getProperty("file.separator") + objectName);
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(file));
            outputStream.writeObject(obj);
        }
        catch (Exception ex) {
            log.error((Object)("Cannot save object '" + objectName + "'"), (Throwable)ex);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException ex) {
                log.error((Object)"Error closing file: ", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getObject(String objectName) {
        File file = new File(this.writeDir + System.getProperty("file.separator") + objectName);
        if (!file.exists()) {
            log.info((Object)("Did not find object '" + objectName + "' in the local storage"));
            return null;
        }
        ObjectInputStream inputStream = null;
        try {
            Object result;
            inputStream = new ObjectInputStream(new FileInputStream(file));
            Object object = result = inputStream.readObject();
            return (T)object;
        }
        catch (Exception ex) {
            log.error((Object)("Cannot read object '" + objectName + "'"), (Throwable)ex);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
        }
        return null;
    }

    private void close(FileInputStream fIs) {
        try {
            if (fIs != null) {
                fIs.close();
            }
        }
        catch (IOException e) {
            log.debug((Object)"Failed to close file", (Throwable)e);
        }
    }

    public void dispose() {
        if (this.shutdown.get()) {
            return;
        }
        try {
            this.shutdown.set(true);
            this.flush(true);
        }
        catch (Exception exc) {
            log.error((Object)"Error flushing key/vals storage", (Throwable)exc);
        }
        for (Map.Entry<String, DiskList> entry : this.lists.entrySet()) {
            try {
                DiskList dl = entry.getValue();
                dl.close();
            }
            catch (Exception exc) {
                log.error((Object)("Unable to dispose of disk list '" + entry.getKey() + "'"), (Throwable)exc);
            }
        }
    }

    public void addToList(String listName, String value) throws AgentStorageException {
        if (this.shutdown.get()) {
            return;
        }
        DiskList dList = this.getDiskList(listName);
        if (null == dList) {
            log.error((Object)("Error adding data , cannot read list '" + listName + "' from storage"));
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding value to list=" + listName + ", value=" + value));
            }
            dList.addToList(value);
        }
        catch (IOException exc) {
            log.error((Object)("Error adding to list '" + listName + "'"), (Throwable)exc);
            AgentStorageException toThrow = new AgentStorageException("Error adding data to list: " + exc);
            toThrow.initCause((Throwable)exc);
            throw toThrow;
        }
    }

    public void removeFromList(String listName, long recNumber) throws AgentStorageException {
        if (this.shutdown.get()) {
            return;
        }
        DiskList dList = this.getDiskList(listName);
        if (null == dList) {
            log.error((Object)("Error removing data , cannot read list '" + listName + "' " + "from storage"));
            return;
        }
        try {
            dList.removeRecord(recNumber);
        }
        catch (IOException exc) {
            log.error((Object)("Error deleting from list '" + listName + "'"), (Throwable)exc);
            AgentStorageException t = new AgentStorageException("Error deleting data from list: " + exc);
            t.initCause((Throwable)exc);
            throw t;
        }
    }

    public void deleteList(String listName) {
        if (this.shutdown.get()) {
            return;
        }
        DiskList dList = this.getDiskList(listName);
        if (null == dList) {
            return;
        }
        try {
            dList.deleteAllRecords();
        }
        catch (IOException exc) {
            log.error((Object)"Error deleting all records", (Throwable)exc);
        }
    }

    public Iterator<String> getListIterator(String listName) {
        DiskList dList = this.getDiskList(listName);
        if (null == dList) {
            return null;
        }
        return dList.getListIterator();
    }

    public void convertListToCurrentRecordSize(String listName) throws IOException {
        DiskList dList = this.getDiskList(listName);
        if (null == dList) {
            return;
        }
        dList.convertListToCurrentRecordSize(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiskList getDiskList(String listName) {
        DiskList dList;
        HashMap<String, DiskList> hashMap = this.lists;
        synchronized (hashMap) {
            dList = this.lists.get(listName);
            if (dList == null) {
                try {
                    dList = this.intrCreateList(listName, 4000);
                }
                catch (IOException exc) {
                    log.error((Object)"Error loading disk list", (Throwable)exc);
                    return null;
                }
                this.lists.put(listName, dList);
            }
        }
        return dList;
    }

    private class EncVal {
        private final String val;
        private String encrypted = null;
        private final PBEStringEncryptor encryptor;

        private EncVal(PBEStringEncryptor encryptor, String val, String encrypted) {
            this.val = val;
            this.encrypted = SecurityUtil.isMarkedEncrypted((String)encrypted) ? encrypted : null;
            this.encryptor = encryptor;
        }

        private EncVal(PBEStringEncryptor encryptor, String val) {
            this.val = val;
            this.encryptor = encryptor;
        }

        private String getVal() {
            return this.val;
        }

        private String getEnc() {
            if (this.encrypted == null) {
                this.encrypted = SecurityUtil.encrypt((StringEncryptor)this.encryptor, (String)this.val);
            }
            return this.encrypted;
        }

        public String toString() {
            return this.val;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof EncVal) {
                EncVal v = (EncVal)o;
                return this.val.equals(v.val);
            }
            return false;
        }

        public int hashCode() {
            return this.val.hashCode();
        }
    }

    private static class ListInfo {
        long maxSize;
        long chkSize;
        int chkPerc;

        private ListInfo() {
        }
    }
}

