/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.hyperic.hq.util.properties.PropertiesUtil;

public class ProviderInfo {
    private String providerAddress;
    private String providerHost;
    private final String agentToken;
    private int providerPort;

    public ProviderInfo(String providerAddress, String agentToken) {
        if (providerAddress == null || agentToken == null) {
            throw new IllegalArgumentException("No arguments can be null");
        }
        this.validateAndInitializeAddress(providerAddress);
        this.agentToken = agentToken;
        this.providerPort = -1;
    }

    public ProviderInfo(String providerAddress, String agentToken, int providerPort) {
        if (providerAddress == null || agentToken == null) {
            throw new IllegalArgumentException("No arguments can be null");
        }
        this.validateAndInitializeAddress(providerAddress);
        PropertiesUtil.validatePort((int)providerPort);
        this.agentToken = agentToken;
        this.providerPort = providerPort;
    }

    public static void validateAddress(String hostOrIp) throws IllegalArgumentException {
        try {
            InetAddress.getByName(hostOrIp);
        }
        catch (UnknownHostException exc) {
            throw new IllegalArgumentException(exc.getMessage(), exc);
        }
    }

    private void validateAndInitializeAddress(String providerAddressToSet) throws IllegalArgumentException {
        URL url = null;
        try {
            url = new URL(providerAddressToSet);
            this.providerHost = url.getHost();
        }
        catch (MalformedURLException exc) {
            throw new IllegalArgumentException(exc.getMessage(), exc);
        }
        ProviderInfo.validateAddress(url.getHost());
        this.providerAddress = providerAddressToSet;
    }

    public void setProviderPort(int port) {
        this.providerPort = port;
    }

    public int getProviderPort() {
        return this.providerPort;
    }

    public String getProviderAddress() {
        return this.providerAddress;
    }

    public String getAgentToken() {
        return this.agentToken;
    }

    public String getProviderHost() {
        return this.providerHost;
    }

    public String toString() {
        return this.providerAddress;
    }
}

