/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.sigar.Sigar;

public class AskQuestionsUtil {
    private final AgentConfig configs;
    private static final String OPTIONS_SUFFIX_YES_NO_MORE = " (yes/no/more)?";
    private static final String OPTIONS_SUFFIX_YES_NO = " (yes/no)?";

    public AskQuestionsUtil(AgentConfig agentConfig) {
        this.configs = agentConfig;
    }

    public boolean askYesNoQuestion(String question, boolean def, String questionProp) throws IOException, AutoQuestionException {
        String fullQuestion = question + OPTIONS_SUFFIX_YES_NO;
        boolean isAuto = this.configs.getBootProperty(questionProp) != null;
        String res;
        while (!(res = this.askQuestion(fullQuestion, def ? "yes" : "no", questionProp)).equalsIgnoreCase("yes") && !res.equalsIgnoreCase("y")) {
            if (res.equalsIgnoreCase("no") || res.equalsIgnoreCase("n")) {
                return false;
            }
            if (isAuto) {
                throw new AutoQuestionException("Property '" + questionProp + "' must be 'yes' or " + "'no'.");
            }
            System.out.println("- Value must be 'yes' or 'no'");
        }
        return true;
    }

    public Boolean askYesNoMoreQuestion(String question, boolean defaultVal, String questionProp) throws IOException, AutoQuestionException {
        String fullQuestion = question + OPTIONS_SUFFIX_YES_NO_MORE;
        boolean isAuto = this.configs.getBootProperty(questionProp) != null;
        String res;
        while (!(res = this.askQuestion(fullQuestion, defaultVal ? "yes" : "no", questionProp)).equalsIgnoreCase("yes") && !res.equalsIgnoreCase("y")) {
            if (res.equalsIgnoreCase("no") || res.equalsIgnoreCase("n")) {
                return false;
            }
            if (res.equalsIgnoreCase("more") || res.equalsIgnoreCase("m")) {
                return null;
            }
            if (isAuto) {
                throw new AutoQuestionException("Property '" + questionProp + "' must be 'yes' or " + "'no'.");
            }
            System.out.println("- Value must be 'yes', 'no' or 'more'");
        }
        return true;
    }

    public int askIntQuestion(String question, int def, String questionProp) throws IOException, AutoQuestionException {
        boolean isAuto = this.configs.getBootProperty(questionProp) != null;
        while (true) {
            String res = this.askQuestion(question, Integer.toString(def), questionProp);
            try {
                int iVal = Integer.parseInt(res);
                return iVal;
            }
            catch (NumberFormatException exc) {
                if (isAuto) {
                    throw new AutoQuestionException("Property '" + questionProp + "' must be a valid integer.");
                }
                System.out.println("- Value must be an integer.");
                continue;
            }
            break;
        }
    }

    public String askQuestionAcceptEmptyAnswer(String question, String defaultAnswer, String questionProp) throws IOException {
        return this.askQuestion(question, defaultAnswer, false, true, questionProp);
    }

    public String askQuestion(String question, String def, String questionProp) throws IOException {
        return this.askQuestion(question, def, false, false, questionProp);
    }

    public String askQuestion(String question, String defaultAnswer, boolean dontShowValueToUser, boolean acceptEmptyInput, String questionProp) throws IOException {
        String res;
        block7: {
            res = null;
            String bootProp = this.configs.getBootProperty(questionProp);
            do {
                System.out.print(question);
                if (defaultAnswer != null) {
                    System.out.print(" [default=" + defaultAnswer + "]");
                }
                System.out.print(": ");
                if (dontShowValueToUser) {
                    if (bootProp != null) {
                        System.out.println("**Not echoing value**");
                        return bootProp;
                    }
                    return Sigar.getPassword((String)"");
                }
                if (bootProp != null) {
                    if (bootProp.equals("*default*") && defaultAnswer != null) {
                        bootProp = defaultAnswer;
                    }
                    System.out.println(bootProp);
                    return bootProp;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                res = in.readLine();
                if (res != null && (res = res.trim()).length() == 0) {
                    res = null;
                }
                if (res != null) break block7;
                if (defaultAnswer == null) continue;
                return defaultAnswer;
            } while (!acceptEmptyInput);
            return res;
        }
        return res;
    }

    public static class UserQuestionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UserQuestionException(String s) {
            super(s);
        }
    }

    public static class AutoQuestionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AutoQuestionException(String s) {
            super(s);
        }
    }
}

