/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.util.encoding.Base64;

public class ScheduledMeasurement {
    private String dsn;
    private long interval;
    private Long derivedID;
    private Long dsnID;
    private AppdefEntityID ent;
    private String category;
    private long lastCollected;
    private String units;

    public ScheduledMeasurement(String dsn, long interval, long derivedId, long dsnId, AppdefEntityID ent, String category, String units) {
        this.dsn = dsn;
        this.interval = interval;
        this.derivedID = derivedId;
        this.dsnID = dsnId;
        this.ent = ent;
        this.category = category;
        this.units = units;
    }

    public String toString() {
        long derviedId = this.getDerivedID();
        long dsnId = this.getDsnID();
        String dsn = this.getDSN();
        StringBuffer buf = new StringBuffer(64);
        buf.append("[derivedId=").append(this.getDerivedID()).append("|dsnId=").append(this.getDsnID()).append("]").append("|interval=").append(this.getInterval()).append("]");
        return buf.toString();
    }

    public String getDSN() {
        return this.dsn;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getDerivedID() {
        return this.derivedID;
    }

    public long getDsnID() {
        return this.dsnID;
    }

    public AppdefEntityID getEntity() {
        return this.ent;
    }

    public String getCategory() {
        return this.category;
    }

    public String getUnits() {
        return this.units;
    }

    public String encode() {
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        DataOutputStream dOs = new DataOutputStream(bOs);
        try {
            dOs.writeUTF(this.dsn);
            dOs.writeLong(this.interval);
            dOs.writeLong(this.derivedID);
            dOs.writeLong(this.dsnID);
            dOs.writeInt(this.ent.getType());
            dOs.writeInt(this.ent.getID());
            dOs.writeUTF(this.category);
            dOs.writeUTF(this.units);
        }
        catch (IOException exc) {
            System.out.println("Unable to encode record: " + exc.getMessage());
        }
        return Base64.encode((byte[])bOs.toByteArray());
    }

    public static ScheduledMeasurement decode(String data) {
        ByteArrayInputStream bIs = new ByteArrayInputStream(Base64.decode((String)data));
        DataInputStream dIs = new DataInputStream(bIs);
        try {
            String dsn = dIs.readUTF();
            long interval = dIs.readLong();
            long derivedID = dIs.readLong();
            long dsnID = dIs.readLong();
            int entType = dIs.readInt();
            int entID = dIs.readInt();
            String category = dIs.readUTF();
            String units = dIs.readUTF();
            return new ScheduledMeasurement(dsn, interval, derivedID, dsnID, new AppdefEntityID(entType, entID), category, units);
        }
        catch (IOException exc) {
            System.out.println("Unable to encode record: " + exc.getMessage());
            return null;
        }
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof ScheduledMeasurement) {
            ScheduledMeasurement m = (ScheduledMeasurement)rhs;
            return this.derivedID == m.derivedID;
        }
        return false;
    }

    public int hashCode() {
        return this.derivedID.hashCode();
    }

    public long getLastCollected() {
        return this.lastCollected;
    }

    public void setLastCollected(long lastCollected) {
        this.lastCollected = lastCollected;
    }
}

