/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.control.agent.server;

import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.bizapp.client.ControlCallbackClient;
import org.hyperic.hq.control.agent.client.ControlCommandsClient;
import org.hyperic.hq.control.agent.server.ActionThread;
import org.hyperic.hq.product.ControlPluginManager;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginExistsException;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;

public class ControlCommandsService
implements ControlCommandsClient {
    private final ControlPluginManager _controlManager;
    private final ControlCallbackClient _client;

    public ControlCommandsService(ControlPluginManager controlManager, ControlCallbackClient client) {
        this._controlManager = controlManager;
        this._client = client;
    }

    public void controlPluginAdd(String pluginName, String pluginType, ConfigResponse response) throws AgentRemoteException {
        try {
            this._controlManager.createControlPlugin(pluginName, pluginType, response);
        }
        catch (PluginNotFoundException e) {
            throw new AgentRemoteException(e.getMessage());
        }
        catch (PluginExistsException e) {
            try {
                this._controlManager.updateControlPlugin(pluginName, response);
            }
            catch (Exception exc) {
                throw new AgentRemoteException(exc.getMessage());
            }
        }
        catch (PluginException e) {
            throw new AgentRemoteException(e.getMessage());
        }
    }

    public void controlPluginCommand(String pluginName, String pluginType, Integer id, String action, String args) throws AgentRemoteException {
        String idString = String.valueOf(id);
        String[] pluginArgs = StringUtil.explodeQuoted((String)args);
        this.controlPluginCommand(pluginName, pluginType, idString, action, pluginArgs);
    }

    void controlPluginCommand(String pluginName, String pluginType, String id, String pluginAction, String[] pluginArgs) {
        ActionThread actionThread = new ActionThread(pluginName, pluginType, id, pluginAction, pluginArgs, this._client, this._controlManager);
        actionThread.start();
    }

    public void controlPluginRemove(String pluginName) throws AgentRemoteException {
        try {
            this._controlManager.removeControlPlugin(pluginName);
        }
        catch (PluginNotFoundException e) {
        }
        catch (PluginException e) {
            throw new AgentRemoteException(e.getMessage());
        }
    }

    public final ControlCallbackClient getClient() {
        return this._client;
    }
}

