/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.file.monitor;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.springframework.roo.file.monitor.event.FileOperation;
import org.springframework.roo.support.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MonitoringRequest {
    private File resource;
    private Set<FileOperation> notifyOn;

    public MonitoringRequest(File resource, Set<FileOperation> notifyOn) {
        Assert.notNull((Object)resource, (String)"File to monitor is required");
        Assert.isTrue((boolean)resource.exists(), (String)"File must exist");
        Assert.notEmpty(notifyOn, (String)"At least one FileOperation to monitor must be specified");
        this.resource = resource;
        this.notifyOn = notifyOn;
    }

    public File getFile() {
        return this.resource;
    }

    public Set<FileOperation> getNotifyOn() {
        return Collections.unmodifiableSet(this.notifyOn);
    }
}

