/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.util.StringTokenizer;

public class HostIP {
    public static final int IP_HOST = 0;
    public static final int IP_MULTICAST = 1;
    public static final int IP_ANY = 2;

    public static byte[] convertIP(String ipAddr) {
        return HostIP.convertIP(ipAddr, 0);
    }

    public static byte[] convertIP(String ipAddr, int addressType) {
        int[] octets = new int[4];
        StringTokenizer st = new StringTokenizer(ipAddr, ".", true);
        if (st.countTokens() != 7) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            if (i > 0 && !st.nextToken().equals(".")) {
                return null;
            }
            try {
                octets[i] = Integer.parseInt(st.nextToken());
                continue;
            }
            catch (NumberFormatException exc) {
                return null;
            }
        }
        boolean isOK = false;
        switch (addressType) {
            case 0: {
                isOK = octets[0] > 0 && octets[0] < 255 && octets[1] >= 0 && octets[1] < 255 && octets[2] >= 0 && octets[2] < 255 && octets[3] > 0 && octets[3] < 255;
                break;
            }
            case 1: {
                isOK = octets[0] > 0 && octets[0] >= 224 && octets[0] <= 239 && octets[1] >= 0 && octets[1] <= 255 && octets[2] >= 0 && octets[2] <= 255 && octets[3] > 0 && octets[3] <= 255;
                break;
            }
            case 2: {
                isOK = octets[0] >= 0 && octets[0] <= 255 && octets[1] >= 0 && octets[1] <= 255 && octets[2] >= 0 && octets[2] <= 255 && octets[3] >= 0 && octets[3] <= 255;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized address type: " + addressType);
            }
        }
        if (!isOK) {
            return null;
        }
        byte[] res = new byte[]{(byte)octets[0], (byte)octets[1], (byte)octets[2], (byte)octets[3]};
        return res;
    }

    public static boolean isValidIP(String ip) {
        return HostIP.convertIP(ip) != null;
    }

    public static boolean isValidMulticastIP(String ip) {
        return HostIP.convertIP(ip, 1) != null;
    }
}

