/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.PropertyUtilException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.security.SecurityUtil;

public class PropertyUtil {
    private static final Log LOG = LogFactory.getLog(PropertyUtil.class);
    private static final Pattern PROPERTY_LINE_PATTERN = Pattern.compile("([^=:]*)([=|:])(.*)");

    public static void expandVariables(Map props) {
        ArrayList<String> vars = new ArrayList<String>();
        for (Map.Entry o : props.entrySet()) {
            int endIdx;
            Map.Entry ent = o;
            String value = (String)ent.getValue();
            int idx = value.indexOf("${");
            if (idx == -1) continue;
            vars.clear();
            while (idx != -1 && (endIdx = value.indexOf("}", idx)) != -1) {
                vars.add(value.substring(idx, ++endIdx));
                idx = value.indexOf("${", endIdx);
            }
            for (String replace : vars) {
                String replaceVar = replace.substring(2, replace.length() - 1);
                String lookupVal = (String)props.get(replaceVar);
                if (lookupVal == null) continue;
                value = StringUtil.replace(value, replace, lookupVal);
            }
            props.put(ent.getKey(), value);
        }
    }

    public static Properties loadProperties(String file) throws PropertyUtilException {
        FileInputStream fi = null;
        Reader propsFileReader = null;
        Properties props = new Properties();
        try {
            fi = new FileInputStream(file);
            propsFileReader = new InputStreamReader((InputStream)fi, "UTF-8");
            props.load(propsFileReader);
        }
        catch (Exception exc) {
            throw new PropertyUtilException(exc);
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
                if (propsFileReader != null) {
                    propsFileReader.close();
                }
            }
            catch (IOException ignore) {
                LOG.trace((Object)ignore);
            }
        }
        return props;
    }

    public static void storeProperties(String file, char[] propEncKey, Map<String, String> entriesToStore) throws PropertyUtilException {
        HashMap<String, String> encryptedEntriesToStore = new HashMap<String, String>();
        for (Map.Entry<String, String> entryToStore : entriesToStore.entrySet()) {
            String encryptedVal = SecurityUtil.encrypt(propEncKey, entryToStore.getValue());
            encryptedEntriesToStore.put(entryToStore.getKey(), encryptedVal);
        }
        PropertyUtil._storeProperties(file, encryptedEntriesToStore);
    }

    public static void storeProperties(String propFilePath, Map<String, String> props) throws PropertyUtilException {
        HashMap<String, String> duplicatedEntriesToStore = new HashMap<String, String>();
        for (Map.Entry<String, String> entryToStore : props.entrySet()) {
            duplicatedEntriesToStore.put(entryToStore.getKey(), entryToStore.getValue());
        }
        PropertyUtil._storeProperties(propFilePath, duplicatedEntriesToStore);
    }

    private static void _storeProperties(String propFilePath, Map<String, String> props) throws PropertyUtilException {
        if (props == null || props.size() < 1) {
            return;
        }
        PrintWriter writer = null;
        FileReader reader = null;
        try {
            String line;
            reader = new FileReader(propFilePath);
            BufferedReader bufferedReader = new BufferedReader(reader);
            ArrayList<String> newLines = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                newLines.add(PropertyUtil.processLine(line, props));
            }
            for (String key : props.keySet()) {
                newLines.add(key + " = " + props.get(key));
            }
            writer = new PrintWriter(propFilePath, "UTF-8");
            for (String aLineData : newLines) {
                writer.println(aLineData);
            }
            writer.flush();
        }
        catch (IOException exc) {
            String message = "Unable to store the properties in the file: " + propFilePath;
            LOG.error((Object)message, (Throwable)exc);
            throw new PropertyUtilException(exc);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static String processLine(String line, Map<String, String> props) {
        String key;
        String value;
        Matcher matcher = PROPERTY_LINE_PATTERN.matcher(line);
        String result = matcher.find() ? ((value = props.remove(key = matcher.group(1).trim().replaceAll("\\\\", ""))) == null ? line : matcher.group(1) + matcher.group(2) + value) : line;
        return result;
    }
}

