/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.Serializable;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.InvalidOptionValueException;

public class StringConfigOption
extends ConfigOption
implements Serializable {
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;
    private boolean isSecret = false;
    private boolean sensitive = false;
    private boolean isHidden = false;

    public StringConfigOption(String optName, String optDesc, String defValue) {
        super(optName, optDesc, defValue);
    }

    public StringConfigOption(String optName, String optDesc) {
        super(optName, optDesc, null);
    }

    @Override
    public void checkOptionIsValid(String value) throws InvalidOptionValueException {
        if (this.isOptional() && value == null) {
            return;
        }
        int min = this.getMinLength();
        if (min == 0 && !this.isOptional()) {
            min = 1;
        }
        if (value == null) {
            throw this.invalidOption("cannot be null");
        }
        if (value.length() < min) {
            throw this.invalidOption("must be at least " + min + " characters long");
        }
        if (value.length() > this.getMaxLength()) {
            throw this.invalidOption("cannot be more than " + this.getMaxLength() + " characters long");
        }
    }

    public void setMinLength(int len) {
        this.minLength = len;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMaxLength(int len) {
        this.maxLength = len;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setSecret(boolean val) {
        this.isSecret = val;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public void setHidden(boolean val) {
        this.isHidden = val;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public void setSensitive(boolean isSensitive) {
        this.sensitive = isSensitive;
    }
}

