/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.roo.file.monitor.DirectoryMonitoringRequest;
import org.springframework.roo.file.monitor.FileMonitoringRequest;
import org.springframework.roo.file.monitor.MonitoringRequest;
import org.springframework.roo.file.monitor.event.FileEventListener;
import org.springframework.roo.file.monitor.event.FileOperation;
import org.springframework.roo.file.monitor.polling.PollingFileMonitorService;

public class FileWatcher {
    private PollingFileMonitorService monitorService = new PollingFileMonitorService();
    private Set<FileOperation> ops = new HashSet<FileOperation>();
    private static final long DEFAULT_CHECK_INTERVAL = 1000L;
    private long checkInterval = 1000L;
    private Timer monitorTimer;

    public FileWatcher() {
        this.ops.add(FileOperation.CREATED);
        this.ops.add(FileOperation.UPDATED);
        this.ops.add(FileOperation.DELETED);
    }

    private void addFileOrDir(String fileOrDir, boolean watchSubtrees) {
        File fileOrDirFile = new File(fileOrDir);
        Object request = fileOrDirFile.isDirectory() ? new DirectoryMonitoringRequest(fileOrDirFile, watchSubtrees, this.ops) : new FileMonitoringRequest(fileOrDirFile, this.ops);
        this.monitorService.add((MonitoringRequest)request);
    }

    public void addDir(String dir, boolean watchSubtrees) {
        this.addFileOrDir(dir, watchSubtrees);
    }

    public void addFile(String file) {
        this.addFileOrDir(file, false);
    }

    public void addFileEventListener(FileEventListener fileEventListener) {
        this.monitorService.addFileEventListener(fileEventListener);
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void start() {
        this.monitorTimer = new Timer(true);
        this.monitorTimer.schedule((TimerTask)new MonitorTask(), 0L, this.checkInterval);
    }

    public void stop() {
        this.monitorTimer.cancel();
    }

    private class MonitorTask
    extends TimerTask {
        private MonitorTask() {
        }

        @Override
        public void run() {
            FileWatcher.this.monitorService.scanAll();
        }
    }
}

