/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file.match;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.hyperic.util.file.match.MatchSelector;
import org.hyperic.util.file.match.MatcherScanner;
import org.hyperic.util.file.match.MultipleMatchesException;

class MasterMatchSelector
implements FileSelector {
    private MatchSelector[] subSelectors;
    private boolean allowMultipleMatches;

    public MasterMatchSelector(MatchSelector[] subSelectors, boolean allowMultipleMatches) {
        this.subSelectors = subSelectors;
        this.allowMultipleMatches = allowMultipleMatches;
    }

    public void setScanner(MatcherScanner scanner) {
        for (int i = 0; i < this.subSelectors.length; ++i) {
            this.subSelectors[i].setMatcherScanner(scanner);
        }
    }

    public boolean isSelected(File basedir, String filename, File file) throws BuildException {
        MatchSelector matched = null;
        for (int i = 0; i < this.subSelectors.length; ++i) {
            if (!this.subSelectors[i].isSelected(basedir, filename, file)) continue;
            if (!this.allowMultipleMatches && matched != null) {
                MatchSelector[] matchers = new MatchSelector[]{matched, this.subSelectors[i]};
                MultipleMatchesException mme = new MultipleMatchesException(file, matchers);
                throw mme;
            }
            matched = this.subSelectors[i];
        }
        return matched != null;
    }
}

