/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file.match;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.hyperic.util.JDK;
import org.hyperic.util.StringUtil;
import org.hyperic.util.file.match.MatcherScanner;

public class MatchSelector
implements FileSelector {
    private boolean isWindows;
    private Object key;
    private List matchPatterns;
    private List excludePatterns;
    private MatcherScanner scanner;
    private Log log;

    public MatchSelector(Object key) {
        this.key = key;
        this.matchPatterns = new ArrayList();
        this.excludePatterns = new ArrayList();
        this.isWindows = JDK.IS_WIN32;
    }

    public MatchSelector(Object key, List matchPatterns, List excludePatterns) {
        this.key = key;
        this.matchPatterns = matchPatterns;
        this.excludePatterns = excludePatterns;
        this.isWindows = JDK.IS_WIN32;
        if (this.isWindows) {
            String pattern;
            int i;
            if (this.matchPatterns != null) {
                for (i = 0; i < this.matchPatterns.size(); ++i) {
                    pattern = this.matchPatterns.get(i).toString();
                    this.matchPatterns.set(i, this.transformIfWindows(pattern));
                }
            }
            if (this.excludePatterns != null) {
                for (i = 0; i < this.excludePatterns.size(); ++i) {
                    pattern = this.excludePatterns.get(i).toString();
                    this.excludePatterns.set(i, this.transformIfWindows(pattern));
                }
            }
        }
    }

    public void setMatcherScanner(MatcherScanner scanner) {
        this.scanner = scanner;
        this.log = scanner.getLog();
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public List getMatchPatterns() {
        return this.matchPatterns;
    }

    public void addMatchPattern(String pattern) {
        this.matchPatterns.add(this.transformIfWindows(pattern));
    }

    public void addMatchPatterns(String[] patterns) {
        if (patterns == null) {
            return;
        }
        for (int i = 0; i < patterns.length; ++i) {
            this.matchPatterns.add(this.transformIfWindows(patterns[i]));
        }
    }

    public List getExcludePatterns() {
        return this.excludePatterns;
    }

    public void addExcludePattern(String pattern) {
        this.excludePatterns.add(this.transformIfWindows(pattern));
    }

    public void addExcludePatterns(String[] patterns) {
        if (patterns == null) {
            return;
        }
        for (int i = 0; i < patterns.length; ++i) {
            this.excludePatterns.add(this.transformIfWindows(patterns[i]));
        }
    }

    private String transformIfWindows(String pattern) {
        if (this.isWindows) {
            pattern = StringUtil.normalizePath(pattern);
        }
        return pattern;
    }

    private String stripDriveLetter(String path) {
        if (this.isWindows && path.length() > 2 && path.charAt(1) == ':') {
            path = path.substring(2);
        }
        return path;
    }

    public boolean isSelected(File basedir, String filename, File file) throws BuildException {
        int i;
        String fullpath = this.stripDriveLetter(file.getAbsolutePath());
        int size = this.excludePatterns.size();
        for (i = 0; i < size; ++i) {
            if (!SelectorUtils.matchPath((String)this.excludePatterns.get(i).toString(), (String)fullpath, (!this.isWindows ? 1 : 0) != 0)) continue;
            return false;
        }
        size = this.matchPatterns.size();
        for (i = 0; i < size; ++i) {
            if (!SelectorUtils.matchPath((String)StringUtil.normalizePath(this.matchPatterns.get(i).toString().toLowerCase()), (String)StringUtil.normalizePath(fullpath.toLowerCase()), (!this.isWindows ? 1 : 0) != 0)) continue;
            this.scanner.addMatch(this.key, file.toString());
            return true;
        }
        return false;
    }

    public String toString() {
        String rstr = "";
        rstr = rstr + "MatchSelector {key=" + this.key + ", match=" + StringUtil.listToString(this.matchPatterns) + ", exclude=" + StringUtil.listToString(this.excludePatterns) + "}";
        return rstr;
    }
}

