/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.jdbc;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public final class JDBC {
    public static final String CLOUDSCAPE_NAME = "cloudscape";
    public static final int CLOUDSCAPE_TYPE = 1;
    public static final String INSTANTDB_NAME = "idb";
    public static final int INSTANTDB_TYPE = 2;
    public static final String ORACLE_NAME = "oracle";
    public static final int ORACLE_TYPE = 3;
    public static final String PGSQL_NAME = "postgres";
    public static final int PGSQL_TYPE = 4;
    public static final String ORACLE_THIN_NAME = "oracle-thin";
    public static final int ORACLE_THIN_TYPE = 5;
    public static final String COVLOG_NAME = "covalent-log";
    public static final int COVLOG_TYPE = 6;
    public static final String POINTBASE_NAME = "pointbase";
    public static final int POINTBASE_TYPE = 7;
    public static final String MYSQL_NAME = "mysql";
    public static final int MYSQL_TYPE = 8;
    private static HashMap driverClasses = new HashMap();
    private static String[] typeToNames;

    public static String getConnectionString(String driver) {
        if (driver == null) {
            throw new IllegalArgumentException("Parameter 'driver' cannot be null.");
        }
        String strResult = driver.indexOf(CLOUDSCAPE_NAME) != -1 ? "jdbc:cloudscape:" : (driver.indexOf(INSTANTDB_NAME) != -1 ? "jdbc:idb=" : (driver.indexOf(ORACLE_THIN_NAME) != -1 ? "jdbc:oracle:thin:@" : (driver.indexOf(ORACLE_NAME) != -1 ? "jdbc:oracle:oci8:" : (driver.indexOf(PGSQL_NAME) != -1 ? "jdbc:postgresql:" : (driver.indexOf(COVLOG_NAME) != -1 ? "jdbc:covalent-log:" : (driver.toLowerCase().indexOf(POINTBASE_NAME) != -1 ? "jdbc:pointbase:" : (driver.toLowerCase().indexOf(MYSQL_NAME) != -1 ? "jdbc:mysql:" : new String())))))));
        return strResult;
    }

    public static String getCmpAdapterFactory(String driver) {
        if (driver == null) {
            throw new IllegalArgumentException("Parameter 'driver' cannot be null.");
        }
        String strResult = driver.indexOf(CLOUDSCAPE_NAME) != -1 ? "net.covalent.c3.server.data.jdbc.AdapterFactory" : (driver.indexOf(INSTANTDB_NAME) != -1 ? "net.covalent.c3.server.data.jdbc.idb.AdapterFactory" : (driver.indexOf(ORACLE_NAME) != -1 ? "net.covalent.c3.server.data.jdbc.oracle.AdapterFactory" : (driver.indexOf(ORACLE_THIN_NAME) != -1 ? "net.covalent.c3.server.data.jdbc.oracle.AdapterFactory" : (driver.indexOf(PGSQL_NAME) != -1 ? "net.covalent.c3.server.data.jdbc.AdapterFactory" : new String()))));
        return strResult;
    }

    public static String getConnectionString(String driver, String database) {
        String strResult;
        if (driver == null || database == null) {
            throw new IllegalArgumentException("Parameters 'driver' and 'database' cannot be null.");
        }
        if (!database.startsWith("jdbc")) {
            strResult = JDBC.getConnectionString(driver);
            strResult = strResult + '@';
        } else {
            strResult = database;
        }
        return strResult;
    }

    public static String getDriverString(String database) {
        if (database == null) {
            throw new IllegalArgumentException("Parameter 'database' cannot be null.");
        }
        for (Map.Entry entry : driverClasses.entrySet()) {
            String name = (String)entry.getKey();
            if (database.indexOf(name) == -1) continue;
            return (String)entry.getValue();
        }
        return database;
    }

    public static void loadDriver(String database) throws ClassNotFoundException {
        if (database == null) {
            throw new IllegalArgumentException("Parameter 'driver' cannot be null.");
        }
        String driverClassName = JDBC.getDriverString(database);
        Class.forName(driverClassName);
    }

    public static void printSQLException(SQLException e) {
        if (e == null) {
            throw new IllegalArgumentException("Parameter cannot be null.");
        }
        JDBC.printSQLException(e, new PrintWriter(System.out, true));
    }

    public static void printSQLException(SQLException e, PrintWriter out) {
        if (e == null || out == null) {
            throw new IllegalArgumentException("Parameter cannot be null.");
        }
        do {
            out.println("Error: " + e.getErrorCode() + ": " + e);
        } while ((e = e.getNextException()) != null);
    }

    public static String toName(int database) {
        if (database < 1 || database >= typeToNames.length) {
            return null;
        }
        return typeToNames[database];
    }

    public static String toName(String database) {
        if (database == null) {
            throw new IllegalArgumentException("Parameter 'database' cannot be null.");
        }
        database = database.toLowerCase();
        for (int i = typeToNames.length - 1; i > 0; --i) {
            String name = typeToNames[i];
            if (database.indexOf(name) == -1) continue;
            return name;
        }
        return null;
    }

    public static int toType(String database) {
        if (database == null) {
            throw new IllegalArgumentException("Parameter 'database' cannot be null.");
        }
        database = database.toLowerCase();
        for (int i = typeToNames.length - 1; i > 0; --i) {
            if (database.indexOf(typeToNames[i]) == -1) continue;
            return i;
        }
        return -1;
    }

    static {
        driverClasses.put(CLOUDSCAPE_NAME, "COM.cloudscape.core.JDBCDriver");
        driverClasses.put(INSTANTDB_NAME, "com.lutris.instantdb.jdbc.idbDriver");
        driverClasses.put(ORACLE_NAME, "oracle.jdbc.driver.OracleDriver");
        driverClasses.put(PGSQL_NAME, "org.postgresql.Driver");
        driverClasses.put(ORACLE_THIN_NAME, "oracle.jdbc.driver.OracleDriver");
        driverClasses.put(COVLOG_NAME, "org.hyperic.util.jdbc.log.LoggerDriver");
        driverClasses.put(POINTBASE_NAME, "com.pointbase.jdbc.jdbcUniversalDriver");
        driverClasses.put(MYSQL_NAME, "com.mysql.jdbc.Driver");
        typeToNames = new String[driverClasses.size() + 1];
        JDBC.typeToNames[1] = CLOUDSCAPE_NAME;
        JDBC.typeToNames[2] = INSTANTDB_NAME;
        JDBC.typeToNames[3] = ORACLE_NAME;
        JDBC.typeToNames[4] = PGSQL_NAME;
        JDBC.typeToNames[5] = ORACLE_THIN_NAME;
        JDBC.typeToNames[6] = COVLOG_NAME;
        JDBC.typeToNames[7] = POINTBASE_NAME;
        JDBC.typeToNames[8] = MYSQL_NAME;
    }
}

