/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.pager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class PageList<T>
extends ArrayList<T>
implements Serializable {
    private int totalSize = 0;
    private boolean isUnbounded;
    private Serializable metaData;

    public PageList() {
        this.isUnbounded = false;
    }

    public PageList(Collection<T> c, int totalSize) {
        super(c);
        this.totalSize = totalSize;
        this.isUnbounded = false;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer("{").append("totalSize=").append(this.totalSize).append(" ").append("}");
        return super.toString() + s.toString();
    }

    public int getTotalSize() {
        return Math.max(this.size(), this.totalSize);
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public void setMetaData(Serializable metaData) {
        this.metaData = metaData;
    }

    public Serializable getMetaData() {
        return this.metaData;
    }

    public boolean isUnbounded() {
        return this.isUnbounded;
    }

    public void setUnbounded(boolean isUnbounded) {
        this.isUnbounded = isUnbounded;
    }
}

