/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.stats;

import java.util.Iterator;
import java.util.LinkedList;
import org.hyperic.util.stats.DataPoint;

public class TimeWindowCollector {
    private final LinkedList _dataPoints = new LinkedList();
    private final long _windowSize;
    private boolean _hasRolled = false;

    public TimeWindowCollector(long windowSize) {
        this._windowSize = windowSize;
    }

    public void addPoint(long time, double value) {
        this.addPoint(new DataPoint(time, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(DataPoint pt) {
        LinkedList linkedList = this._dataPoints;
        synchronized (linkedList) {
            this._dataPoints.add(pt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRolled() {
        LinkedList linkedList = this._dataPoints;
        synchronized (linkedList) {
            return this._hasRolled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSum() {
        double res = 0.0;
        LinkedList linkedList = this._dataPoints;
        synchronized (linkedList) {
            for (DataPoint pt : this._dataPoints) {
                res += pt.getValue();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldPoints() {
        LinkedList linkedList = this._dataPoints;
        synchronized (linkedList) {
            if (this._dataPoints.isEmpty()) {
                return;
            }
            DataPoint last = (DataPoint)this._dataPoints.getLast();
            this.removeOldPoints(last.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldPoints(long currentTime) {
        long oldestTimeAllowed = currentTime - this._windowSize;
        LinkedList linkedList = this._dataPoints;
        synchronized (linkedList) {
            DataPoint pt;
            Iterator i = this._dataPoints.iterator();
            while (i.hasNext() && (pt = (DataPoint)i.next()).getTime() < oldestTimeAllowed) {
                i.remove();
                this._hasRolled = true;
            }
        }
    }
}

