/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.JarSigningData;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.Resource;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.SyncFileAccess;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SignatureException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;
import sun.security.pkcs.ParsingException;

public class CacheEntry
implements Resource {
    private static final String ABSOLUTE_PATH_ESCAPE_CHAR = "\t";
    public static final int INCOMPLETE_FALSE = 0;
    public static final int INCOMPLETE_TRUE = 1;
    public static final int INCOMPLETE_ONHOLD = 2;
    public static final int BUSY_FALSE = 0;
    public static final int BUSY_TRUE = 1;
    private File indexFile = null;
    private SyncFileAccess indexFileSyncAccess = null;
    private File tempDataFile = null;
    private int busy = 1;
    private int incomplete = 0;
    private int forceUpdate = 0;
    private int cacheVersion = Cache.getCacheVersion();
    private int contentLength = 0;
    private int isShortcutImage = 0;
    private int isProxiedHost = 0;
    private long lastModified = 0L;
    private long expirationDate = 0L;
    private String version = null;
    private String url = "";
    private String namespaceID = "";
    private MessageHeader headerFields = new MessageHeader();
    private String filename = null;
    private String codebaseIP = null;
    Map checkedJars = null;
    private boolean hasOnlySignedEntries = false;
    private boolean hasSingleCodeSource = false;
    private boolean hasMissingSignedEntries = false;
    private static final int section1Length = 128;
    private int section2Length = 0;
    private int section3Length = 0;
    private int section4Length = 0;
    private int section4CertsLength = 0;
    private int section4SignersLength = 0;
    private int section4Pre15Length = 0;
    private int section5Length = 0;
    private int reducedManifestLength = 0;
    private int reducedManifest2Length = 0;
    private SoftReference<JarSigningData> signingDataRef = new SoftReference<Object>(null);
    private WeakReference jarRef = new WeakReference<Object>(null);
    private static boolean enhancedJarAccess = false;
    private static SessionSigningDataStorage sessionSigningDataStorage;
    private volatile URL _url;

    static boolean hasEnhancedJarAccess() {
        return enhancedJarAccess;
    }

    boolean hasSigningInfo() {
        return this.section4Length > 15;
    }

    private void invalidateEntryDueToException(Throwable throwable) {
        Trace.println("Invalidating entry url=" + this.url + " file=" + this.indexFile.getAbsolutePath());
        Trace.ignored(throwable);
        this.invalidateEntry();
    }

    private void invalidateEntry() {
        this.setIncomplete(1);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    void markIncompleteOnHold() {
        this.setBusy(1);
        this.invalidateEntry();
        this.setIncomplete(2);
    }

    public CacheEntry(File file) {
        this(file, false);
    }

    CacheEntry(File file, final boolean bl) {
        String string = file.getPath();
        this.filename = string.substring(0, string.length() - 4);
        this.indexFile = file;
        this.indexFileSyncAccess = new SyncFileAccess(this.indexFile);
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    CacheEntry.this.readIndexFile(bl);
                }
                catch (Throwable throwable) {
                    CacheEntry.this.invalidateEntryDueToException(throwable);
                }
                return null;
            }
        });
    }

    synchronized void generateShortcutImage() throws IOException {
        if (this.getIsShortcutImage() == 0) {
            this.setIsShortcutImage(1);
            this.updateIndexHeaderOnDisk();
        }
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return principal2.equals(principal = x509Certificate2.getSubjectDN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile openLockIndexFile(String string, boolean bl) throws IOException {
        SyncFileAccess.RandomAccessFileLock randomAccessFileLock = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFileLock = this.indexFileSyncAccess.openLockRandomAccessFile(string, 10000, bl);
            randomAccessFile = randomAccessFileLock != null ? randomAccessFileLock.getRandomAccessFile() : new RandomAccessFile(this.indexFile, string);
            RandomAccessFile randomAccessFile2 = randomAccessFile;
            return randomAccessFile2;
        }
        finally {
            if (randomAccessFileLock != null) {
                randomAccessFileLock.release();
            }
        }
    }

    private void readIndexFileOld(DataInputStream dataInputStream, RandomAccessFile randomAccessFile) throws IOException {
        if (!this.indexFile.exists()) {
            return;
        }
        switch (this.getCacheVersion()) {
            case 603: 
            case 604: {
                this.readSection1Remaining604(dataInputStream);
                this.readSection2(randomAccessFile);
                return;
            }
            case 605: {
                randomAccessFile.close();
                randomAccessFile = null;
                this.readIndexFile();
                return;
            }
            case 602: {
                this.readIndexFile602(randomAccessFile);
            }
        }
    }

    private void readIndexFile() {
        this.readIndexFile(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndexFile(boolean bl) {
        RandomAccessFile randomAccessFile = null;
        IOException iOException = null;
        try {
            if (this.indexFile.exists()) {
                randomAccessFile = this.openLockIndexFile("r", false);
                byte[] byArray = new byte[128];
                int n = randomAccessFile.read(byArray);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, 0, n));
                this.setBusy(dataInputStream.readByte());
                int n2 = dataInputStream.readByte();
                if (bl && n2 == 1) {
                    n2 = 2;
                }
                this.setIncomplete(n2);
                if (this.isIncomplete()) {
                    return;
                }
                this.setCacheVersion(dataInputStream.readInt());
                if (this.getCacheVersion() != Cache.getCacheVersion()) {
                    Trace.println("In-place upgrading old version " + this.getCacheVersion() + " file: " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
                    this.readIndexFileOld(dataInputStream, randomAccessFile);
                    randomAccessFile.close();
                    randomAccessFile = null;
                    this.saveUpgrade();
                    return;
                }
                this.readSection1Remaining(dataInputStream);
                this.readSection2(randomAccessFile);
                File file = new File(this.getResourceFilename());
                if (!this.isRedirectEntry() && !file.exists()) {
                    this.setIncomplete(1);
                    return;
                }
                if (this.hasSigningInfo() && this.section4Pre15Length == 0 && enhancedJarAccess && (!Cache.isSystemCacheEntry(this) || Environment.isSystemCacheMode())) {
                    randomAccessFile.close();
                    randomAccessFile = null;
                    this.saveUpgrade();
                    Trace.println("readIndexFile returning success", TraceLevel.CACHE);
                }
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException3) {
                Trace.ignoredException(iOException3);
            }
        }
        if (iOException != null) {
            this.invalidateEntryDueToException(iOException);
        }
    }

    void processRedirectData(URL uRL, CacheEntry cacheEntry) throws IOException {
        this.setBusy(0);
        this.setIncomplete(0);
        this.setURL(uRL.toString());
        this.setLastModified(cacheEntry.getLastModified());
        this.setExpirationDate(cacheEntry.getExpirationDate());
        this.setVersion(cacheEntry.getVersion());
        this.headerFields = new MessageHeader();
        this.headerFields.add(null, String.valueOf(302));
        this.headerFields.add("Location", cacheEntry.getURL().toString());
        this.setHeaders(this.headerFields);
        this.writeFileToDisk();
    }

    public synchronized void setBusy(int n) {
        this.busy = n;
    }

    synchronized int getBusy() {
        return this.busy;
    }

    private void setCacheVersion(int n) {
        this.cacheVersion = n;
    }

    int getCacheVersion() {
        return this.cacheVersion;
    }

    public synchronized void setIncomplete(int n) {
        this.incomplete = n;
    }

    public synchronized int getIncomplete() {
        return this.incomplete;
    }

    boolean isIncomplete() {
        return this.getIncomplete() == 1;
    }

    public synchronized boolean isValidEntry() {
        return this.busy == 0 && this.incomplete == 0;
    }

    synchronized boolean storageFilesExist() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (CacheEntry.this.filename != null && new File(CacheEntry.this.filename).exists() && CacheEntry.this.indexFile != null && CacheEntry.this.indexFile.exists()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    public synchronized void setIsShortcutImage(int n) {
        this.isShortcutImage = n;
    }

    public synchronized int getIsShortcutImage() {
        return this.isShortcutImage;
    }

    public synchronized void setIsProxied(int n) {
        this.isProxiedHost = n;
    }

    public synchronized int getIsProxied() {
        return this.isProxiedHost;
    }

    synchronized boolean removeBefore(CacheEntry cacheEntry) {
        long l;
        long l2;
        if (this.isIncomplete()) {
            return true;
        }
        if (cacheEntry.isIncomplete()) {
            return false;
        }
        long l3 = this.getIndexFile().lastModified();
        if (l3 < (l2 = cacheEntry.getIndexFile().lastModified())) {
            return true;
        }
        if (l3 > l2) {
            return false;
        }
        long l4 = System.currentTimeMillis();
        long l5 = this.getExpirationDate();
        if (l5 != (l = cacheEntry.getExpirationDate())) {
            if (l5 < l4) {
                return true;
            }
            if (l < l4) {
                return false;
            }
        }
        return this.getContentLength() >= cacheEntry.getContentLength();
    }

    synchronized void setContentLength(int n) {
        this.contentLength = n;
    }

    public synchronized int getContentLength() {
        return this.contentLength;
    }

    synchronized JarSigningData getJarSigningData() {
        if (this.signingDataRef == null) {
            return null;
        }
        JarSigningData jarSigningData = this.signingDataRef.get();
        if (jarSigningData == null) {
            try {
                jarSigningData = sessionSigningDataStorage.get(new URL(this.url), this.version, this);
                if (jarSigningData != null) {
                    return jarSigningData;
                }
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
            }
            try {
                jarSigningData = AccessController.doPrivileged(new PrivilegedExceptionAction<JarSigningData>(){

                    @Override
                    public JarSigningData run() throws IOException, JARSigningException {
                        Object object;
                        Object object2;
                        URL uRL = new URL(CacheEntry.this.url);
                        File file = new File(CacheEntry.this.filename);
                        JarVerifier jarVerifier = JarVerifier.create(uRL, CacheEntry.this.version, file, null);
                        jarVerifier.validate(null);
                        CacheEntry.this.hasOnlySignedEntries = jarVerifier.hasOnlySignedEntries();
                        CacheEntry.this.hasSingleCodeSource = jarVerifier.hasSingleCodeSource();
                        CacheEntry.this.hasMissingSignedEntries = jarVerifier.hasMissingSignedEntries();
                        if (!jarVerifier.getSignerCerts().isEmpty() && CacheEntry.this.hasStrictSingleSigning()) {
                            object2 = jarVerifier.getSignerMapCert();
                            object2.clear();
                            object2.put(null, jarVerifier.getSingleSignerIndicesCert());
                        }
                        if (!(object2 = jarVerifier.getSignersCS()).isEmpty() && CacheEntry.this.hasStrictSingleSigning()) {
                            object = jarVerifier.getSignerMap();
                            object.clear();
                            object.put(null, jarVerifier.getSingleSignerIndicesCS());
                        }
                        object = JarSigningData.create(jarVerifier);
                        CacheEntry.this.signingDataRef = new SoftReference<Object>(object);
                        sessionSigningDataStorage.put(CacheEntry.this);
                        return object;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Trace.ignoredException(privilegedActionException.getException());
                this.invalidateEntryDueToException(privilegedActionException.getException());
                this.signingDataRef = null;
            }
        }
        return jarSigningData;
    }

    synchronized boolean hasStrictSingleSigning() {
        return this.hasOnlySignedEntries && this.hasSingleCodeSource && !this.hasMissingSignedEntries;
    }

    public synchronized Certificate[] getCertificates() {
        JarSigningData jarSigningData = this.getJarSigningData();
        return jarSigningData != null ? jarSigningData.getCertificates() : null;
    }

    public synchronized CodeSigner[] getCodeSigners() {
        JarSigningData jarSigningData = this.getJarSigningData();
        return jarSigningData != null ? jarSigningData.getCodeSigners() : null;
    }

    synchronized void setLastModified(long l) {
        this.lastModified = l;
    }

    public synchronized long getLastModified() {
        return this.lastModified;
    }

    synchronized void setExpirationDate(long l) {
        this.expirationDate = l;
    }

    synchronized void updateExpirationInIndexFile(long l) {
        if (this.getExpirationDate() == l) {
            return;
        }
        this.setExpirationDate(l);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    public synchronized long getExpirationDate() {
        return this.expirationDate;
    }

    synchronized boolean isExpired() {
        return this.expirationDate == 0L || System.currentTimeMillis() >= this.expirationDate;
    }

    synchronized void setURL(String string) {
        this.url = string;
    }

    public synchronized String getURL() {
        return this.url;
    }

    synchronized void setVersion(String string) {
        this.version = string == null || string.equals("") ? null : string;
    }

    public synchronized String getVersion() {
        return this.version;
    }

    private void setNamespaceID(String string) {
        this.namespaceID = string;
    }

    private String getNamespaceID() {
        return this.namespaceID;
    }

    synchronized JarFile getRefJar() {
        Object t;
        if (this.jarRef != null && (t = this.jarRef.get()) instanceof JarFile) {
            return (JarFile)t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarFile getJarFile() {
        if (this.isRedirectEntry()) {
            return null;
        }
        JarFile jarFile = null;
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            Object t;
            if (this.jarRef != null && (t = this.jarRef.get()) instanceof JarFile) {
                return (JarFile)t;
            }
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return new CachedJarFile(CacheEntry.this);
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                        return null;
                    }
                }
            });
            this.jarRef = new WeakReference<JarFile>(jarFile);
        }
        MemoryCache.addResourceReference(jarFile, this.url);
        return jarFile;
    }

    public synchronized String getResourceFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDataFile() {
        File file = null;
        CacheEntry cacheEntry = this;
        synchronized (cacheEntry) {
            if (!this.isRedirectEntry() && this.filename != null && !this.url.equals("")) {
                file = new File(this.filename);
            }
        }
        if (file != null) {
            MemoryCache.addResourceReference(file, this.url);
        }
        return file;
    }

    synchronized File getTempDataFile() {
        return this.tempDataFile;
    }

    public synchronized File getIndexFile() {
        return this.indexFile;
    }

    public synchronized long getSize() {
        long l = 0L;
        if (this.getDataFile() != null) {
            l += this.getDataFile().length();
        }
        if (this.getIndexFile() != null) {
            l += this.getIndexFile().length();
        }
        return l;
    }

    synchronized void setHeaders(MessageHeader messageHeader) {
        this.headerFields = messageHeader;
    }

    MessageHeader cloneHeaders() {
        return new MessageHeader(this.headerFields);
    }

    public synchronized Map getHeaders() {
        return this.headerFields.getHeaders();
    }

    public synchronized boolean isHttpNoCacheEnabled() {
        String string = this.headerFields.getValue(this.headerFields.getKey("cache-control"));
        if (string != null && string.equals("no-cache")) {
            return true;
        }
        String string2 = this.headerFields.getValue(this.headerFields.getKey("pragma"));
        return string2 != null && string2.equals("no-cache");
    }

    synchronized boolean processTempDataFile(boolean bl, DownloadDelegate downloadDelegate, URL uRL, URL uRL2, String string) {
        boolean bl2 = false;
        if (bl) {
            String string2 = null;
            String string3 = uRL2.getQuery().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "&");
            String string4 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                if (!string4.startsWith("current-version-id")) continue;
                string2 = string4.substring("current-version-id".length() + 1);
                break;
            }
            CacheEntry cacheEntry = null;
            cacheEntry = Cache.getCacheEntry(uRL, string2);
            File file = null;
            if (cacheEntry != null) {
                file = new File(cacheEntry.getResourceFilename());
            }
            File file2 = null;
            try {
                if (Trace.isEnabled(TraceLevel.NETWORK)) {
                    Trace.println(ResourceManager.getString("cacheEntry.applyJarDiff", uRL == null ? "" : uRL.toString(), string2, string), TraceLevel.NETWORK);
                }
                file2 = DownloadEngine.applyPatch(file, this.tempDataFile, uRL, string, downloadDelegate, this.filename);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            if (Platform.get().isNativeSandbox()) {
                Platform.get().getNativeSandboxBroker().deleteFile(this.tempDataFile);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        CacheEntry.this.tempDataFile.delete();
                        return null;
                    }
                });
            }
            if (file2 != null) {
                bl2 = true;
            }
        }
        if (Platform.get().getNativeSandboxBroker().renameFile(this.tempDataFile, this.filename)) {
            bl2 = true;
        }
        return bl2;
    }

    public synchronized Manifest getManifest() {
        try {
            JarFile jarFile = this.getJarFile();
            return jarFile != null ? jarFile.getManifest() : null;
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
            this.invalidateEntryDueToException(iOException);
            return null;
        }
    }

    private synchronized void setCodebaseIP(String string) {
        this.codebaseIP = string;
    }

    public synchronized String getCodebaseIP() {
        return this.codebaseIP;
    }

    void writeFileToDisk() throws IOException {
        this.writeFileToDisk(1, null);
    }

    public synchronized boolean isJarFile() {
        Map map = this.headerFields != null ? this.headerFields.getHeaders() : Collections.EMPTY_MAP;
        return HttpUtils.isJarFile(this.url, map);
    }

    public synchronized boolean isJNLPFile() {
        Map map = this.headerFields != null ? this.headerFields.getHeaders() : Collections.EMPTY_MAP;
        return HttpUtils.isJNLPFile(this.url, map);
    }

    public synchronized void updateIndexHeaderOnDisk() throws IOException {
        block4: {
            if (Platform.get().isNativeSandbox()) {
                this.doUpdateHeader(null);
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            if (CacheEntry.this.indexFile != null && CacheEntry.this.indexFile.exists()) {
                                RandomAccessFile randomAccessFile = null;
                                try {
                                    randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                                    CacheEntry.this.doUpdateHeader(randomAccessFile);
                                }
                                finally {
                                    if (randomAccessFile != null) {
                                        randomAccessFile.close();
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!(privilegedActionException.getException() instanceof IOException)) break block4;
                    throw (IOException)privilegedActionException.getException();
                }
            }
        }
    }

    private int doUpdateHeader(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = this.prepareHeader();
        Platform.get().getNativeSandboxBroker().writeFile(randomAccessFile, this.indexFile, 0L, byArray);
        return byArray.length;
    }

    private byte[] prepareHeader() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(this.busy);
        dataOutputStream.writeByte(this.incomplete);
        dataOutputStream.writeInt(this.cacheVersion);
        dataOutputStream.writeByte(this.isShortcutImage);
        dataOutputStream.writeInt(this.contentLength);
        dataOutputStream.writeLong(this.lastModified);
        dataOutputStream.writeLong(this.expirationDate);
        dataOutputStream.writeLong(0L);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeInt(this.section2Length);
        dataOutputStream.writeInt(this.section3Length);
        dataOutputStream.writeInt(this.section4Length);
        dataOutputStream.writeInt(this.section5Length);
        dataOutputStream.writeLong(0L);
        dataOutputStream.writeLong(0L);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeInt(this.reducedManifestLength);
        dataOutputStream.writeInt(this.section4Pre15Length);
        dataOutputStream.writeByte(this.hasOnlySignedEntries ? 1 : 0);
        dataOutputStream.writeByte(this.hasSingleCodeSource ? 1 : 0);
        dataOutputStream.writeInt(this.section4CertsLength);
        dataOutputStream.writeInt(this.section4SignersLength);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeLong(0L);
        dataOutputStream.writeInt(this.reducedManifest2Length);
        dataOutputStream.writeByte(this.isProxiedHost);
        dataOutputStream.flush();
        if (byteArrayOutputStream.size() < 128) {
            byte[] byArray = new byte[128 - byteArrayOutputStream.size()];
            dataOutputStream.write(byArray);
        } else {
            Trace.println("Incorrect header size: " + byteArrayOutputStream.size(), TraceLevel.CACHE);
        }
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    synchronized void writeFileToDisk(int n, DownloadDelegate downloadDelegate) throws IOException {
        this.writeFileToDisk(n, downloadDelegate, true);
    }

    synchronized void writeFileToDisk(final int n, final DownloadDelegate downloadDelegate, final boolean bl) throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        ZipFile zipFile = null;
                        RandomAccessFile randomAccessFile = null;
                        CacheEntry.this.section2Length = 0;
                        CacheEntry.this.section3Length = 0;
                        CacheEntry.this.section4Length = 0;
                        CacheEntry.this.section4Pre15Length = 0;
                        CacheEntry.this.section4CertsLength = 0;
                        CacheEntry.this.section4SignersLength = 0;
                        CacheEntry.this.section5Length = 0;
                        CacheEntry.this.reducedManifestLength = 0;
                        CacheEntry.this.reducedManifest2Length = 0;
                        try {
                            URL uRL;
                            String string;
                            if (!Platform.get().isNativeSandbox()) {
                                randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                            }
                            int n2 = CacheEntry.this.doUpdateHeader(randomAccessFile);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                            dataOutputStream.writeUTF(CacheEntry.this.getVersion() != null ? CacheEntry.this.getVersion() : "");
                            dataOutputStream.writeUTF(CacheEntry.this.getURL());
                            dataOutputStream.writeUTF(CacheEntry.this.getNamespaceID());
                            InetAddress inetAddress = null;
                            String string2 = "";
                            if (CacheEntry.this.url != null && !CacheEntry.this.url.equals("") && (inetAddress = Cache.getHostIP(string = (uRL = new URL(CacheEntry.this.url)).getHost())) != null) {
                                string2 = inetAddress.getHostAddress();
                            }
                            dataOutputStream.writeUTF(string2);
                            CacheEntry.this.writeHeaders(dataOutputStream);
                            dataOutputStream.close();
                            byteArrayOutputStream.close();
                            CacheEntry.this.section2Length = byteArrayOutputStream.size();
                            Platform.get().getNativeSandboxBroker().writeFile(randomAccessFile, CacheEntry.this.indexFile, (long)n2, byteArrayOutputStream.toByteArray());
                            if (CacheEntry.this.incomplete == 0) {
                                if (CacheEntry.this.isJarFile() && !CacheEntry.this.hasCompressEncoding() && !CacheEntry.this.isRedirectEntry()) {
                                    CacheEntry.this.processJar(randomAccessFile, n2 + byteArrayOutputStream.size(), n, downloadDelegate);
                                }
                                if (bl) {
                                    UpdateTracker.checkDone(CacheEntry.this.url);
                                }
                                Cache.addToCleanupThreadLoadedResourceList(CacheEntry.this.url);
                                CacheEntry.this.setBusy(0);
                                CacheEntry.this.setIncomplete(0);
                                CacheEntry.this.doUpdateHeader(randomAccessFile);
                            }
                        }
                        catch (Exception exception) {
                            Trace.ignoredException(exception);
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                                randomAccessFile = null;
                            }
                            if (zipFile != null) {
                                zipFile.close();
                                zipFile = null;
                            }
                            Cache.removeCacheEntry(CacheEntry.this);
                            if (exception instanceof JARSigningException) {
                                throw (JARSigningException)exception;
                            }
                            if (exception instanceof ZipException) {
                                throw new JARSigningException(new URL(CacheEntry.this.url), CacheEntry.this.version, 2, exception);
                            }
                            throw new IOException(exception.getMessage());
                        }
                        finally {
                            if (randomAccessFile != null) {
                                randomAccessFile.close();
                            }
                            if (zipFile != null) {
                                zipFile.close();
                            }
                            Cache.cleanup();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    boolean isRedirectEntry() {
        return this.getRedirectFinalURL() != null;
    }

    public URL getRedirectFinalURL() {
        String string;
        Map map = this.getHeaders();
        List list = map == null ? null : (List)map.get("Location");
        String string2 = string = list == null || list.size() < 1 ? null : (String)list.get(0);
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
            }
        }
        return null;
    }

    private byte[] readBlock(final int n, final int n2) throws IOException {
        try {
            return (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("r", false);
                    try {
                        randomAccessFile.seek(n);
                        Object var2_2 = null;
                        byte[] byArray = new byte[n2];
                        randomAccessFile.readFully(byArray);
                        byte[] byArray2 = byArray;
                        return byArray2;
                    }
                    finally {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            return null;
        }
    }

    synchronized byte[] getFullManifestBytes() throws IOException {
        if (this.reducedManifest2Length > 0) {
            int n = 128 + this.section2Length;
            int n2 = this.section3Length - this.reducedManifest2Length;
            return this.readBlock(n, n2);
        }
        if (this.reducedManifestLength > 0) {
            int n = 128 + this.section2Length + this.reducedManifestLength;
            int n3 = this.section3Length - this.reducedManifestLength;
            return this.readBlock(n, n3);
        }
        return null;
    }

    private static String asString(Certificate[] certificateArray) {
        if (certificateArray != null) {
            return Arrays.asList(certificateArray).toString();
        }
        return "null";
    }

    private CodeSigner[] convertCertArrayToSignerArray(Certificate[] certificateArray) throws IOException {
        try {
            int n;
            CodeSigner[] codeSignerArray;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<CertPath> arrayList = new ArrayList<CertPath>();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < certificateArray.length) {
                Serializable serializable;
                codeSignerArray = new ArrayList();
                n = n3;
                for (n = n3; n < certificateArray.length; ++n) {
                    serializable = null;
                    Serializable serializable2 = null;
                    if (certificateArray[n] instanceof X509Certificate) {
                        serializable = (X509Certificate)certificateArray[n];
                    }
                    serializable2 = n + 1 < certificateArray.length && certificateArray[n + 1] instanceof X509Certificate ? (X509Certificate)certificateArray[n + 1] : serializable;
                    codeSignerArray.add(serializable);
                    if (!CacheEntry.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                }
                n4 = n < certificateArray.length ? n + 1 : n;
                serializable = certificateFactory.generateCertPath((List<? extends Certificate>)codeSignerArray);
                codeSignerArray.clear();
                arrayList.add((CertPath)serializable);
                n3 = n4;
                ++n2;
            }
            codeSignerArray = new CodeSigner[n2];
            for (n = 0; n < n2; ++n) {
                codeSignerArray[n] = new CodeSigner((CertPath)arrayList.get(n), null);
            }
            return codeSignerArray;
        }
        catch (CertificateException certificateException) {
            throw new IOException("Error process signer certificates");
        }
    }

    private CodeSigner newCodeSigner(CodeSigner codeSigner) {
        CertPath certPath = codeSigner.getSignerCertPath();
        Timestamp timestamp = codeSigner.getTimestamp();
        CodeSigner codeSigner2 = new CodeSigner(certPath, this.newTimestamp(timestamp));
        return codeSigner2;
    }

    private Timestamp newTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Date date = timestamp.getTimestamp();
        CertPath certPath = timestamp.getSignerCertPath();
        return new Timestamp(date, certPath);
    }

    public String getNativeLibPath() {
        return this.getResourceFilename() + "-n";
    }

    private void processJar(RandomAccessFile randomAccessFile, int n, int n2, DownloadDelegate downloadDelegate) throws IOException, ParsingException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        URL uRL = new URL(this.url);
        File file = new File(this.filename);
        File file2 = null;
        if (DownloadEngine.isNativeContentType(n2)) {
            file2 = new File(this.getNativeLibPath()).getCanonicalFile();
        }
        JarVerifier jarVerifier = JarVerifier.create(uRL, this.version, file, file2);
        jarVerifier.validate(downloadDelegate);
        this.hasOnlySignedEntries = jarVerifier.hasOnlySignedEntries();
        this.hasSingleCodeSource = jarVerifier.hasSingleCodeSource();
        this.hasMissingSignedEntries = jarVerifier.hasMissingSignedEntries();
        this.section3Length = 0;
        this.reducedManifest2Length = 0;
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(objectOutputStream));
        this.writeCertificates(jarVerifier, objectOutputStream, bufferedWriter, byteArrayOutputStream);
        this.writeSigners(jarVerifier, objectOutputStream, bufferedWriter, byteArrayOutputStream);
        this.signingDataRef = new SoftReference<JarSigningData>(JarSigningData.create(jarVerifier));
        sessionSigningDataStorage.put(this);
        Platform.get().getNativeSandboxBroker().writeFile(randomAccessFile, this.indexFile, (long)n, byteArrayOutputStream.toByteArray());
    }

    private void writeCertificates(JarVerifier jarVerifier, ObjectOutputStream objectOutputStream, BufferedWriter bufferedWriter, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        if (!jarVerifier.getSignerCerts().isEmpty()) {
            objectOutputStream.writeInt(jarVerifier.getSignerCerts().size());
            Iterator iterator = jarVerifier.getSignerCerts().iterator();
            while (iterator.hasNext()) {
                objectOutputStream.writeObject(iterator.next());
            }
            objectOutputStream.flush();
            this.section4CertsLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
            Map map = jarVerifier.getSignerMapCert();
            Iterator iterator2 = map.keySet().iterator();
            String string = null;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (string2 == null || string2.length() == 0) continue;
                int[] nArray = (int[])map.get(string2);
                if (string2.startsWith("/")) {
                    string2 = ABSOLUTE_PATH_ESCAPE_CHAR + string2;
                    string = null;
                } else {
                    int n = string2.lastIndexOf("/");
                    if (n > 0) {
                        String string3 = string2.substring(0, n);
                        if (string3.equals(string)) {
                            string2 = string2.substring(string3.length());
                        } else {
                            string = string3;
                        }
                    } else {
                        string = null;
                    }
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                String string4 = String.valueOf(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    string4 = string4 + " " + nArray[i];
                }
                bufferedWriter.write(string4, 0, string4.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.flush();
            if (this.hasStrictSingleSigning()) {
                map.clear();
                map.put(null, jarVerifier.getSingleSignerIndicesCert());
            }
        } else {
            objectOutputStream.writeInt(0);
            objectOutputStream.flush();
            this.section4CertsLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
        }
        objectOutputStream.flush();
        this.section4Pre15Length = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
    }

    private void writeSigners(JarVerifier jarVerifier, ObjectOutputStream objectOutputStream, BufferedWriter bufferedWriter, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        List list = jarVerifier.getSignersCS();
        if (!list.isEmpty()) {
            Integer n = new Integer(list.size());
            bufferedWriter.write(n.toString());
            bufferedWriter.newLine();
            bufferedWriter.flush();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                objectOutputStream.writeObject(iterator.next());
            }
            objectOutputStream.flush();
            this.section4SignersLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - (this.section3Length + this.section4Pre15Length);
            Map map = jarVerifier.getSignerMap();
            Iterator iterator2 = map.keySet().iterator();
            String string = null;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (string2 == null || string2.length() == 0) continue;
                int[] nArray = (int[])map.get(string2);
                if (string2.startsWith("/")) {
                    string2 = ABSOLUTE_PATH_ESCAPE_CHAR + string2;
                    string = null;
                } else {
                    int n2 = string2.lastIndexOf("/");
                    if (n2 > 0) {
                        String string3 = string2.substring(0, n2);
                        if (string3.equals(string)) {
                            string2 = string2.substring(n2);
                        } else {
                            string = string3;
                        }
                    } else {
                        string = null;
                    }
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                String string4 = String.valueOf(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    string4 = string4 + " " + nArray[i];
                }
                bufferedWriter.write(string4, 0, string4.length());
                bufferedWriter.newLine();
            }
            if (this.hasStrictSingleSigning()) {
                map.clear();
                map.put(null, jarVerifier.getSingleSignerIndicesCS());
            }
        } else {
            bufferedWriter.write("0");
            bufferedWriter.newLine();
            bufferedWriter.flush();
            objectOutputStream.flush();
            this.section4SignersLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - (this.section3Length + this.section4Pre15Length);
        }
        bufferedWriter.flush();
        objectOutputStream.flush();
        this.section4Length = byteArrayOutputStream.size() - this.section3Length;
    }

    private void readIndexFile602(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        randomAccessFile.readByte();
        randomAccessFile.readByte();
        randomAccessFile.readInt();
        randomAccessFile.read();
        randomAccessFile.read();
        this.setIsShortcutImage(randomAccessFile.read());
        this.setContentLength(randomAccessFile.readInt());
        this.setLastModified(randomAccessFile.readLong());
        this.setExpirationDate(randomAccessFile.readLong());
        this.setVersion(randomAccessFile.readUTF());
        this.setURL(randomAccessFile.readUTF());
        this.setNamespaceID(randomAccessFile.readUTF());
        File file = new File(this.getResourceFilename());
        if (!this.isRedirectEntry() && !file.exists()) {
            this.invalidateEntry();
        }
        if (!this.isIncomplete()) {
            this.readHeaders602(randomAccessFile);
        }
    }

    private void readHeaders602(RandomAccessFile randomAccessFile) throws IOException {
        for (int i = randomAccessFile.readInt(); i > 0; --i) {
            String string = randomAccessFile.readUTF();
            if (string.equals("deploy_resource_codebase_ip")) {
                this.setCodebaseIP(randomAccessFile.readUTF());
                continue;
            }
            if (string.equals("<null>")) {
                string = null;
            }
            this.headerFields.add(string, randomAccessFile.readUTF());
        }
    }

    private void readHeaders(DataInputStream dataInputStream) throws IOException {
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            String string = dataInputStream.readUTF();
            if (string.equals("<null>")) {
                string = null;
            }
            this.headerFields.add(string, dataInputStream.readUTF());
        }
    }

    private void writeHeaders(DataOutputStream dataOutputStream) throws IOException {
        if (this.headerFields == null) {
            dataOutputStream.writeInt(0);
            return;
        }
        Map map = this.headerFields.getHeaders();
        if (!map.isEmpty()) {
            dataOutputStream.writeInt(map.size());
            for (int i = 0; i < map.size(); ++i) {
                String string;
                String string2 = this.headerFields.getKey(i);
                if (null == string2) {
                    string2 = "<null>";
                }
                if ((string = this.headerFields.getValue(i)) == null) {
                    if (!Cache.DEBUG) continue;
                    Trace.print("Header field '" + string2 + "' null, skip.");
                    continue;
                }
                dataOutputStream.writeUTF(string2);
                dataOutputStream.writeUTF(string);
            }
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    private String printManifest() {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Attributes attributes = manifest.getMainAttributes();
            for (Object object : attributes.keySet()) {
                stringBuffer.append("key: " + object);
                stringBuffer.append(" value: " + attributes.get(object) + "\n");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String toString() {
        return "URL: " + this.url + " | " + this.indexFile;
    }

    public String dumpToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----Cache Entry------\n");
        stringBuffer.append("busy: " + this.getBusy() + "\n");
        stringBuffer.append("incomplete: " + this.getIncomplete() + "\n");
        stringBuffer.append("cacheVersion: " + this.getCacheVersion() + "\n");
        stringBuffer.append("contentLength: " + this.getContentLength() + "\n");
        long l = this.getLastModified();
        stringBuffer.append("lastModified: " + l + " [" + new Date(l).toString() + "]\n");
        stringBuffer.append("expirationDate: " + this.getExpirationDate() + "\n");
        stringBuffer.append("version: " + this.getVersion() + "\n");
        stringBuffer.append("URL: " + this.url + "\n");
        stringBuffer.append("NamespaceID: " + this.getNamespaceID() + "\n");
        stringBuffer.append("HTTP/HTTPS Header: " + this.getHeaders() + "\n");
        if (this.getManifest() != null) {
            stringBuffer.append("Jar-Manifest Main Attributes:\n");
            stringBuffer.append(this.printManifest());
            stringBuffer.append("----------------------\n");
        }
        return stringBuffer.toString();
    }

    public boolean hasCompressEncoding() {
        return HttpUtils.hasGzipOrPack200Encoding(this.getHeaders());
    }

    boolean matchesVersionString(String string, boolean bl) {
        return CacheEntry.matchesVersionString(this, string, bl);
    }

    static boolean matchesVersionString(Resource resource, String string, boolean bl) {
        if (resource.getVersion() == null && string == null) {
            return true;
        }
        VersionString versionString = new VersionString(string);
        if (bl && !versionString.isSimpleVersion()) {
            return false;
        }
        return versionString.contains(resource.getVersion());
    }

    public boolean isSameEntry(CacheEntry cacheEntry) {
        return cacheEntry != null && this.getIndexFile().equals(cacheEntry.getIndexFile());
    }

    private void readSection2(RandomAccessFile randomAccessFile) throws IOException {
        if (this.section2Length > 0) {
            byte[] byArray = new byte[this.section2Length];
            randomAccessFile.read(byArray);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.setVersion(dataInputStream.readUTF());
            this.setURL(dataInputStream.readUTF());
            this.setNamespaceID(dataInputStream.readUTF());
            this.setCodebaseIP(dataInputStream.readUTF());
            this.readHeaders(dataInputStream);
        }
    }

    private void readSection1Remaining(DataInputStream dataInputStream) throws IOException {
        this.setIsShortcutImage(dataInputStream.readByte());
        this.setContentLength(dataInputStream.readInt());
        this.setLastModified(dataInputStream.readLong());
        this.setExpirationDate(dataInputStream.readLong());
        dataInputStream.readLong();
        dataInputStream.readByte();
        this.section2Length = dataInputStream.readInt();
        this.section3Length = dataInputStream.readInt();
        this.section4Length = dataInputStream.readInt();
        this.section5Length = dataInputStream.readInt();
        dataInputStream.readLong();
        dataInputStream.readLong();
        dataInputStream.readByte();
        this.reducedManifestLength = dataInputStream.readInt();
        this.section4Pre15Length = dataInputStream.readInt();
        dataInputStream.readByte();
        dataInputStream.readByte();
        this.section4CertsLength = dataInputStream.readInt();
        this.section4SignersLength = dataInputStream.readInt();
        dataInputStream.readByte();
        dataInputStream.readLong();
        this.reducedManifest2Length = dataInputStream.readInt();
        this.setIsProxied(dataInputStream.readByte());
        dataInputStream.close();
    }

    private void readSection1Remaining604(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readByte();
        dataInputStream.readByte();
        this.setIsShortcutImage(dataInputStream.readByte());
        this.setContentLength(dataInputStream.readInt());
        this.setLastModified(dataInputStream.readLong());
        this.setExpirationDate(dataInputStream.readLong());
        dataInputStream.readLong();
        dataInputStream.readByte();
        this.section2Length = dataInputStream.readInt();
        this.section3Length = dataInputStream.readInt();
        this.section4Length = dataInputStream.readInt();
        this.section5Length = dataInputStream.readInt();
        dataInputStream.readLong();
        dataInputStream.readLong();
        dataInputStream.readByte();
        this.reducedManifestLength = dataInputStream.readInt();
        this.section4Pre15Length = dataInputStream.readInt();
        dataInputStream.readByte();
        dataInputStream.readByte();
        this.section4CertsLength = dataInputStream.readInt();
        this.section4SignersLength = dataInputStream.readInt();
        dataInputStream.readByte();
        dataInputStream.readLong();
        this.reducedManifest2Length = dataInputStream.readInt();
    }

    private void saveUpgrade() throws IOException {
        Trace.println("Trying to update in place " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
        this.cacheVersion = Cache.getCacheVersion();
        boolean bl = this.isValidEntry();
        try {
            this.setBusy(1);
            this.updateIndexHeaderOnDisk();
            if (bl) {
                Trace.println("Upgrade writing to disk for " + this.getResourceFilename(), TraceLevel.CACHE);
                this.writeFileToDisk(1, null, false);
                Trace.println("Upgrade of entry done", TraceLevel.CACHE);
            } else {
                Trace.println("Upgrade of incomplete entry done", TraceLevel.CACHE);
            }
        }
        finally {
            this.setBusy(0);
        }
    }

    public int getState() {
        if (this.incomplete == 1 && this.busy == 0) {
            return 2;
        }
        if (this.incomplete == 0 && this.busy == 0) {
            return 1;
        }
        return 0;
    }

    private CodeSource createCodeSource(Certificate[] certificateArray) {
        if (this._url == null) {
            try {
                this._url = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new CodeSource(this._url, certificateArray);
    }

    private CodeSource createCodeSource(CodeSigner[] codeSignerArray) {
        if (this._url == null) {
            try {
                this._url = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new CodeSource(this._url, codeSignerArray);
    }

    static {
        try {
            JavaUtilJarAccess javaUtilJarAccess = SharedSecrets.javaUtilJarAccess();
            javaUtilJarAccess.setEagerValidation((JarFile)null, false);
            enhancedJarAccess = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (NullPointerException nullPointerException) {
            enhancedJarAccess = true;
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        sessionSigningDataStorage = new SessionSigningDataStorage();
    }

    private static class SessionSigningDataStorage
    implements SessionState.Client {
        private Map ceToFile = new ConcurrentHashMap();
        private File sessionFolder;
        private List cacheEntries = new ArrayList();
        private final String STORAGE_FILE_NAME = "SessionSigningDataStorage";

        public SessionSigningDataStorage() {
            SessionState.register(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void importState(File file) {
            ObjectInputStream objectInputStream = null;
            this.sessionFolder = file;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(this.sessionFolder, "SessionSigningDataStorage")));
                objectInputStream = new ObjectInputStream(bufferedInputStream);
                this.ceToFile = (Map)objectInputStream.readObject();
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void exportState(File file) {
            ObjectOutputStream objectOutputStream = null;
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(file, "SessionSigningDataStorage")));
                objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
                for (Object e : this.cacheEntries) {
                    try {
                        CacheEntry cacheEntry = (CacheEntry)e;
                        JarSigningData jarSigningData = cacheEntry.getJarSigningData();
                        if (jarSigningData == null) continue;
                        String string = UUID.randomUUID().toString();
                        File file2 = new File(file, string);
                        this.saveSigningData(cacheEntry, jarSigningData, new BufferedOutputStream(new FileOutputStream(file2)));
                        this.ceToFile.put(new Pair(new URL(cacheEntry.url), cacheEntry.version), string);
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                }
                objectOutputStream.writeObject(this.ceToFile);
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            finally {
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void saveSigningData(CacheEntry cacheEntry, JarSigningData jarSigningData, OutputStream outputStream) throws IOException {
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeBoolean(cacheEntry.hasOnlySignedEntries);
                objectOutputStream.writeBoolean(cacheEntry.hasSingleCodeSource);
                objectOutputStream.writeBoolean(cacheEntry.hasMissingSignedEntries);
                CodeSigner[] codeSignerArray = jarSigningData.getCodeSigners();
                if (codeSignerArray != null && codeSignerArray.length != 0) {
                    objectOutputStream.writeInt(codeSignerArray.length);
                    for (CodeSigner object : codeSignerArray) {
                        objectOutputStream.writeObject(object);
                    }
                    objectOutputStream.flush();
                    Map map = jarSigningData.getSignerMap();
                    Iterator iterator = map.keySet().iterator();
                    String string = null;
                    while (iterator.hasNext()) {
                        void var9_17;
                        String string2 = (String)iterator.next();
                        if (string2 == null || string2.length() == 0) continue;
                        int[] nArray = (int[])map.get(string2);
                        if (string2.startsWith("/")) {
                            String string3 = CacheEntry.ABSOLUTE_PATH_ESCAPE_CHAR + string2;
                            string = null;
                        } else {
                            int n = string2.lastIndexOf("/");
                            if (n > 0) {
                                String string4 = string2.substring(0, n);
                                if (string4.equals(string)) {
                                    String string5 = string2.substring(n);
                                } else {
                                    string = string4;
                                }
                            } else {
                                string = null;
                            }
                        }
                        objectOutputStream.writeUTF((String)var9_17);
                        String string6 = String.valueOf(nArray.length);
                        for (int i = 0; i < nArray.length; ++i) {
                            string6 = string6 + " " + nArray[i];
                        }
                        objectOutputStream.writeUTF(string6);
                    }
                    objectOutputStream.flush();
                } else {
                    objectOutputStream.writeInt(0);
                    objectOutputStream.flush();
                }
            }
            finally {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
        }

        public void put(CacheEntry cacheEntry) {
            this.cacheEntries.add(cacheEntry);
        }

        private String readLine(ObjectInputStream objectInputStream) throws IOException {
            try {
                return objectInputStream.readUTF();
            }
            catch (EOFException eOFException) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JarSigningData readSigningData(InputStream inputStream, CacheEntry cacheEntry) throws IOException, ClassNotFoundException {
            JarSigningData jarSigningData;
            block18: {
                ObjectInputStream objectInputStream = null;
                jarSigningData = null;
                try {
                    objectInputStream = new ObjectInputStream(inputStream);
                    boolean bl = objectInputStream.readBoolean();
                    boolean bl2 = objectInputStream.readBoolean();
                    boolean bl3 = objectInputStream.readBoolean();
                    int n = objectInputStream.readInt();
                    if (n <= 0) break block18;
                    jarSigningData = new JarSigningData(bl, bl2, bl3);
                    HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
                    HashMap<int[], CodeSource> hashMap2 = new HashMap<int[], CodeSource>();
                    CodeSigner[] codeSignerArray = new CodeSigner[n];
                    try {
                        for (int i = 0; i < n; ++i) {
                            codeSignerArray[i] = (CodeSigner)objectInputStream.readObject();
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException("Error reading signer certificates: " + classNotFoundException);
                    }
                    if (jarSigningData.hasStrictSingleSigning()) {
                        int[] nArray = new int[codeSignerArray.length];
                        for (int i = 0; i < codeSignerArray.length; ++i) {
                            nArray[i] = i;
                        }
                        CodeSource codeSource = cacheEntry.createCodeSource(codeSignerArray);
                        hashMap.put(null, nArray);
                        hashMap2.put(nArray, codeSource);
                    } else {
                        String string = this.readLine(objectInputStream);
                        String string2 = null;
                        HashMap<String, int[]> hashMap3 = new HashMap<String, int[]>();
                        while (string != null && !string.equals("")) {
                            String string3 = string;
                            if (string2 != null && string3.startsWith("/")) {
                                string3 = string2 + string3;
                            } else if (string3.startsWith(CacheEntry.ABSOLUTE_PATH_ESCAPE_CHAR)) {
                                string3 = string3.substring(1);
                                string2 = null;
                            } else {
                                int n2 = string3.lastIndexOf("/");
                                string2 = n2 > 0 ? string3.substring(0, n2) : null;
                            }
                            string = this.readLine(objectInputStream);
                            int[] nArray = (int[])hashMap3.get(string);
                            if (nArray == null) {
                                StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
                                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                                nArray = new int[n3];
                                for (int i = 0; i < n3; ++i) {
                                    nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                                }
                                hashMap3.put(string, nArray);
                                CodeSigner[] codeSignerArray2 = new CodeSigner[nArray.length];
                                for (int i = 0; i < nArray.length; ++i) {
                                    codeSignerArray2[i] = codeSignerArray[nArray[i]];
                                }
                                CodeSource codeSource = cacheEntry.createCodeSource(codeSignerArray2);
                                hashMap2.put(nArray, codeSource);
                            }
                            hashMap.put(string3, nArray);
                            string = this.readLine(objectInputStream);
                        }
                    }
                    jarSigningData.updateSignerInfo(codeSignerArray, hashMap, hashMap2);
                }
                finally {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
            }
            return jarSigningData;
        }

        public JarSigningData get(URL uRL, String string, CacheEntry cacheEntry) {
            JarSigningData jarSigningData = null;
            try {
                Pair pair = new Pair(uRL, string);
                if (this.ceToFile.containsKey(pair)) {
                    File file = new File(this.sessionFolder, (String)this.ceToFile.get(pair));
                    jarSigningData = this.readSigningData(new BufferedInputStream(new FileInputStream(file)), cacheEntry);
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            return jarSigningData;
        }

        private static class Pair
        implements Serializable {
            private URL jarLocation;
            private String jarVersion;

            public Pair(URL uRL, String string) {
                this.jarLocation = uRL;
                this.jarVersion = string;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Pair pair = (Pair)object;
                if (this.jarLocation != null ? !this.jarLocation.equals(pair.jarLocation) : pair.jarLocation != null) {
                    return false;
                }
                return !(this.jarVersion != null ? !this.jarVersion.equals(pair.jarVersion) : pair.jarVersion != null);
            }

            public int hashCode() {
                int n = this.jarLocation != null ? this.jarLocation.hashCode() : 0;
                n = 31 * n + (this.jarVersion != null ? this.jarVersion.hashCode() : 0);
                return n;
            }

            public String toString() {
                return "Pair{jarLocation=" + this.jarLocation + ", jarVersion='" + this.jarVersion + '\'' + '}';
            }
        }
    }
}

