/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.support.logging;

import java.util.ArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.springframework.roo.support.logging.DeferredLogHandler;
import org.springframework.roo.support.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HandlerUtils {
    public static final Logger getLogger(Class<?> clazz) {
        Assert.notNull(clazz, "Class required");
        Logger logger = Logger.getLogger(clazz.getName());
        if (logger.getLevel() == null && clazz.getName().startsWith("org.springframework.roo")) {
            logger.setLevel(Level.FINE);
        }
        return logger;
    }

    public static final int wrapWithDeferredLogHandler(Logger logger, Level fallbackSeverity) {
        Assert.notNull(logger, "Logger is required");
        Assert.notNull(fallbackSeverity, "Fallback severity is required");
        ArrayList<DeferredLogHandler> newHandlers = new ArrayList<DeferredLogHandler>();
        Handler[] handlers = logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                logger.removeHandler(h);
                newHandlers.add(new DeferredLogHandler(h, fallbackSeverity));
            }
        }
        if (newHandlers.size() == 0) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    return record.getMessage() + System.getProperty("line.separator");
                }
            });
            newHandlers.add(new DeferredLogHandler(consoleHandler, fallbackSeverity));
        }
        for (DeferredLogHandler h : newHandlers) {
            logger.addHandler(h);
        }
        return newHandlers.size();
    }

    public static final int registerTargetHandler(Logger logger, Handler target) {
        Assert.notNull(logger, "Logger is required");
        Assert.notNull(target, "Target handler is required");
        int replaced = 0;
        Handler[] handlers = logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                if (!(h instanceof DeferredLogHandler)) continue;
                ++replaced;
                DeferredLogHandler defLogger = (DeferredLogHandler)h;
                defLogger.setTargetHandler(target);
            }
        }
        return replaced;
    }

    public static final int flushAllHandlers(Logger logger) {
        Assert.notNull(logger, "Logger is required");
        int flushed = 0;
        Handler[] handlers = logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                ++flushed;
                h.flush();
            }
        }
        return flushed;
    }
}

