/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.adapter.common;

import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.cache.common.CacheController;
import com.vmware.vcim.ngc.service.cache.model.CacheEntry;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vise.usersession.UserSessionService;
import java.util.HashMap;
import java.util.Map;

public class DataAdapterContainer
implements AdapterWrapper,
DataAdapterFactory {
    private CacheController cacheController;
    private Map<String, DataAdapter> readOnlyAdapters;
    private Map<String, DataAdapter> readWriteAdapters;
    private UserSessionService userSessionService;
    private VcimSessionManager vcimSessionMgr;

    public DataAdapterContainer(CacheController cacheController, UserSessionService userSessionService, VcimSessionManager vcimSessionMgr) {
        this.cacheController = cacheController;
        this.vcimSessionMgr = vcimSessionMgr;
        this.readOnlyAdapters = new HashMap<String, DataAdapter>();
        this.readWriteAdapters = new HashMap<String, DataAdapter>();
        this.userSessionService = userSessionService;
    }

    @Override
    public void registerAdapter(DataAdapter adapter) {
        VchsObjectType objectType = adapter.getSupportedObjectType();
        DataAdapter.AdapterType adapterType = adapter.getAdapterType();
        if (adapterType == DataAdapter.AdapterType.READ_ONLY_ADAPTER) {
            this.readOnlyAdapters.put(objectType.value(), adapter);
        } else {
            this.readWriteAdapters.put(objectType.value(), adapter);
        }
    }

    @Override
    public DataAdapter getReadOnlyAdapter(VchsObjectType objectType) {
        if (this.cacheController.isCacheAvailable()) {
            DataAdapter dataAdapter = this.readOnlyAdapters.get(objectType.value());
            VCimSession vcimSession = null;
            if (null != this.userSessionService.getUserSession()) {
                vcimSession = this.vcimSessionMgr.getSession(this.userSessionService.getUserSession().clientId);
            }
            CacheEntry userEntry = null;
            if (null != vcimSession) {
                userEntry = this.cacheController.getCacheEntryForUser(vcimSession.getUsername());
            }
            if (null == dataAdapter || null == userEntry || null != userEntry && userEntry.isDirty()) {
                return this.readWriteAdapters.get(objectType.value());
            }
            return dataAdapter;
        }
        return this.readWriteAdapters.get(objectType.value());
    }

    @Override
    public DataAdapter getWritableAdapter(VchsObjectType objectType) {
        return this.readWriteAdapters.get(objectType.value());
    }
}

