/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.common;

import com.vmware.vcim.ngc.service.common.CommonUtils;
import com.vmware.vcim.ngc.service.rest.RestTemplateFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class CacheProxy {
    private RestTemplateFactory restTemplateFactory;
    private RestTemplate restTemplate;
    private String cacheUrl = "http://10.112.185.207:8080/cache-service";
    private String cacheUsername = "admin";
    private String cachePassword = "vmware";
    private String proxyUrl = null;
    private String proxyPort = null;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private boolean useProxy = false;
    private static final String MEDIA_SUB_TYPE = "xml";

    public CacheProxy(RestTemplateFactory restTemplateFactory) {
        this.restTemplateFactory = restTemplateFactory;
        restTemplateFactory.setMessageConverters(this.getMessageConvertors());
    }

    public void configCacheSystem(String cacheUrl, String cacheUsername, String cachePassword) {
        URI uri = URI.create(cacheUrl);
        this.restTemplate = this.restTemplateFactory.createRestTemplate(uri, cacheUsername, cachePassword, null, null, null, null, false);
    }

    public void configCacheSystem(String cacheUrl, String cacheUsername, String cachePassword, String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword, boolean useProxy) {
        this.cacheUrl = cacheUrl;
        this.cacheUsername = cacheUsername;
        this.cachePassword = cachePassword;
        this.proxyUrl = proxyUrl;
        this.proxyPassword = proxyPassword;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.useProxy = useProxy;
        URI uri = URI.create(cacheUrl);
        this.restTemplate = this.restTemplateFactory.createRestTemplate(uri, cacheUsername, cachePassword, proxyUrl, proxyPort, proxyUsername, proxyPassword, useProxy);
    }

    private <T> HttpEntity<T> execute(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity, Class<T> responseType) {
        if (url.startsWith("http://")) {
            url.replaceFirst("http://", "");
        }
        if (url.startsWith("https://")) {
            url.replaceFirst("https://", "");
        }
        url = this.cacheUrl + url;
        ResponseEntity responseEntity = this.restTemplate.exchange(url, httpMethod, requestEntity, responseType, new Object[0]);
        return responseEntity;
    }

    public <T> HttpEntity<T> sendGetRequest(String url, Class<T> responseType) {
        return this.sendGetRequest(url, responseType, null);
    }

    public <T> HttpEntity<T> sendGetRequest(String url, Class<T> responseType, Map<String, String> customHeaders) {
        HttpHeaders headers = this.initialize(customHeaders);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.execute(url, HttpMethod.GET, requestEntity, responseType);
    }

    public <S, T> HttpEntity<?> sendPostRequest(String url, T requestData, Class<S> responseType) {
        return this.sendPostRequest(url, requestData, responseType, null);
    }

    public <S, T> HttpEntity<?> sendPostRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders) {
        HttpHeaders headers = this.initialize(customHeaders);
        HttpEntity requestEntity = new HttpEntity(requestData, (MultiValueMap)headers);
        return this.execute(url, HttpMethod.POST, requestEntity, responseType);
    }

    public <S, T> HttpEntity<?> sendPutRequest(String url, T requestData, Class<S> responseType) {
        return this.sendPutRequest(url, requestData, responseType, null);
    }

    public <S, T> HttpEntity<?> sendPutRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders) {
        HttpHeaders headers = this.initialize(customHeaders);
        HttpEntity requestEntity = new HttpEntity(requestData, (MultiValueMap)headers);
        return this.execute(url, HttpMethod.PUT, requestEntity, responseType);
    }

    public <S, T> HttpEntity<?> sendDeleteRequest(String url, T requestData, Class<S> responseType) {
        return this.sendDeleteRequest(url, requestData, responseType, null);
    }

    public <S, T> HttpEntity<?> sendDeleteRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders) {
        HttpHeaders headers = this.initialize(customHeaders);
        HttpEntity requestEntity = new HttpEntity(requestData, (MultiValueMap)headers);
        return this.execute(url, HttpMethod.DELETE, requestEntity, responseType);
    }

    private HttpHeaders initialize(Map<String, String> customHeaders) {
        HttpHeaders headers = new HttpHeaders();
        String credential = "Basic " + CommonUtils.getBase64Encoding(this.cacheUsername + ":" + this.cachePassword);
        headers.set("Authorization", credential);
        headers.set("Accept", "application/xml");
        headers.set("Content-Type", "application/xml");
        return headers;
    }

    private List<HttpMessageConverter<?>> getMessageConvertors() {
        Jaxb2RootElementHttpMessageConverter converter = new Jaxb2RootElementHttpMessageConverter();
        ArrayList<MediaType> supportedTypes = new ArrayList<MediaType>();
        MediaType type = new MediaType("application", MEDIA_SUB_TYPE);
        supportedTypes.add(type);
        converter.setSupportedMediaTypes(supportedTypes);
        ArrayList lst = new ArrayList();
        lst.add((HttpMessageConverter<?>)converter);
        lst.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        return lst;
    }
}

