/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.common;

import com.vmware.vcim.ngc.service.cache.common.CacheProxy;
import com.vmware.vcim.ngc.service.cache.common.CloudObjectEntity;
import com.vmware.vcim.ngc.service.cache.helper.CloudInstanceVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.DatacenterVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.GatewayVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.TemplateVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.VmVpcHelper;
import com.vmware.vcim.ngc.service.cache.model.CacheEntries;
import com.vmware.vcim.ngc.service.cache.model.CacheEntry;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTreeFetcher {
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 10, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private ThreadPoolExecutor loaderExecutor = new ThreadPoolExecutor(1, 4, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private CloudInstanceVpcHelper cloudInstanceVpcHelper;
    private DatacenterVpcHelper datacenterVpcHelper;
    private GatewayVpcHelper gatewayVpcHelper;
    private TemplateVpcHelper templateVpcHelper;
    private VmVpcHelper vmVpcHelper;
    private VcimSessionManager vcimSessionMgr;
    private CacheProxy cacheProxy;
    private Set<String> objectTreeOwners;
    private Set<String> signedOutUsers;
    private final String KEY_PREFIX = "#x08ACacheK";
    private static final String QUERY_PARAM_USERNAME = "username=";
    private static final Logger logger = LoggerFactory.getLogger(ObjectTreeFetcher.class);

    public ObjectTreeFetcher(VcimSessionManager vcimSessionMgr, CacheProxy cacheProxy) {
        this.vcimSessionMgr = vcimSessionMgr;
        this.cacheProxy = cacheProxy;
        this.objectTreeOwners = new HashSet<String>();
        this.signedOutUsers = new HashSet<String>();
    }

    public CloudInstanceVpcHelper getCloudInstanceVpcHelper() {
        return this.cloudInstanceVpcHelper;
    }

    public void setCloudInstanceVpcHelper(CloudInstanceVpcHelper cloudInstanceVpcHelper) {
        this.cloudInstanceVpcHelper = cloudInstanceVpcHelper;
    }

    public DatacenterVpcHelper getDatacenterVpcHelper() {
        return this.datacenterVpcHelper;
    }

    public void setDatacenterVpcHelper(DatacenterVpcHelper datacenterVpcHelper) {
        this.datacenterVpcHelper = datacenterVpcHelper;
    }

    public GatewayVpcHelper getGatewayVpcHelper() {
        return this.gatewayVpcHelper;
    }

    public void setGatewayVpcHelper(GatewayVpcHelper gatewayVpcHelper) {
        this.gatewayVpcHelper = gatewayVpcHelper;
    }

    public TemplateVpcHelper getTemplateVpcHelper() {
        return this.templateVpcHelper;
    }

    public void setTemplateVpcHelper(TemplateVpcHelper templateVpcHelper) {
        this.templateVpcHelper = templateVpcHelper;
    }

    public VmVpcHelper getVmVpcHelper() {
        return this.vmVpcHelper;
    }

    public void setVmVpcHelper(VmVpcHelper vmVpcHelper) {
        this.vmVpcHelper = vmVpcHelper;
    }

    public void loadObjectTree(final String username) {
        this.loaderExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String lockString;
                String string = lockString = ObjectTreeFetcher.this.getLockString(username.toLowerCase());
                synchronized (string) {
                    if (ObjectTreeFetcher.this.signedOutUsers.contains(username.toLowerCase())) {
                        ObjectTreeFetcher.this.signedOutUsers.remove(username.toLowerCase());
                    }
                    if (ObjectTreeFetcher.this.objectTreeOwners.contains(username.toLowerCase())) {
                        logger.info("Cache population is already in progress for vCHS user - " + username);
                        return;
                    }
                    ObjectTreeFetcher.this.objectTreeOwners.add(username.toLowerCase());
                }
                String clientSessionId = ObjectTreeFetcher.this.vcimSessionMgr.getSessionForUser(username).getClientSessionId();
                LinkedList<CloudObjectEntity> objectQueue = new LinkedList<CloudObjectEntity>();
                CloudObjectEntity userObject = new CloudObjectEntity(VchsObjectType.VCHS_USER, clientSessionId, null);
                userObject.getObjectProperties().put("username", ObjectTreeFetcher.this.vcimSessionMgr.getSession(clientSessionId).getUsername());
                objectQueue.add(userObject);
                ObjectTreeFetcher.this.fetchObjectTree(objectQueue, clientSessionId);
            }
        });
    }

    public void cancelTreeLoading(String username) {
        this.signedOutUsers.add(username.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchObjectTree(Queue<CloudObjectEntity> objectQueue, String clientSessionId) {
        String username = this.vcimSessionMgr.getSession(clientSessionId).getUsername().toLowerCase();
        logger.info("Starting cache population for vCHS user - " + username);
        boolean moreElements = true;
        try {
            LinkedList runningTasks = new LinkedList();
            while (moreElements && !this.signedOutUsers.contains(username)) {
                if (!objectQueue.isEmpty()) {
                    CloudObjectEntity objectEntity = objectQueue.poll();
                    ObjectProcessor objectProcessor = new ObjectProcessor(objectQueue, objectEntity, clientSessionId);
                    Future future = this.executor.submit(objectProcessor);
                    runningTasks.add(future);
                }
                moreElements = false;
                for (Future future : runningTasks) {
                    if (future.isDone()) continue;
                    moreElements = true;
                    break;
                }
                if (moreElements || objectQueue.isEmpty()) continue;
                moreElements = true;
            }
            logger.info("Completed cache population for vCHS user - " + username);
            String url = "/user";
            url = this.getUserQualifiedUrl(url, clientSessionId);
            url = url.concat("&dirty=false");
            this.cacheProxy.sendPutRequest(url, null, null);
        }
        catch (Exception ex) {
        }
        finally {
            this.objectTreeOwners.remove(this.vcimSessionMgr.getSession(clientSessionId).getUsername().toLowerCase());
        }
    }

    private String getLockString(String key) {
        return ("#x08ACacheK" + key).intern();
    }

    public String getUserQualifiedUrl(String url, String clientSessionId) {
        VCimSession vcimSession = this.vcimSessionMgr.getSession(clientSessionId);
        return url.concat((url.endsWith("?") ? "" : "?") + QUERY_PARAM_USERNAME + vcimSession.getUsername().toLowerCase());
    }

    public void shutdownTreeFetcher() {
        try {
            this.executor.shutdown();
            this.loaderExecutor.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class ObjectProcessor
    implements Callable {
        private Queue<CloudObjectEntity> objectQueue;
        private CloudObjectEntity objectEntity;
        private String clientSessionId;

        ObjectProcessor(Queue<CloudObjectEntity> objectQueue, CloudObjectEntity objectEntity, String clientSessionId) {
            this.objectEntity = objectEntity;
            this.objectQueue = objectQueue;
            this.clientSessionId = clientSessionId;
        }

        public Object call() {
            VchsObjectType objectType = this.objectEntity.getObjectType();
            try {
                switch (objectType) {
                    case VCHS_USER: {
                        this.cacheUser(this.objectEntity.getObjectProperties().get("username"), true);
                        List<CloudObjectEntity> clouds = ObjectTreeFetcher.this.cloudInstanceVpcHelper.getPrivateClouds(this.clientSessionId);
                        clouds.addAll(ObjectTreeFetcher.this.cloudInstanceVpcHelper.getPublicClouds(this.clientSessionId));
                        this.cacheClouds(clouds);
                        this.objectQueue.addAll(clouds);
                        break;
                    }
                    case CLOUD: {
                        List<CloudObjectEntity> vdcs = ObjectTreeFetcher.this.datacenterVpcHelper.getDatacenters(this.clientSessionId, this.objectEntity);
                        String cloudId = this.objectEntity.getId();
                        this.cacheDatacenters(cloudId, vdcs);
                        this.objectQueue.addAll(vdcs);
                        break;
                    }
                    case DATACENTER: {
                        String vdcId = this.objectEntity.getId();
                        this.cacheDatacenterDetails(ObjectTreeFetcher.this.datacenterVpcHelper.getDatacenterDetails(this.clientSessionId, this.objectEntity));
                        this.cacheDatacenterUsers(vdcId, ObjectTreeFetcher.this.datacenterVpcHelper.getDatacenterUsers(this.clientSessionId, this.objectEntity));
                        this.cacheDatacenterNetworks(vdcId, ObjectTreeFetcher.this.datacenterVpcHelper.getDatacenterNetworks(this.clientSessionId, this.objectEntity));
                        List<CloudObjectEntity> vms = ObjectTreeFetcher.this.vmVpcHelper.getVirtualMachines(this.clientSessionId, this.objectEntity);
                        this.cacheVms(vdcId, vms);
                        List<CloudObjectEntity> gateways = ObjectTreeFetcher.this.gatewayVpcHelper.getGateways(this.clientSessionId, this.objectEntity);
                        this.cacheGateways(vdcId, gateways);
                        List<CloudObjectEntity> osCatalogs = ObjectTreeFetcher.this.templateVpcHelper.getOsCatalogs(this.clientSessionId, this.objectEntity);
                        this.cacheOsCatalogs(vdcId, osCatalogs);
                        List<CloudObjectEntity> myImages = ObjectTreeFetcher.this.templateVpcHelper.getMyImages(this.clientSessionId, this.objectEntity);
                        this.cacheMyImages(vdcId, myImages);
                        this.objectQueue.addAll(vms);
                        this.objectQueue.addAll(gateways);
                        break;
                    }
                    case VIRTUAL_MACHINE: {
                        this.cacheVmDetails(ObjectTreeFetcher.this.vmVpcHelper.getVirtualMachineDetails(this.clientSessionId, this.objectEntity));
                        break;
                    }
                    case GATEWAY: {
                        this.cacheGatewayNetworks(this.objectEntity.getId(), ObjectTreeFetcher.this.gatewayVpcHelper.getGatewayNetworks(this.clientSessionId, this.objectEntity));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private void cacheDatacenters(String cloudId, List<CloudObjectEntity> vdcs) {
            CacheEntries cacheEntries = this.getCacheEntriesFromObject(vdcs);
            String url = "/cloud/<CLOUD_ID>/vdc";
            url = url.replace("<CLOUD_ID>", cloudId);
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, cacheEntries, null);
        }

        private void cacheDatacenterUsers(String vdcId, List<CloudObjectEntity> vdcUsers) {
            CacheEntries cacheEntries = this.getCacheEntriesFromObject(vdcUsers);
            String url = "/vdc/<VDC_ID>/user";
            url = url.replace("<VDC_ID>", vdcId);
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, cacheEntries, null);
        }

        private void cacheDatacenterNetworks(String vdcId, List<CloudObjectEntity> vdcNetworks) {
            CacheEntries cacheEntries = this.getCacheEntriesFromObject(vdcNetworks);
            String url = "/vdc/<VDC_ID>/network";
            url = url.replace("<VDC_ID>", vdcId);
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, cacheEntries, null);
        }

        private void cacheDatacenterDetails(CloudObjectEntity vdcDetails) {
            CacheEntry cacheEntry = this.getCacheEntryFromObject(vdcDetails);
            String url = "/vdcdetail/<VDC_ID>";
            url = url.replace("<VDC_ID>", vdcDetails.getId());
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, cacheEntry, null);
        }

        private void cacheVms(String vdcId, List<CloudObjectEntity> vms) {
            CacheEntries cacheEntries = this.getCacheEntriesFromObject(vms);
            String url = "/vdc/<VDC_ID>/vm";
            url = url.replace("<VDC_ID>", vdcId);
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, cacheEntries, null);
        }

        private void cacheVmDetails(CloudObjectEntity vmDetails) {
            String vdcId = vmDetails.getObjectProperties().get("vdcId");
            String vmId = vmDetails.getId();
            String url = "/vdc/<VDC_ID>/vmdetail/<VM_ID>";
            url = url.replace("<VDC_ID>", vdcId);
            url = url.replace("<VM_ID>", vmId);
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            CacheEntry cacheEntry = new CacheEntry();
            cacheEntry.setId(vmId);
            cacheEntry.setXmlChunk(vmDetails.getPayload());
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, cacheEntry, null);
        }

        private void cacheOsCatalogs(String vdcId, List<CloudObjectEntity> osCatalogs) {
            CacheEntries cacheEntries = this.getCacheEntriesFromObject(osCatalogs);
            String url = "/vdc/<VDC_ID>/osCatalog";
            url = url.replace("<VDC_ID>", vdcId);
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, cacheEntries, null);
        }

        private void cacheMyImages(String vdcId, List<CloudObjectEntity> myImages) {
            CacheEntries cacheEntries = this.getCacheEntriesFromObject(myImages);
            String url = "/vdc/<VDC_ID>/myImage";
            url = url.replace("<VDC_ID>", vdcId);
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, cacheEntries, null);
        }

        private void cacheGateways(String vdcId, List<CloudObjectEntity> gateways) {
            CacheEntries cacheEntries = this.getCacheEntriesFromObject(gateways);
            String url = "/vdc/<VDC_ID>/gateway";
            url = url.replace("<VDC_ID>", vdcId);
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, cacheEntries, null);
        }

        private void cacheGatewayNetworks(String gatewayId, List<CloudObjectEntity> gatewayNetworks) {
            CacheEntries cacheEntries = this.getCacheEntriesFromObject(gatewayNetworks);
            String url = "/gateway/<GATEWAY_ID>/gatewaynetwork";
            url = url.replace("<GATEWAY_ID>", gatewayId);
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, cacheEntries, null);
        }

        private void cacheClouds(List<CloudObjectEntity> clouds) {
            for (CloudObjectEntity cloudObject : clouds) {
                String url = "/<REGION_ID>/cloud/<CLOUD_ID>";
                url = url.replace("<REGION_ID>", cloudObject.getObjectProperties().get("regionId"));
                url = url.replace("<CLOUD_ID>", cloudObject.getId());
                url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
                ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, this.getCacheEntryFromObject(cloudObject), null);
            }
        }

        private CacheEntries getCacheEntriesFromObject(List<CloudObjectEntity> objects) {
            CacheEntries cacheEntries = new CacheEntries();
            for (CloudObjectEntity object : objects) {
                CacheEntry cacheEntry = new CacheEntry();
                cacheEntry.setId(object.getId());
                cacheEntry.setXmlChunk(object.getPayload());
                cacheEntries.getCacheEntries().add(cacheEntry);
            }
            return cacheEntries;
        }

        private CacheEntry getCacheEntryFromObject(CloudObjectEntity object) {
            CacheEntry cacheEntry = new CacheEntry();
            cacheEntry.setId(object.getId());
            cacheEntry.setXmlChunk(object.getPayload());
            return cacheEntry;
        }

        private void cacheUser(String username, Boolean dirty) {
            String url = "/user";
            url = ObjectTreeFetcher.this.getUserQualifiedUrl(url, this.clientSessionId);
            url = url.concat("&dirty=" + dirty.toString());
            ObjectTreeFetcher.this.cacheProxy.sendPostRequest(url, null, null);
        }
    }
}

