/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.impl;

import com.vmware.ares.product.v2.DcSnapshotType;
import com.vmware.ares.vcd.v2.VdcSnapshotType;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.cache.common.CacheProxy;
import com.vmware.vcim.ngc.service.cache.impl.CacheAdapter;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.DcSnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VdcSnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.model.CacheEntries;
import com.vmware.vcim.ngc.service.cache.model.CacheEntry;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VCimRegion;
import com.vmware.vcim.ngc.service.model.VCimVpc;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.CloudInstanceOperations;
import com.vmware.vcim.ngc.service.vpc.impl.RegionVpcAdapter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class CloudInstanceCacheAdapter
extends CacheAdapter
implements CloudInstanceOperations,
DataAdapter {
    private RegionVpcAdapter regionAdapter;
    private CacheProxy cacheProxy;
    private DataAdapterFactory dataAdapterFactory;
    private JAXBContext dcSnapshotTypeWrapperContext;
    private JAXBContext vdcSnapshotTypeWrapperContext;
    private static final Logger logger = LoggerFactory.getLogger(CloudInstanceCacheAdapter.class);

    public CloudInstanceCacheAdapter(VcimSessionManager vcimSessionMgr, CacheProxy cacheProxy, RegionVpcAdapter regionAdapter) {
        super(vcimSessionMgr);
        this.cacheProxy = cacheProxy;
        this.regionAdapter = regionAdapter;
        try {
            this.dcSnapshotTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{DcSnapshotTypeWrapper.class});
            this.vdcSnapshotTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VdcSnapshotTypeWrapper.class});
        }
        catch (JAXBException e) {
            // empty catch block
        }
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimVpc> getVpcs(String clientSessionId) {
        ArrayList<VCimVpc> vPCs = new ArrayList<VCimVpc>();
        logger.info("Getting cloud instances for client request: " + clientSessionId);
        List<VCimRegion> regions = this.regionAdapter.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            vPCs.addAll(this.getVpcsForRegion(clientSessionId, region));
        }
        return vPCs;
    }

    @Override
    public VCimVpc getVpcById(String clientSessionId, String vpcId) {
        logger.info("Getting cloud instances for cloud Id: " + vpcId);
        List<VCimVpc> vPCs = this.getVpcs(clientSessionId);
        for (VCimVpc vpc : vPCs) {
            if (!vpc.getId().equals(vpcId)) continue;
            return vpc;
        }
        return null;
    }

    @Override
    public VCimVpc getVpc(String clientSessionId, URI vpcUri) {
        logger.info("Getting cloud instances based on cloud URI: " + vpcUri.toString());
        String regionId = VCimVpc.getRegionId(vpcUri);
        boolean isPrivate = VCimVpc.isPrivate(vpcUri);
        VCimRegion region = this.regionAdapter.getRegion(clientSessionId, regionId);
        List<Object> vPCs = new ArrayList();
        if (isPrivate) {
            logger.info("Requested cloud is private cloud: " + vpcUri.toString());
            vPCs = this.getPrivateVpcsForRegion(clientSessionId, region);
        } else {
            logger.info("Requested cloud is shared cloud: " + vpcUri.toString());
            vPCs = this.getSharedVpcsForRegion(clientSessionId, region);
        }
        for (VCimVpc vCimVpc : vPCs) {
            if (!vCimVpc.getUri().equals(vpcUri)) continue;
            return vCimVpc;
        }
        return null;
    }

    private List<VCimVpc> getVpcsForRegion(String clientSessionId, VCimRegion region) {
        ArrayList<VCimVpc> vPCs = new ArrayList<VCimVpc>();
        vPCs.addAll(this.getPrivateVpcsForRegion(clientSessionId, region));
        vPCs.addAll(this.getSharedVpcsForRegion(clientSessionId, region));
        return vPCs;
    }

    @Override
    public List<VCimVpc> getVpcsForRegion(String clientSessionId, String regionId) {
        ArrayList<VCimVpc> result = new ArrayList<VCimVpc>();
        List<VCimVpc> vPCs = this.getVpcs(clientSessionId);
        for (VCimVpc vpc : vPCs) {
            if (!vpc.getRegionId().equals(regionId)) continue;
            result.add(vpc);
        }
        return result;
    }

    private List<VCimVpc> getPrivateVpcsForRegion(String clientSessionId, VCimRegion region) {
        ArrayList<VCimVpc> privateVpcs = new ArrayList<VCimVpc>();
        String url = "/<REGION_ID>/cloud";
        url = url.replace("<REGION_ID>", region.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        logger.info("Getting dedicated clouds for region " + region.getName() + ": Url - " + url + ", Client Id - " + clientSessionId);
        ResponseEntity clouds = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
        for (CacheEntry cacheEntry : ((CacheEntries)clouds.getBody()).getCacheEntries()) {
            if (!cacheEntry.getId().startsWith("private~")) continue;
            DcSnapshotTypeWrapper dcSnapshotTypeWrapper = this.unmarshal(this.dcSnapshotTypeWrapperContext, cacheEntry.getXmlChunk(), DcSnapshotTypeWrapper.class);
            DcSnapshotType dc = dcSnapshotTypeWrapper.getDcSnapshotType();
            VCimVpc vCimVpc = new VCimVpc(dc, region.getId());
            vCimVpc.setRegionName(region.getName());
            logger.info("Got cloud " + vCimVpc.getName() + " for region " + region.getName());
            privateVpcs.add(vCimVpc);
        }
        return privateVpcs;
    }

    private List<VCimVpc> getSharedVpcsForRegion(String clientSessionId, VCimRegion region) {
        ArrayList<VCimVpc> sharedVpcs = new ArrayList<VCimVpc>();
        String url = "/<REGION_ID>/cloud";
        url = url.replace("<REGION_ID>", region.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity clouds = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
        for (CacheEntry cacheEntry : ((CacheEntries)clouds.getBody()).getCacheEntries()) {
            url = "/cloud/<CLOUD_ID>/vdc";
            url = url.replace("<CLOUD_ID>", cacheEntry.getId());
            if (!cacheEntry.getId().startsWith("public~")) continue;
            VdcSnapshotTypeWrapper vdcSnapshotTypeWrapper = this.unmarshal(this.vdcSnapshotTypeWrapperContext, cacheEntry.getXmlChunk(), VdcSnapshotTypeWrapper.class);
            VdcSnapshotType vdc = vdcSnapshotTypeWrapper.getVdcSnapshotType();
            VCimVpc vCimVpc = new VCimVpc(vdc, region.getId());
            vCimVpc.setRegionName(region.getName());
            logger.info("Got cloud " + vCimVpc.getName() + " for region " + region.getName());
            sharedVpcs.add(vCimVpc);
        }
        return sharedVpcs;
    }

    @Override
    public List<VCimVpc> getPrivateVpcs(String clientSessionId) {
        ArrayList<VCimVpc> vPCs = new ArrayList<VCimVpc>();
        logger.info("Private clouds requested for client Id - " + clientSessionId);
        List<VCimRegion> regions = this.regionAdapter.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            vPCs.addAll(this.getPrivateVpcsForRegion(clientSessionId, region));
        }
        return vPCs;
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_ONLY_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.CLOUD;
    }
}

