/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.impl;

import com.vmware.ares.vcd.v1.GatewaySnapshotType;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.cache.common.CacheProxy;
import com.vmware.vcim.ngc.service.cache.impl.CacheAdapter;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.GatewaySnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.model.CacheEntries;
import com.vmware.vcim.ngc.service.cache.model.CacheEntry;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VCimGateway;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.GatewayOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class GatewayCacheAdapter
extends CacheAdapter
implements GatewayOperations,
DataAdapter {
    private DataAdapterFactory dataAdapterFactory;
    private AdapterWrapper adapterWrapper;
    private CacheProxy cacheProxy;
    private static final Logger logger = LoggerFactory.getLogger(GatewayCacheAdapter.class);
    private JAXBContext gatewaySnapshotTypeWrapperContext;

    public GatewayCacheAdapter(VcimSessionManager vcimSessionMgr, CacheProxy cacheProxy, AdapterWrapper adapterWrapper) {
        super(vcimSessionMgr);
        this.cacheProxy = cacheProxy;
        this.adapterWrapper = adapterWrapper;
        try {
            this.gatewaySnapshotTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{GatewaySnapshotTypeWrapper.class});
        }
        catch (JAXBException e) {
            // empty catch block
        }
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimGateway> getGateways(String clientSessionId) {
        ArrayList<VCimGateway> gateways = new ArrayList<VCimGateway>();
        logger.info("Gateways requested for client request: " + clientSessionId);
        List<VCimVirtualDatacenter> vDCs = this.getVdcReadOnlyAdapter().getVDCs(clientSessionId);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                if (!vDC.isPrivate()) {
                    gateways.addAll(this.getSharedGateways(clientSessionId, vDC));
                    continue;
                }
                gateways.addAll(this.getPrivateGateways(clientSessionId, vDC));
            }
        }
        return gateways;
    }

    private List<VCimGateway> getSharedGateways(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching gateways for shared VDC: " + vDC.getName());
        List<VCimGateway> gateways = null;
        String url = "/vdc/<VDC_ID>/gateway";
        url = url.replace("<VDC_ID>", vDC.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        gateways = this.getGateways(clientSessionId, url, "", vDC.getId());
        for (VCimGateway gateway : gateways) {
            gateway.setVDCName(vDC.getName());
            gateway.setPrivateGateway(!vDC.isSharedVdc());
        }
        return gateways;
    }

    private List<VCimGateway> getPrivateGateways(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching gateways for dedicated VDC: " + vDC.getName());
        List<VCimGateway> gateways = null;
        String url = "/vdc/<VDC_ID>/gateway";
        url = url.replace("<VDC_ID>", vDC.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        gateways = this.getGateways(clientSessionId, url, vDC.getCloudId(), vDC.getId());
        for (VCimGateway gateway : gateways) {
            gateway.setVDCName(vDC.getName());
            gateway.setPrivateGateway(!vDC.isSharedVdc());
        }
        return gateways;
    }

    private List<VCimGateway> getGateways(String clientSessionId, String url, String vpcId, String vdcId) {
        logger.info("Fetching gateways for cloud Id - " + vpcId + ", vdc Id - " + vdcId);
        ArrayList<VCimGateway> gateways = new ArrayList<VCimGateway>();
        ResponseEntity gatewayResponse = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class, null);
        if (null != gatewayResponse) {
            CacheEntries gatewayEntries = (CacheEntries)gatewayResponse.getBody();
            for (CacheEntry gatewayEntry : gatewayEntries.getCacheEntries()) {
                GatewaySnapshotTypeWrapper gatewaySnapshotTypeWrapper = this.unmarshal(this.gatewaySnapshotTypeWrapperContext, gatewayEntry.getXmlChunk(), GatewaySnapshotTypeWrapper.class);
                GatewaySnapshotType gatewaySnapshot = gatewaySnapshotTypeWrapper.getGatewaySnapshotType();
                VCimGateway gateway = new VCimGateway(gatewaySnapshot);
                gateway.setVpcId(vpcId);
                gateway.setVdcId(vdcId);
                gateways.add(gateway);
            }
        }
        return gateways;
    }

    @Override
    public VCimGateway getGateway(String clientSessionId, URI gatewayUri) {
        logger.info("Fetching gateway with URI: " + gatewayUri.toString());
        List<Object> gateways = new ArrayList();
        String vdcId = VCimGateway.getVdcId(gatewayUri);
        VCimVirtualDatacenter vDC = this.getVdcReadOnlyAdapter().getVDCById(clientSessionId, vdcId);
        if (vDC != null) {
            gateways = !vDC.isPrivate() ? this.getSharedGateways(clientSessionId, vDC) : this.getPrivateGateways(clientSessionId, vDC);
        }
        for (VCimGateway gateway : gateways) {
            if (!gateway.getUri().equals(gatewayUri)) continue;
            logger.info("Gateway found for URI: " + gatewayUri.toString());
            return gateway;
        }
        return null;
    }

    @Override
    public void addGateway(String clientSessionId, String vpcId, String vdcId, String gatewayName, String gatewayDesc, int gatewayIpCount) {
    }

    @Override
    public List<VCimGateway> getGatewaysForVDC(String clientSessionId, String vpcId, String vdcId) {
        List<VCimGateway> gateways = null;
        logger.info("Fetching gateways for cloud Id - " + vpcId + ", vdc Id - " + vdcId);
        VCimVirtualDatacenter vDC = this.getVdcReadOnlyAdapter().getVDCById(clientSessionId, vdcId);
        if (vDC != null) {
            gateways = !vDC.isPrivate() ? this.getSharedGateways(clientSessionId, vDC) : this.getPrivateGateways(clientSessionId, vDC);
        }
        return gateways;
    }

    @Override
    public void updateGateway(String clientSessionId, String href, String gatewayName, String gatewayDesc) {
    }

    @Override
    public void deleteGateway(String clientSessionId, String href) {
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_ONLY_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.GATEWAY;
    }

    private VirtualDatacenterOperations getVdcReadOnlyAdapter() {
        return (VirtualDatacenterOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.DATACENTER));
    }
}

