/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.vpc.impl;

import com.vmware.ares.vcd.v1.VmSettingsType;
import com.vmware.ares.vcd.v2.VMListType;
import com.vmware.ares.vcd.v2.VMRecordType;
import com.vmware.vcim.ngc.service.cache.common.CloudObjectEntity;
import com.vmware.vcim.ngc.service.cache.helper.VmVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.VpcHelper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VMRecordTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VmSettingsTypeWrapper;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.springframework.http.ResponseEntity;

public class VmVpcHelperImpl
extends VpcHelper
implements VmVpcHelper {
    private JAXBContext vmRecordTypeWrapperContext;
    private JAXBContext vmSettingsTypeWrapperContext;

    public VmVpcHelperImpl(VcimRestClient vcimRestClient, VcimSessionManager vcimSessionMgr) {
        super(vcimRestClient, vcimSessionMgr);
        try {
            this.vmRecordTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VMRecordTypeWrapper.class});
            this.vmSettingsTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VmSettingsTypeWrapper.class});
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    @Override
    public List<CloudObjectEntity> getVirtualMachines(String clientSessionId, CloudObjectEntity vdcObject) {
        boolean isShared = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isShared"));
        boolean isDr2c = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isDR2C"));
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/vms";
        if (isShared) {
            url = isDr2c ? "/api/private/dr2c/<VDC_ID>/vms" : "/api/private/vpc/<VDC_ID>/vms";
        } else {
            String cloudId = vdcObject.getObjectProperties().get("cloudId");
            cloudId = cloudId.substring(cloudId.indexOf("~") + 1);
            url = url.replace("<VPC_ID>", cloudId);
        }
        url = url.replace("<VDC_ID>", vdcObject.getId());
        ResponseEntity vmsResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VMListType.class, null, clientSessionId);
        ArrayList<CloudObjectEntity> vmObjects = new ArrayList<CloudObjectEntity>();
        if (null != vmsResponse) {
            VMListType vmList = (VMListType)vmsResponse.getBody();
            for (VMRecordType vmRecord : vmList.getVMRecord()) {
                VMRecordTypeWrapper vmRecordTypeWrapper = new VMRecordTypeWrapper();
                vmRecordTypeWrapper.setVmRecordType(vmRecord);
                String payload = this.marshal(this.vmRecordTypeWrapperContext, vmRecordTypeWrapper);
                CloudObjectEntity vmObject = new CloudObjectEntity(VchsObjectType.VIRTUAL_MACHINE, vmRecord.getId(), payload);
                if (!isShared) {
                    vmObject.getObjectProperties().put("cloudId", vdcObject.getObjectProperties().get("cloudId"));
                }
                vmObject.setObjectProperties(vdcObject.getObjectProperties());
                vmObject.getObjectProperties().put("vdcId", vdcObject.getId());
                vmObject.getObjectProperties().put("vappId", vmRecord.getVAppDetails().getVAPP());
                vmObjects.add(vmObject);
            }
        }
        return vmObjects;
    }

    @Override
    public CloudObjectEntity getVirtualMachineDetails(String clientSessionId, CloudObjectEntity vmObject) {
        boolean isShared = null == vmObject.getObjectProperties().get("cloudId");
        boolean isDr2c = null != vmObject.getObjectProperties().get("isDR2C");
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/vapp/<VAPP_ID>/vm/<VM_ID>";
        if (isShared) {
            url = isDr2c ? "/api/private/dr2c/<VDC_ID>/vapp/<VAPP_ID>/vm/<VM_ID>" : "/api/private/vpc/<VDC_ID>/vapp/<VAPP_ID>/vm/<VM_ID>";
        } else {
            String cloudId = vmObject.getObjectProperties().get("cloudId");
            cloudId = cloudId.substring(cloudId.indexOf("~") + 1);
            url = url.replace("<VPC_ID>", cloudId);
        }
        String vdcId = vmObject.getObjectProperties().get("vdcId");
        String vmId = vmObject.getId();
        url = url.replace("<VDC_ID>", vdcId);
        url = url.replace("<VAPP_ID>", vmObject.getObjectProperties().get("vappId"));
        url = url.replace("<VM_ID>", vmId);
        ResponseEntity vmResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VmSettingsType.class, null, clientSessionId);
        VmSettingsTypeWrapper vmSettingsTypeWrapper = new VmSettingsTypeWrapper();
        vmSettingsTypeWrapper.setVmSettingsType((VmSettingsType)vmResponse.getBody());
        CloudObjectEntity vmObjectDetails = new CloudObjectEntity(VchsObjectType.VIRTUAL_MACHINE, vmId, this.marshal(this.vmSettingsTypeWrapperContext, vmSettingsTypeWrapper));
        vmObjectDetails.setObjectProperties(vmObject.getObjectProperties());
        return vmObjectDetails;
    }
}

