/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.common;

import com.vmware.vise.usersession.UserSessionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public final class CommonUtils {
    public static String getBaseUrlString(String scheme, String host, int port) {
        StringBuffer urlStringBuffer = new StringBuffer(scheme).append("://").append(host);
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            urlStringBuffer.append(':');
            urlStringBuffer.append(port);
        }
        return String.valueOf(urlStringBuffer);
    }

    public static String getHighestSupportedApiVersion(Set<String> versions) {
        int major = 0;
        int minor = 0;
        int patch = 0;
        String highestVersion = null;
        for (String version : versions) {
            String[] parts = version.split("\\.");
            int currMajor = 0;
            int currMinor = 0;
            int currPatch = 0;
            if (parts.length > 0 && (currMajor = CommonUtils.parseIntSafely(parts[0])) < major) continue;
            if (parts.length > 1) {
                currMinor = CommonUtils.parseIntSafely(parts[1]);
            }
            if (parts.length > 2) {
                currPatch = CommonUtils.parseIntSafely(parts[2]);
            }
            if (currMajor > major) {
                major = currMajor;
                minor = currMinor;
                patch = currPatch;
                highestVersion = version;
                continue;
            }
            if (currMinor > minor) {
                minor = currMinor;
                highestVersion = version;
                continue;
            }
            if (currMinor != minor || currPatch <= patch) continue;
            patch = currPatch;
            highestVersion = version;
        }
        return highestVersion;
    }

    private static int parseIntSafely(String string) {
        int result = 0;
        try {
            result = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static List<String> listIpAddresses(String startAddress, String endAddress) {
        ArrayList<String> ipAddresses = new ArrayList<String>();
        if (StringUtils.isBlank((String)startAddress) || StringUtils.isBlank((String)endAddress)) {
            return ipAddresses;
        }
        long startIp = 0L;
        for (String byteString : startAddress.split("\\.")) {
            startIp = startIp << 8 | (long)Integer.parseInt(byteString);
        }
        long endIp = 0L;
        for (String byteString : endAddress.split("\\.")) {
            endIp = endIp << 8 | (long)Integer.parseInt(byteString);
        }
        for (long ip = startIp; ip <= endIp; ++ip) {
            ipAddresses.add(((ip & 0xFFFFFFFFFF000000L) >> 24) + "." + ((ip & 0xFF0000L) >> 16) + "." + ((ip & 0xFF00L) >> 8) + "." + (ip & 0xFFL));
        }
        return ipAddresses;
    }

    public static String getBase64Encoding(String key) {
        Base64 base64 = new Base64();
        return base64.encodeAsString(key.getBytes());
    }

    public static String getClientSessionId(UserSessionService userSessionService) {
        return userSessionService.getUserSession().clientId;
    }

    public static String getUserName(String clientSessionId) {
        String[] idParts = clientSessionId.split("#");
        return idParts[0];
    }

    public static String getClientId(String clientSessionId) {
        String[] idParts = clientSessionId.split("#");
        return idParts[1];
    }
}

