/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.common;

import com.vmware.vcim.ngc.service.common.QueryCallback;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtil {
    private QueryCallback callback;
    private QueryCounter queryCounter;
    private QueryResultMapper queryResultMapper;
    private static final Logger logger = LoggerFactory.getLogger(QueryUtil.class);

    public QueryUtil(QueryCallback callback) {
        this.callback = callback;
        this.queryCounter = new QueryCounter();
        this.queryResultMapper = new QueryResultMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResults(String identifier, Object ... arguments) {
        String key = identifier;
        try {
            Object result;
            Object object = this.queryCounter;
            synchronized (object) {
                this.queryCounter.incrementCount(key);
            }
            object = key.intern();
            synchronized (object) {
                QueryResultMapper.ResultState resultState = this.queryResultMapper.getResultState(key);
                if (QueryResultMapper.ResultState.NOT_AVAILABLE == resultState) {
                    this.queryResultMapper.insert(key, null);
                    Object result2 = this.callback.execute(identifier, arguments);
                    this.queryResultMapper.insert(key, result2);
                }
            }
            Object object2 = result = this.queryResultMapper.getResult(key);
            return object2;
        }
        catch (Exception ex) {
            logger.error("Failed operation - " + identifier, (Throwable)ex);
            Object var5_8 = null;
            return var5_8;
        }
        finally {
            QueryCounter queryCounter = this.queryCounter;
            synchronized (queryCounter) {
                int waitingQueries = this.queryCounter.decrementCount(key);
                if (0 == waitingQueries) {
                    this.queryResultMapper.remove(key);
                }
            }
        }
    }

    private static class QueryResultMapper {
        private HashMap<String, Object> map = new HashMap();

        public synchronized ResultState getResultState(String key) {
            ResultState resultState = ResultState.NOT_AVAILABLE;
            if (this.map.containsKey(key)) {
                Object result = this.map.get(key);
                resultState = null == result ? ResultState.CALCULATING : ResultState.AVAILABLE;
            }
            return resultState;
        }

        public synchronized Object getResult(String key) {
            return this.map.get(key);
        }

        public synchronized void insert(String key, Object value) {
            this.map.put(key, value);
        }

        public synchronized void remove(String key) {
            this.map.remove(key);
        }

        public static enum ResultState {
            CALCULATING,
            AVAILABLE,
            NOT_AVAILABLE;

        }
    }

    private static class QueryCounter {
        private HashMap<String, Integer> map = new HashMap();

        public synchronized void incrementCount(String key) {
            Integer count = 1;
            if (this.map.containsKey(key)) {
                Integer n = count = this.map.get(key);
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            this.map.put(key, count);
        }

        public synchronized int decrementCount(String key) {
            Integer count = 0;
            if (this.map.containsKey(key)) {
                Integer n = count = this.map.get(key);
                Integer n2 = count = Integer.valueOf(count - 1);
                if (0 == count) {
                    this.map.remove(key);
                } else {
                    this.map.put(key, count);
                }
            }
            return count;
        }
    }
}

