/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

public class UriUtils {
    public static URI createURIUsingDefaults(String type, String ... uriParts) {
        return UriUtils.createURI("vcim", "comvmwarevcimngc", type, uriParts);
    }

    private static URI createURI(String scheme, String namespace, String type, String ... ids) {
        URI uri = null;
        if (scheme != null && namespace != null && type != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(scheme);
            sb.append(":");
            sb.append(namespace);
            sb.append(":");
            sb.append(type);
            if (ids.length > 0) {
                sb.append(":");
                sb.append("/api");
                if (ids.length > 0) {
                    for (int idx = 0; idx < ids.length; ++idx) {
                        sb.append("/");
                        sb.append(UriUtils.encodeURIStringComponent(ids[idx]));
                    }
                }
                try {
                    uri = new URI(sb.toString());
                }
                catch (URISyntaxException ex) {
                    // empty catch block
                }
            }
        }
        return uri;
    }

    private static String encodeURIStringComponent(String str) {
        return str.replaceAll(" ", "%20");
    }

    private static String decodeUriStringComponent(String str) {
        return str.replaceAll("%20", " ");
    }

    public static String getTypeFromUri(URI uri) {
        String objUri = uri.toString();
        String[] uriParts = objUri.split(":");
        if (uriParts.length > 3) {
            return uriParts[uriParts.length - 2];
        }
        if (uriParts.length == 3) {
            return uriParts[uriParts.length - 1];
        }
        return null;
    }

    public static String getUrlFromUri(URI uri) {
        String objUri = uri.toString();
        String[] uriParts = objUri.split(":");
        if (uriParts.length > 3) {
            return uriParts[uriParts.length - 1];
        }
        return null;
    }

    public static String[] getUrlPartsFromUri(URI uri) {
        String urlString = UriUtils.getUrlFromUri(uri);
        return UriUtils.getUrlParts(urlString);
    }

    private static String[] getUrlParts(String url) {
        url = url.substring(1);
        String[] urlParts = url.split("/");
        for (int idx = 0; idx < urlParts.length; ++idx) {
            urlParts[idx] = UriUtils.decodeUriStringComponent(urlParts[idx]);
        }
        String[] result = Arrays.copyOfRange(urlParts, 1, urlParts.length);
        return result;
    }
}

